/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.yy.base.imageloader.ImageData;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IBitmapChecker;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.mixmodule.feedback.BitmapInfo;
import com.yy.hiyo.mixmodule.feedback.CheckType;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JL\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JD\u0010\u001c\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0002JL\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/yy/hiyo/mixmodule/feedback/BitmapChecker;", "Lcom/yy/base/memoryrecycle/views/IBitmapChecker;", "()V", "BITMAP_SIZE_THRESHOLD", "", "SIZE_TIME_THRESHOLD", "", "TAG", "", "bitmapRecords", "", "Lcom/yy/hiyo/mixmodule/feedback/BitmapInfo;", "check", "", "imageView", "Landroid/widget/ImageView;", "bitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "checkBitmap", "checkBitmapInner", "bitmapHeight", "bitmapWidth", "width", "height", "url", "placeHolderIdName", "checkResizeParam", "getSnapshotPhotoPath", "getViewPath", "view", "Landroid/view/View;", "reportHiido", "type", "Lcom/yy/hiyo/mixmodule/feedback/CheckType;", "viewPath", "saveBitmapFile", "mixmodule_debug"})
public final class BitmapChecker
implements IBitmapChecker {
    @NotNull
    public static final String TAG = "BitmapChecker";
    private static final List<BitmapInfo> bitmapRecords;
    private static final double SIZE_TIME_THRESHOLD = 1.5;
    private static final int BITMAP_SIZE_THRESHOLD = 200;
    public static final BitmapChecker INSTANCE;

    public void check(@NotNull ImageView imageView, @Nullable Drawable drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            return;
        }
        Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.checkBitmap(bitmap, imageView);
    }

    public void check(@NotNull ImageView imageView, @Nullable Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.checkBitmap(bitmap, imageView);
    }

    private final void checkBitmap(Bitmap bitmap, ImageView imageView) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        if (bitmapWidth < 200 || bitmapHeight < 200) {
            return;
        }
        ImageData dataObject = ImageLoader.checkData((ImageView)imageView);
        String url = null;
        String placeHolderIdName = null;
        if (dataObject instanceof ImageData) {
            url = dataObject.url;
            int placeHolderId = dataObject.placeholderId;
            if (placeHolderId != -1 && placeHolderId != 0) {
                try {
                    placeHolderIdName = imageView.getResources().getResourceEntryName(placeHolderId);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"checkBitmap ", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        int width = imageView.getWidth();
        int height = imageView.getHeight();
        this.checkResizeParam(url, imageView, width, height, bitmapWidth, bitmapHeight, placeHolderIdName);
        if (width == 0 || height == 0) {
            return;
        }
        this.checkBitmapInner(bitmapHeight, bitmapWidth, width, height, imageView, url, placeHolderIdName, bitmap);
    }

    private final void checkBitmapInner(int bitmapHeight, int bitmapWidth, int width, int height, ImageView imageView, String url, String placeHolderIdName, Bitmap bitmap) {
        if ((double)(bitmapHeight * bitmapWidth) < (double)(width * height) * 1.5) {
            return;
        }
        BitmapInfo bitmapInfo = new BitmapInfo(bitmapWidth, bitmapHeight);
        if (bitmapRecords.contains(bitmapInfo)) {
            return;
        }
        String viewPath = this.getViewPath((View)imageView);
        String reportMsg = "Bitmap Monitor - Bitmap size illegal: Bitmap = " + bitmapWidth + " x " + bitmapHeight + ", " + "View =" + width + " X " + height + ", url = " + url + ", placeholder = " + placeHolderIdName + ", " + "ViewPath = " + viewPath;
        MLog.error((Object)TAG, (String)reportMsg, (Object[])new Object[0]);
        bitmapRecords.add(bitmapInfo);
        YYTaskExecutor.execute((Runnable)new Runnable(width, height, bitmapWidth, bitmapHeight, viewPath, placeHolderIdName, url, bitmap){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ int $bitmapWidth;
            final /* synthetic */ int $bitmapHeight;
            final /* synthetic */ String $viewPath;
            final /* synthetic */ String $placeHolderIdName;
            final /* synthetic */ String $url;
            final /* synthetic */ Bitmap $bitmap;

            public final void run() {
                block3: {
                    String it;
                    boolean bl;
                    boolean bl2;
                    String string2;
                    String imagePath;
                    BitmapChecker.access$reportHiido(BitmapChecker.INSTANCE, CheckType.BITMAP_SIZE, this.$width, this.$height, this.$bitmapWidth, this.$bitmapHeight, this.$viewPath, this.$placeHolderIdName, this.$url);
                    boolean bl3 = SettingFlags.getBoolean((String)"bitmap_check_switch", (boolean)false);
                    if (!bl3) {
                        return;
                    }
                    String string3 = imagePath = BitmapChecker.access$saveBitmapFile(BitmapChecker.INSTANCE, this.$bitmap);
                    if (string3 == null) break block3;
                    String string4 = string3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it2 = string4;
                    boolean bl6 = false;
                    Message msg = Message.obtain();
                    msg.what = BaseMsgDef.REPORT_BUG;
                    Bundle bundle = new Bundle();
                    bundle.putString("img_path", imagePath);
                    bundle.putInt("bitmap_width", this.$bitmapWidth);
                    bundle.putInt("bitmap_height", this.$bitmapHeight);
                    bundle.putInt("view_width", this.$width);
                    bundle.putInt("view_height", this.$height);
                    bundle.putString("view_path", this.$viewPath);
                    String string5 = this.$url;
                    if (string5 != null) {
                        string2 = string5;
                        bl2 = false;
                        bl = false;
                        it = string2;
                        boolean bl7 = false;
                        bundle.putString("url", this.$url);
                    }
                    String string6 = this.$placeHolderIdName;
                    if (string6 != null) {
                        string2 = string6;
                        bl2 = false;
                        bl = false;
                        it = string2;
                        boolean bl8 = false;
                        bundle.putString("placeholder_id_name", this.$placeHolderIdName);
                    }
                    Message message = msg;
                    Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"msg");
                    message.setData(bundle);
                    MsgDispatcher.getInstance().sendMessage(msg);
                }
            }
            {
                this.$width = n;
                this.$height = n2;
                this.$bitmapWidth = n3;
                this.$bitmapHeight = n4;
                this.$viewPath = string2;
                this.$placeHolderIdName = string3;
                this.$url = string4;
                this.$bitmap = bitmap;
            }
        });
    }

    private final void checkResizeParam(String url, ImageView imageView, int width, int height, int bitmapWidth, int bitmapHeight, String placeHolderIdName) {
        if (url == null) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)"x-oss-process=image", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)url, (CharSequence)"resize", (boolean)false, (int)2, null)) {
            String viewPath = this.getViewPath((View)imageView);
            this.reportHiido(CheckType.RESIZE, width, height, bitmapWidth, bitmapHeight, viewPath, placeHolderIdName, url);
        }
    }

    private final void reportHiido(CheckType type, int width, int height, int bitmapWidth, int bitmapHeight, String viewPath, String placeHolderIdName, String url) {
        String it;
        boolean bl;
        boolean bl2;
        String string2;
        StatisContent statisContent = new StatisContent();
        boolean bl3 = false;
        boolean bl4 = false;
        StatisContent $this$apply = statisContent;
        boolean bl5 = false;
        $this$apply.put("act", "hagomemoryperf");
        $this$apply.put("view_size", "" + width + '-' + height);
        $this$apply.put("bitmap_size", "" + bitmapWidth + '-' + bitmapHeight);
        $this$apply.put("view_path", viewPath);
        $this$apply.put("screens_size", "" + ResolutionUtils.getScreenWidth() + '-' + ResolutionUtils.getScreenHeight());
        String string3 = placeHolderIdName;
        if (string3 != null) {
            string2 = string3;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl6 = false;
            $this$apply.put("placeholder", placeHolderIdName);
        }
        String string4 = url;
        if (string4 != null) {
            string2 = string4;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl7 = false;
            $this$apply.put("url", url);
        }
        $this$apply.put("type", type == CheckType.BITMAP_SIZE ? "resize_check" : "bitmap_check");
        MLog.info((Object)TAG, (String)$this$apply.toString(), (Object[])new Object[0]);
        HiidoStatis.reportContent((StatisContent)$this$apply);
    }

    private final String saveBitmapFile(Bitmap bitmap) {
        String mCoverPath = this.getSnapshotPhotoPath();
        File file = new File(mCoverPath);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
            bos.flush();
            bos.close();
            MLog.info((Object)TAG, (String)("saveBitmapFile finish path:" + mCoverPath), (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return mCoverPath;
    }

    private final String getSnapshotPhotoPath() {
        StringBuilder stringBuilder = new StringBuilder();
        FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
        String photoPath = stringBuilder.append(fileStorageUtils.getInternalCacheRootDir()).append(File.separator).append("performance").append(File.separator).append("bigImage").append(File.separator).append(System.currentTimeMillis()).append(".jpg").toString();
        YYFileUtils.createFile((String)photoPath);
        return photoPath;
    }

    private final String getViewPath(View view) {
        View targetView = view;
        StringBuilder path = new StringBuilder("");
        try {
            while (true) {
                String name = targetView.getClass().getSimpleName();
                if (targetView.getParent() != null) {
                    ViewParent nextView;
                    ViewParent viewParent = targetView.getParent();
                    if (viewParent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.View");
                    }
                    View parent = (View)viewParent;
                    String idName = null;
                    if (targetView.getId() != -1) {
                        idName = view.getResources().getResourceEntryName(targetView.getId());
                    }
                    if (parent instanceof ViewGroup) {
                        int index = ((ViewGroup)parent).indexOfChild(targetView);
                        path.append(name).append("" + '(' + index + ')');
                        if (!TextUtils.isEmpty((CharSequence)idName)) {
                            path.append('#' + idName);
                        }
                        path.append("/");
                    }
                    if ((nextView = parent.getParent()) instanceof View) {
                        targetView = parent;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String string2 = path.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path.toString()");
        return string2;
    }

    private BitmapChecker() {
    }

    static {
        BitmapChecker bitmapChecker;
        INSTANCE = bitmapChecker = new BitmapChecker();
        boolean bl = false;
        bitmapRecords = new ArrayList();
    }

    public static final /* synthetic */ void access$reportHiido(BitmapChecker $this, CheckType type, int width, int height, int bitmapWidth, int bitmapHeight, String viewPath, String placeHolderIdName, String url) {
        $this.reportHiido(type, width, height, bitmapWidth, bitmapHeight, viewPath, placeHolderIdName, url);
    }

    public static final /* synthetic */ String access$saveBitmapFile(BitmapChecker $this, Bitmap bitmap) {
        return $this.saveBitmapFile(bitmap);
    }
}

