/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.fdwatch;

import com.yy.appbase.extensions.AppBaseExtensionKt;
import com.yy.base.env.RuntimeContext;
import com.yy.base.fdutils.FdsController;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class FdOverFlowMonitor {
    private static int OVER_FLOW_VALUE = AppBaseExtensionKt.isDebugForEnv() ? 600 : 600;
    private static volatile boolean sStarted;

    public static void start() {
        if (RuntimeContext.sIsDebuggable || !SystemUtils.isShowEnvSetting()) {
            return;
        }
        if (sStarted) {
            return;
        }
        sStarted = true;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                FdOverFlowMonitor.monitor();
            }
        });
    }

    private static void monitor() {
        if (!sStarted) {
            return;
        }
        FdsController.getFilesNumber((FdsController.CallBack)new FdsController.CallBack<Integer>(){

            public void onSuccess(final Integer count) {
                if (count > OVER_FLOW_VALUE) {
                    FdsController.getFilesDetailInfoStr((FdsController.CallBack)new FdsController.CallBack<String>(){

                        public void onSuccess(String data) {
                            YYTaskExecutor.execute(() -> {
                                OVER_FLOW_VALUE = OVER_FLOW_VALUE + 1024;
                                StatisContent statContent = new StatisContent();
                                statContent.put("act", "hagoperf");
                                statContent.put("ifield", count.intValue());
                                statContent.put("ifieldtwo", FdsController.getMaxFDCount());
                                statContent.put("sfieldtwo", FdsController.readLimitsFile());
                                statContent.put("perftype", "fdmonitor");
                                HiidoStatis.reportContent((StatisContent)statContent);
                            });
                        }
                    });
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FdOverFlowMonitor.monitor();
                    }
                }, (long)(RuntimeContext.sIsForeground ? 8000L : 15000L));
            }
        });
    }
}

