/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.ui.viewholder;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.yy.hiyo.mixmodule.discover.bean.IItemViewHolderFactory;
import com.yy.hiyo.mixmodule.discover.bean.RecommendUserDataType;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.AvatarViewHolderFactory;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.PeopleLocationHolderFactory;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.TopGapViewHolderFactory;

public class PeopleViewHolderFactory {
    private final SparseArray<IItemViewHolderFactory> mViewHolderMap = new SparseArray(3);

    private PeopleViewHolderFactory() {
        this.init();
    }

    public static PeopleViewHolderFactory getInstance() {
        return InstanceHolder.instance;
    }

    private void init() {
        this.mViewHolderMap.put(1000, (Object)new TopGapViewHolderFactory());
        this.mViewHolderMap.put(1003, (Object)new AvatarViewHolderFactory());
        this.mViewHolderMap.put(1001, (Object)new TopGapViewHolderFactory());
        this.mViewHolderMap.put(1004, (Object)new PeopleLocationHolderFactory());
    }

    @NonNull
    public IItemViewHolderFactory getViewHolderWithType(@RecommendUserDataType int type) {
        IItemViewHolderFactory factory = (IItemViewHolderFactory)this.mViewHolderMap.get(type, null);
        if (factory == null) {
            return (IItemViewHolderFactory)this.mViewHolderMap.get(1000);
        }
        return factory;
    }

    private static class InstanceHolder {
        static PeopleViewHolderFactory instance = new PeopleViewHolderFactory();

        private InstanceHolder() {
        }
    }
}

