/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.discover.ui.SexSelectedListener;

public class SelectSexPopupWindow
extends PopupWindow
implements View.OnClickListener {
    private static final String TAG = "SelectSexPopupWindow";
    private int width = 0;
    private int height = 0;
    private int margin = 0;
    private TextView mAll;
    private TextView mFemale;
    private TextView mMale;
    private SexSelectedListener mSelectedListener;

    public SelectSexPopupWindow(Context context) {
        super(context);
        this.createView(context);
    }

    private void createView(final Context context) {
        this.width = ResolutionUtils.dip2Px((float)100.0f);
        this.height = ResolutionUtils.dip2Px((float)165.0f);
        this.margin = ResolutionUtils.dip2Px((float)5.0f);
        View rootView2 = LayoutInflater.from((Context)context).inflate(R.layout.layout_select_sex_pop, null);
        this.setContentView(rootView2);
        this.setBackgroundDrawable(this.getDrawable());
        SelectSexPopupWindow.setBackgroundAlpha((Activity)context, 0.9f);
        this.setOutsideTouchable(true);
        this.setFocusable(true);
        this.setWidth(this.width);
        this.setHeight(this.height);
        this.mAll = (TextView)rootView2.findViewById(R.id.sex_all);
        this.mFemale = (TextView)rootView2.findViewById(R.id.sex_woman);
        this.mMale = (TextView)rootView2.findViewById(R.id.sex_man);
        this.mAll.setOnClickListener((View.OnClickListener)this);
        this.mFemale.setOnClickListener((View.OnClickListener)this);
        this.mMale.setOnClickListener((View.OnClickListener)this);
        this.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                SelectSexPopupWindow.setBackgroundAlpha((Activity)context, 1.0f);
            }
        });
    }

    public static void setBackgroundAlpha(Activity activity, float bgAlpha) {
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        lp.alpha = bgAlpha;
        if (bgAlpha == 1.0f) {
            activity.getWindow().clearFlags(2);
        } else {
            activity.getWindow().addFlags(2);
        }
        activity.getWindow().setAttributes(lp);
    }

    private Drawable getDrawable() {
        ShapeDrawable bgDrawable = new ShapeDrawable((Shape)new OvalShape());
        bgDrawable.getPaint().setColor(0);
        return bgDrawable;
    }

    public void show(View view, int selected) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"show select pop view, selectedNum: %s", (Object[])new Object[]{selected});
        }
        SelectSexPopupWindow.setBackgroundAlpha((Activity)view.getContext(), 0.9f);
        Rect rect = SelectSexPopupWindow.locateView(view);
        if (rect == null) {
            return;
        }
        int x = this.margin;
        int y = rect.bottom + this.margin;
        if (LanguageUtils.isRtl()) {
            this.showAtLocation(view, 51, x, y);
        } else {
            this.showAtLocation(view, 53, x, y);
        }
        this.selectView(selected);
    }

    public void setSelectedListener(SexSelectedListener selectedListener) {
        this.mSelectedListener = selectedListener;
    }

    private static Rect locateView(View v) {
        int[] locInt = new int[2];
        if (v == null) {
            return null;
        }
        try {
            v.getLocationOnScreen(locInt);
        }
        catch (NullPointerException npe) {
            return null;
        }
        Rect location = new Rect();
        location.left = locInt[0];
        location.top = locInt[1];
        location.right = location.left + v.getWidth();
        location.bottom = location.top + v.getHeight();
        return location;
    }

    public void onClick(View v) {
        if (v == this.mAll) {
            this.onSelected(2);
        } else if (v == this.mFemale) {
            this.onSelected(0);
        } else if (v == this.mMale) {
            this.onSelected(1);
        }
    }

    private void onSelected(int select) {
        this.selectView(select);
        if (this.mSelectedListener != null) {
            this.mSelectedListener.onSelected(select);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SelectSexPopupWindow.this.dismiss();
            }
        }, (long)200L);
    }

    private void selectView(int select) {
        if (this.mAll.isSelected()) {
            this.mAll.setSelected(false);
        }
        if (this.mMale.isSelected()) {
            this.mMale.setSelected(false);
        }
        if (this.mFemale.isSelected()) {
            this.mFemale.setSelected(false);
        }
        if (select == 1) {
            this.mMale.setSelected(true);
        } else if (select == 0) {
            this.mFemale.setSelected(true);
        } else {
            this.mAll.setSelected(true);
        }
    }
}

