/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.mixmodule.discover.ui.PeopleRecyclerAdapter;

public class StaggeredItemDecoration
extends RecyclerView.ItemDecoration {
    private static String TAG = "StaggeredItemDecoration";
    private int staggerMargin = 0;
    private int marginTop = 0;
    private int count = 0;
    private int leftPosition = -1;
    private int rightPosition = -1;
    private int middlePosition = -1;
    private PeopleRecyclerAdapter peopleRecyclerAdapter;

    public StaggeredItemDecoration(PeopleRecyclerAdapter mAdapter) {
        this.peopleRecyclerAdapter = mAdapter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.peopleRecyclerAdapter.getItemViewType(parent.getChildAdapterPosition(view)) == 1003) {
            StaggeredGridLayoutManager.LayoutParams layoutParams = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
            int position = parent.getChildAdapterPosition(view);
            if (layoutParams != null) {
                if (this.staggerMargin == 0) {
                    this.staggerMargin = ResolutionUtils.dip2Px((float)50.0f);
                }
                if (this.marginTop == 0) {
                    this.marginTop = ResolutionUtils.dip2Px((float)20.0f);
                    this.peopleRecyclerAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

                        public void onChanged() {
                            super.onChanged();
                            StaggeredItemDecoration.this.count = 0;
                        }
                    });
                }
                int pos = layoutParams.getSpanIndex();
                if (position == this.leftPosition || position == this.rightPosition) {
                    outRect.top = this.marginTop + this.staggerMargin;
                }
                if (position == this.middlePosition) {
                    outRect.top = this.marginTop;
                }
                MLog.info((Object)TAG, (String)"getItemOffsets pos = %d , position = %d", (Object[])new Object[]{pos, position});
                if (this.count < 3) {
                    if (pos == 0) {
                        outRect.top = this.marginTop + this.staggerMargin;
                        this.leftPosition = position;
                    } else if (pos == 2) {
                        outRect.top = this.marginTop + this.staggerMargin;
                        this.rightPosition = position;
                    } else {
                        outRect.top = this.marginTop;
                        this.middlePosition = position;
                    }
                    ++this.count;
                }
            }
        }
    }
}

