/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.deeplink.DeepLinkService;
import com.yy.appbase.service.home.DiscoverPageType;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.home.base.RotateIconInfo;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.mixmodule.base.discover.IRecommendDataListener;
import com.yy.hiyo.mixmodule.discover.IDiscoverUiCallback;
import com.yy.hiyo.mixmodule.discover.IRecommendInfoCacheCallback;
import com.yy.hiyo.mixmodule.discover.StorageRecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.bean.BaseRecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.bean.DiscoverDataModel;
import com.yy.hiyo.mixmodule.discover.bean.LocationPermissionInfo;
import com.yy.hiyo.mixmodule.discover.bean.RecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.ui.DiscoverPeopleWindow;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.location.ILocationChangedListener;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.apigateway.EFromType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class DiscoverPeopleController
extends DefaultController
implements IDiscoverUiCallback,
ILocationChangedListener,
IRecommendInfoCacheCallback {
    private static final String TAG = "DiscoverPeople";
    private int locationPermissionPosition = 0;
    private static final String SELECTED_SEX = "selected_sex_";
    private DiscoverPeopleWindow mDiscoverWindow;
    private IRecommendDataListener mRecommendListener;
    private Set<IRecommendDataListener> recommendDataListeners = new ArraySet(2);
    private boolean curLocationPermission = false;
    private final List<RecommendUserInfo> mRecommendUsers = new ArrayList<RecommendUserInfo>();
    private long mLastClickUserStamp = 0L;
    private boolean isLocationPermission = false;
    private BaseRecommendUserInfo baseLocationInfo;
    private boolean hasTopMasterEntrance = false;
    private Uri mFromUri;
    private boolean isClickAi = false;
    private boolean isBackToDiscoverTab = false;
    private boolean mNeedBackToSquare = false;
    private String pageSource = "9";

    public DiscoverPeopleController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        LocationHelper.addLocationListener((ILocationChangedListener)this);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == MixBaseMsgDef.OPEN_DISCOVER_PEOPLE) {
            if (msg.obj instanceof Uri) {
                this.mFromUri = (Uri)msg.obj;
            }
            this.isBackToDiscoverTab = msg.getData().getBoolean("back_to_discover_tab", false);
            this.pageSource = msg.getData().getString("pg_source", "9");
            this.mNeedBackToSquare = msg.getData().getBoolean("back_to_square", false);
            this.toDiscoverPage();
            if (FP.empty(this.mRecommendUsers)) {
                this.requestRecommendUser();
            }
        } else if (msg.what == MixBaseMsgDef.CACHE_DISCOVER_PEOPLE_DATA) {
            if (msg.obj instanceof IRecommendDataListener) {
                this.recommendDataListeners.add((IRecommendDataListener)msg.obj);
            }
            if (FP.empty(this.mRecommendUsers)) {
                this.requestRecommendUser();
            } else {
                for (IRecommendDataListener item : this.recommendDataListeners) {
                    item.onUpdateRecommendUser(this.convertRecommendInfo(this.mRecommendUsers), true);
                }
            }
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int id2 = notification.id;
        Object obj = notification.extObj;
        if (id2 == NotificationDef.N_FOREGROUND_CHANGE) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"change background: %s", (Object[])new Object[]{obj});
            }
            if (obj instanceof Boolean) {
                this.onChangeBackground((Boolean)obj);
            }
        } else if (id2 == NotificationDef.N_STARTUP_FINISHED) {
            StorageRecommendUserInfo.readCache(this);
        }
    }

    public void setRecommendListener(IRecommendDataListener recommendListener) {
        this.mRecommendListener = recommendListener;
    }

    private List<RotateIconInfo> convertRecommendInfo(List<RecommendUserInfo> list) {
        if (FP.empty(list)) {
            ArrayList<RotateIconInfo> rotateInfos = new ArrayList<RotateIconInfo>(4);
            String urlStart = "http://o-id.ihago.net";
            RotateIconInfo rotateIconInfo = new RotateIconInfo();
            rotateIconInfo.header = urlStart + "/user_avatar/icon_1010836492";
            rotateIconInfo.uid = 101083649L;
            rotateInfos.add(rotateIconInfo);
            RotateIconInfo rotateIconInfo2 = new RotateIconInfo();
            rotateIconInfo2.header = urlStart + "t/user_avatar/101094552_1526222569262.jpg";
            rotateIconInfo2.uid = 101094552L;
            rotateInfos.add(rotateIconInfo2);
            RotateIconInfo rotateIconInfo3 = new RotateIconInfo();
            rotateIconInfo3.header = urlStart + "/user_avatar/icon_1011453002";
            rotateIconInfo3.uid = 101145300L;
            rotateInfos.add(rotateIconInfo3);
            RotateIconInfo rotateIconInfo4 = new RotateIconInfo();
            rotateIconInfo4.header = urlStart + "t/user_avatar/101176920_1526817474237.jpg";
            rotateIconInfo4.uid = 101176920L;
            rotateInfos.add(rotateIconInfo4);
            return rotateInfos;
        }
        ArrayList<RotateIconInfo> rotateInfos = new ArrayList<RotateIconInfo>(list.size());
        for (BaseRecommendUserInfo baseRecommendUserInfo : list) {
            String header = null;
            long targetUid = 0L;
            if (!(baseRecommendUserInfo instanceof RecommendUserInfo)) continue;
            header = ((RecommendUserInfo)baseRecommendUserInfo).getHeadPic();
            targetUid = ((RecommendUserInfo)baseRecommendUserInfo).getUid();
            RotateIconInfo ri = new RotateIconInfo();
            ri.header = header;
            ri.uid = targetUid;
            rotateInfos.add(ri);
        }
        return rotateInfos;
    }

    public void clearData() {
        MLog.info((Object)TAG, (String)"onLoginOut clear discover data", (Object[])new Object[0]);
        this.mRecommendUsers.clear();
        this.isLocationPermission = false;
        StorageRecommendUserInfo.clear();
    }

    @Override
    public void onChangeBackground(boolean isForeground) {
        DiscoverPeopleWindow window = this.mDiscoverWindow;
        if (isForeground && window != null) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    LocationHelper.location();
                }
            });
            boolean permission = this.checkLocationPermission();
            if (permission != this.curLocationPermission) {
                this.onUpdateRecommendList(this.mRecommendUsers, true);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023805").put("function_id", "location_success"));
            }
            this.curLocationPermission = permission;
        }
    }

    @Override
    public boolean needShowGuide() {
        return DiscoverDataModel.getInstance().needShowGuide();
    }

    @Override
    public void setGuideShowed() {
        DiscoverDataModel.getInstance().setGuideShowed();
    }

    @Override
    public void setAiGuideItemClick(boolean isClickAi) {
        MLog.info((Object)TAG, (String)"setAiGuideItemClick %b", (Object[])new Object[]{isClickAi});
        this.isClickAi = isClickAi;
    }

    public void updateLocationPermissionData(List<BaseRecommendUserInfo> list, boolean writeCache) {
        if (list == null) {
            return;
        }
        if (!writeCache) {
            this.isLocationPermission = false;
        }
        boolean permission = this.checkLocationPermission();
        if (this.isLocationPermission && permission && list.size() > this.locationPermissionPosition && list.get(this.locationPermissionPosition) instanceof LocationPermissionInfo) {
            this.mRecommendUsers.remove(this.locationPermissionPosition);
            this.isLocationPermission = false;
        }
        if (!this.isLocationPermission && !permission) {
            this.locationPermissionPosition = 0;
            this.baseLocationInfo = new LocationPermissionInfo();
            list.add(this.locationPermissionPosition, this.baseLocationInfo);
            this.isLocationPermission = true;
        }
        MLog.info((Object)TAG, (String)"updateLocationPermissionData permission = %s", (Object[])new Object[]{permission});
    }

    private int randPosition(List<BaseRecommendUserInfo> list) {
        if (FP.empty(list)) {
            return 0;
        }
        return new Random().nextInt(list.size());
    }

    public void toDiscoverPage() {
        this.mDiscoverWindow = new DiscoverPeopleWindow(this.mContext, (UICallBacks)this, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mDiscoverWindow, true);
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (LocationHelper.getLocationInfo((boolean)false) == null) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    LocationHelper.location();
                }
            });
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023805").put("function_id", "show").put("pg_source", this.pageSource));
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mDiscoverWindow == abstractWindow) {
            this.mDiscoverWindow = null;
        }
    }

    @Override
    public void back() {
        if (this.mDiscoverWindow != null) {
            this.checkBackToSquare();
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mDiscoverWindow);
            this.mDiscoverWindow = null;
        }
    }

    @Override
    public void onSelectedSex(int select) {
        long uid = AccountUtil.getUid();
        String key2 = SELECTED_SEX + uid;
        SettingFlags.setIntValue((String)key2, (int)select);
        this.requestRecommendUser();
    }

    @Override
    public int getCurSex() {
        long uid = AccountUtil.getUid();
        String key2 = SELECTED_SEX + uid;
        return SettingFlags.getIntValue((String)key2, (int)2);
    }

    @Override
    public boolean checkLocationPermission() {
        return LocationHelper.checkLocationPermission();
    }

    @Override
    public List<BaseRecommendUserInfo> getRecommendList() {
        return new ArrayList<BaseRecommendUserInfo>(this.mRecommendUsers);
    }

    @Override
    public void requestRecommend() {
        this.requestRecommendUser();
    }

    @Override
    public void clickItem(BaseRecommendUserInfo info) {
        if (info == null) {
            return;
        }
        long cur = System.currentTimeMillis();
        if (cur - this.mLastClickUserStamp < 500L) {
            return;
        }
        if (info instanceof RecommendUserInfo) {
            if (this.isClickAi && SystemUtils.isAI((long)((RecommendUserInfo)info).getUid())) {
                this.gotoIm(((RecommendUserInfo)info).getUid());
                this.setAiGuideItemClick(false);
            } else {
                this.gotoProfile(((RecommendUserInfo)info).getUid());
            }
            this.mLastClickUserStamp = cur;
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023805").put("function_id", "head_click"));
        }
    }

    private void gotoIm(long targetUid) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", targetUid);
        bundle.putBoolean("is_target_ai", this.isClickAi && SystemUtils.isAI((long)targetUid));
        bundle.putInt("im_page_source", 3);
        msg.setData(bundle);
        this.sendMessageSync(msg);
        if (this.isClickAi && SystemUtils.isAI((long)targetUid)) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023805").put("function_id", "guide_click").put("ai_uid", "" + targetUid));
            this.setAiGuideItemClick(false);
        }
    }

    @Override
    public void onRefresh() {
        this.requestRecommendUser();
    }

    public void requestRecommendUser() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"requestRecommendUser uid: %s", (Object[])new Object[]{AccountUtil.getUid()});
        }
        this.getDiscoverPeople();
    }

    private void getDiscoverPeople() {
        DiscoverDataModel.getInstance().requestDiscoverPeople(this.getFromType(), this.checkLocationPermission(), this.getCurSex(), new ICommonCallback<List<RecommendUserInfo>>(){

            public void onSuccess(List<RecommendUserInfo> baseRecommendUserInfos, Object ... ext) {
                RecommendUserInfo userInfo;
                DiscoverPeopleController.this.clearData();
                if (DiscoverPeopleController.this.needShowGuide() && FP.size(baseRecommendUserInfos) >= 1 && SystemUtils.isAI((long)(userInfo = baseRecommendUserInfos.get(0)).getUid())) {
                    baseRecommendUserInfos.remove(userInfo);
                    DiscoverPeopleController.this.mRecommendUsers.add(userInfo);
                }
                Collections.shuffle(baseRecommendUserInfos);
                DiscoverPeopleController.this.mRecommendUsers.addAll(baseRecommendUserInfos);
                DiscoverPeopleController.this.onUpdateRecommendList(DiscoverPeopleController.this.mRecommendUsers, true);
            }

            public void onFail(int errCode, String msg, Object ... ext) {
            }
        });
    }

    private EFromType getFromType() {
        if (this.needShowGuide()) {
            if (DeepLinkService.INSTANCE.isFromDeepLink(this.mFromUri)) {
                return EFromType.Deeplink;
            }
            return EFromType.FirstTime;
        }
        return EFromType.None;
    }

    public void onLocationFailed(int errorCode, String errorMsg) {
        if (this.mDiscoverWindow != null) {
            boolean permission = this.checkLocationPermission();
            if (permission != this.curLocationPermission) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                } else {
                    this.mDiscoverWindow.showLoading();
                    this.requestRecommendUser();
                }
            }
            this.curLocationPermission = permission;
        }
    }

    public void onLocationChanged(LocationInfo info, boolean isCache) {
        if (!isCache) {
            this.requestRecommendUser();
        }
    }

    private void onUpdateRecommendList(List<RecommendUserInfo> list, boolean writeCache) {
        ArrayList<BaseRecommendUserInfo> updateList = new ArrayList<BaseRecommendUserInfo>(list);
        this.updateLocationPermissionData(updateList, writeCache);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUpdateRecommendList list.size: %s", (Object[])new Object[]{list.size()});
        }
        if (this.mDiscoverWindow != null) {
            this.mDiscoverWindow.updateRecommendList(updateList, true);
        }
        for (IRecommendDataListener item : this.recommendDataListeners) {
            item.onUpdateRecommendUser(this.convertRecommendInfo(list), true);
        }
        if (writeCache) {
            this.writeCache();
        }
    }

    @Override
    public void onReadCache(@Nullable List<RecommendUserInfo> list) {
        MLog.info((Object)TAG, (String)"onReadCache list: %s", (Object[])new Object[]{FP.size(list)});
        if (!FP.empty(list)) {
            if (FP.empty(this.mRecommendUsers)) {
                this.mRecommendUsers.addAll(list);
                this.onUpdateRecommendList(this.mRecommendUsers, false);
            }
        } else {
            this.requestRecommendUser();
        }
    }

    protected boolean onWindowBackKeyEvent() {
        this.checkBackToSquare();
        return super.onWindowBackKeyEvent();
    }

    private void checkBackToSquare() {
        if (this.mNeedBackToSquare) {
            ((IHomeService)this.getServiceManager().getService(IHomeService.class)).toDiscover(DiscoverPageType.SQUARE, false, -1, "", 0);
        } else if (this.isBackToDiscoverTab) {
            ((IHomeService)this.getServiceManager().getService(IHomeService.class)).toDiscover(DiscoverPageType.SQUARE, false, -1, "", 0);
        }
    }

    private void gotoProfile(long uid) {
        MLog.info((Object)TAG, (String)"open profile window:%s", (Object[])new Object[]{String.valueOf(uid)});
        ProfileReportBean bean = new ProfileReportBean();
        bean.setUid(Long.valueOf(uid));
        bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getDiscoverPeople()));
        bean.setSource(4);
        this.sendMessage(UserMsgDef.OPEN_WINDOW_NEW_PROFILE, 1, -1, bean);
    }

    private void writeCache() {
        StorageRecommendUserInfo.updateRecommendUserInfo(this.mRecommendUsers);
    }
}

