/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.country;

import android.os.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.country.CountrySelectWindow;
import com.yy.appbase.ui.country.ICountrySelectCallBack;
import com.yy.appbase.ui.country.ICountrySelectSimpleCallback;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;

public class CountrySelectController
extends DefaultController
implements ICountrySelectCallBack {
    private static final String TAG = "CountrySelectController";
    private CountrySelectWindow mSelectWindow;
    private ICountrySelectSimpleCallback mSelectCallback;

    public CountrySelectController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.OPEN_COUNTRY_SELECT_WINDOW) {
            if (msg.obj instanceof ICountrySelectSimpleCallback) {
                this.mSelectCallback = (ICountrySelectSimpleCallback)msg.obj;
            }
            this.openSelectWindow();
        }
    }

    private void openSelectWindow() {
        if (this.mSelectWindow != null) {
            return;
        }
        this.mSelectWindow = new CountrySelectWindow(this.mContext, (ICountrySelectCallBack)this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mSelectWindow, true);
    }

    public void onBackIconClicked(AbstractWindow window) {
        MLog.info((Object)TAG, (String)"onBackIconClicked", (Object[])new Object[0]);
        if (window == this.mSelectWindow) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mSelectWindow);
        }
        if (this.mSelectCallback != null) {
            this.mSelectCallback.onBackIconClicked();
        }
    }

    public void onCountrySelected(CountryHelper.CountryInfo info) {
        MLog.info((Object)TAG, (String)"onCountrySelected info: %s", (Object[])new Object[]{info});
        if (info == null) {
            return;
        }
        if (this.mSelectWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mSelectWindow);
        }
        if (this.mSelectCallback != null) {
            this.mSelectCallback.onCountrySelected(info);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mSelectWindow == abstractWindow) {
            this.mSelectWindow = null;
        }
        this.mSelectCallback = null;
    }
}

