/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.auto;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import android.view.MotionEvent;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.appbase.service.home.DiscoverPageType;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.home.PlayTabType;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameSelectContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.yylite.commonbase.crash.CrashSdk;
import java.util.ArrayList;
import java.util.Random;

public class PathAutoTestController
extends DefaultController {
    private static String TAG = "PathAutoTestController";
    private static ArrayList<RunnableEx> sCommands;
    private static int sTotalWeight;
    private long mAutoTochDownTime;
    private long mAutoTouchTimeGap;
    private boolean mIsVoiceAutoTest = false;
    private boolean mIsBBSListAutoTest = false;
    private boolean mIsProfileAutoTest = false;
    private boolean mNeedStop = false;
    private BroadcastReceiver mBatteryReceiver;
    private int batteryChargeStatu = -1;
    private boolean stopWhenChargeEnd = false;

    public PathAutoTestController(Environment baseEnv) {
        super(baseEnv);
    }

    public static boolean isSwitchOn() {
        return RuntimeContext.sIsDebuggable || SystemUtils.isShowEnvSetting();
    }

    public void test() {
        if (!PathAutoTestController.isSwitchOn()) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PathAutoTestController.this.testInner();
            }
        }, (long)25000L);
    }

    private void testInner() {
        boolean autoSwitch = false;
        if (RuntimeContext.sIsDebuggable) {
            // empty if block
        }
        boolean switchOn = SettingFlags.getBoolean((String)"pageautoswitch", (boolean)autoSwitch);
        boolean switchOnVoice = SettingFlags.getBoolean((String)"pageautovoiceswitch", (boolean)false);
        boolean switchOnBBSList = SettingFlags.getBoolean((String)"pageautobbslistswitch", (boolean)false);
        boolean switchProfile = SettingFlags.getBoolean((String)"pageautoprofileswitch", (boolean)false);
        if (!(switchOn || switchOnVoice || switchOnBBSList || switchProfile)) {
            return;
        }
        this.mIsVoiceAutoTest = switchOnVoice;
        this.mIsProfileAutoTest = switchProfile;
        this.mIsBBSListAutoTest = switchOnBBSList;
        RuntimeContext.sIsAutoTesting = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PathAutoTestController.this.gotoPage();
                PathAutoTestController.this.autoTouchStart();
                PathAutoTestController.this.checkActvity();
                PathAutoTestController.this.checkDialogAndIme();
                CrashSdk.INSTANCE.addExtend("AutoTest", "1");
                PathAutoTestController.this.registerBattery();
            }
        });
    }

    private void autoTouchStart() {
        if (!PathAutoTestController.isSwitchOn() || this.mNeedStop) {
            return;
        }
        if (this.mAutoTochDownTime <= 0L) {
            this.mAutoTochDownTime = SystemClock.uptimeMillis();
        }
        if (this.mAutoTouchTimeGap < 100L) {
            this.mAutoTouchTimeGap = 100L;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean move;
                int movePrecent = PathAutoTestController.this.mIsBBSListAutoTest ? 9 : 3;
                boolean bl = move = SystemClock.uptimeMillis() % 10L < (long)movePrecent;
                if (!move) {
                    int x = -1;
                    int y = -1;
                    if (PathAutoTestController.this.mIsVoiceAutoTest) {
                        boolean bottom;
                        boolean bl2 = bottom = System.currentTimeMillis() % 10L < 5L;
                        if (bottom) {
                            x = ScreenUtils.getInstance().getWidthPixels() / 2 + ScreenUtils.getInstance().getWidthPixels() / 200 * ((int)((System.currentTimeMillis() + SystemClock.uptimeMillis()) % 99L) + 1);
                            y = ScreenUtils.getInstance().getHeightPixels() - ResolutionUtils.dip2Px((float)50.0f) / 100 * ((int)((System.currentTimeMillis() + SystemClock.uptimeMillis()) % 99L) + 1);
                        } else {
                            x = ScreenUtils.getInstance().getWidthPixels() / 100 * ((int)(System.currentTimeMillis() % 99L) + 1);
                            y = ScreenUtils.getInstance().getHeightPixels() / 100 * ((int)((System.currentTimeMillis() + SystemClock.uptimeMillis()) % 99L) + 1);
                        }
                    } else {
                        if (PathAutoTestController.this.mIsBBSListAutoTest) {
                            PathAutoTestController.this.autoTouchStart();
                            return;
                        }
                        x = ScreenUtils.getInstance().getWidthPixels() / 100 * ((int)(System.currentTimeMillis() % 99L) + 1);
                        y = ScreenUtils.getInstance().getHeightPixels() / 100 * ((int)((System.currentTimeMillis() + SystemClock.uptimeMillis()) % 99L) + 1);
                    }
                    MotionEvent downEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)0, (float)x, (float)y, (int)0);
                    PathAutoTestController.this.mAutoTochDownTime = PathAutoTestController.this.mAutoTochDownTime + PathAutoTestController.this.mAutoTouchTimeGap;
                    MotionEvent upEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)1, (float)x, (float)y, (int)0);
                    if (PathAutoTestController.this.getCurrentWindow() != null) {
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(downEvent);
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(upEvent);
                    }
                    downEvent.recycle();
                    upEvent.recycle();
                } else {
                    int index = (int)(SystemClock.uptimeMillis() % 10L);
                    boolean upMove = false;
                    boolean downMove = false;
                    boolean leftMove = false;
                    boolean rightMove = false;
                    if (PathAutoTestController.this.mIsVoiceAutoTest) {
                        upMove = index < 2;
                        downMove = index >= 2;
                    } else if (PathAutoTestController.this.mIsBBSListAutoTest) {
                        downMove = true;
                    } else {
                        upMove = index < 2;
                        downMove = index >= 2 && index <= 5;
                        leftMove = index > 5 && index <= 7;
                        rightMove = index > 7 && index <= 9;
                    }
                    int x = ScreenUtils.getInstance().getWidthPixels() / 100 * (PathAutoTestController.this.mIsBBSListAutoTest ? 50 : (int)(System.currentTimeMillis() % 99L) + 1);
                    int y = ScreenUtils.getInstance().getHeightPixels() / 100 * (PathAutoTestController.this.mIsBBSListAutoTest ? 50 : (int)((System.currentTimeMillis() + SystemClock.uptimeMillis()) % 99L) + 1);
                    MotionEvent downEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)0, (float)x, (float)y, (int)0);
                    int moveX1 = -1;
                    int moveX2 = -1;
                    int moveX3 = -1;
                    int moveY1 = -1;
                    int moveY2 = -1;
                    int moveY3 = -1;
                    MotionEvent moveOneEvent = null;
                    MotionEvent moveTwoEvent = null;
                    MotionEvent moveThreeEvent = null;
                    if (upMove) {
                        moveX1 = x;
                        moveX2 = x;
                        moveX3 = x;
                        moveY1 = y + ResolutionUtils.dip2Px((float)10.0f);
                        moveY2 = y + ResolutionUtils.dip2Px((float)(PathAutoTestController.this.mIsBBSListAutoTest ? 40.0f : 20.0f));
                        moveY3 = y + ResolutionUtils.dip2Px((float)(PathAutoTestController.this.mIsBBSListAutoTest ? 100.0f : 40.0f));
                    } else if (downMove) {
                        moveX1 = x;
                        moveX2 = x;
                        moveX3 = x;
                        moveY1 = y + ResolutionUtils.dip2Px((float)-10.0f);
                        moveY2 = y + ResolutionUtils.dip2Px((float)(PathAutoTestController.this.mIsBBSListAutoTest ? -40.0f : -20.0f));
                        moveY3 = y + ResolutionUtils.dip2Px((float)(PathAutoTestController.this.mIsBBSListAutoTest ? -100.0f : -40.0f));
                    } else if (leftMove) {
                        moveX1 = x + ResolutionUtils.dip2Px((float)-10.0f);
                        moveX2 = x + ResolutionUtils.dip2Px((float)-20.0f);
                        moveX3 = x + ResolutionUtils.dip2Px((float)-40.0f);
                        moveY1 = y;
                        moveY2 = y;
                        moveY3 = y;
                    } else if (rightMove) {
                        moveX1 = x + ResolutionUtils.dip2Px((float)10.0f);
                        moveX2 = x + ResolutionUtils.dip2Px((float)20.0f);
                        moveX3 = x + ResolutionUtils.dip2Px((float)40.0f);
                        moveY1 = y;
                        moveY2 = y;
                        moveY3 = y;
                    }
                    PathAutoTestController.this.mAutoTochDownTime = PathAutoTestController.this.mAutoTochDownTime + PathAutoTestController.this.mAutoTouchTimeGap;
                    moveOneEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)2, (float)moveX1, (float)moveY1, (int)0);
                    PathAutoTestController.this.mAutoTochDownTime = PathAutoTestController.this.mAutoTochDownTime + PathAutoTestController.this.mAutoTouchTimeGap;
                    moveTwoEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)2, (float)moveX2, (float)moveY2, (int)0);
                    PathAutoTestController.this.mAutoTochDownTime = PathAutoTestController.this.mAutoTochDownTime + PathAutoTestController.this.mAutoTouchTimeGap;
                    moveThreeEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)2, (float)moveX3, (float)moveY3, (int)0);
                    PathAutoTestController.this.mAutoTochDownTime = PathAutoTestController.this.mAutoTochDownTime + PathAutoTestController.this.mAutoTouchTimeGap;
                    MotionEvent upEvent = MotionEvent.obtain((long)PathAutoTestController.this.mAutoTochDownTime, (long)PathAutoTestController.this.mAutoTochDownTime, (int)1, (float)moveX3, (float)moveY3, (int)0);
                    if (PathAutoTestController.this.getCurrentWindow() != null) {
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(downEvent);
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(moveOneEvent);
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(moveTwoEvent);
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(moveThreeEvent);
                        PathAutoTestController.this.getCurrentWindow().dispatchTouchEvent(upEvent);
                    }
                    downEvent.recycle();
                    moveOneEvent.recycle();
                    moveTwoEvent.recycle();
                    moveThreeEvent.recycle();
                    upEvent.recycle();
                }
                PathAutoTestController.this.autoTouchStart();
            }
        }, (long)this.mAutoTouchTimeGap);
    }

    private void gotoPage() {
        this.getCommnads();
        int gotoTime = SettingFlags.getIntValue((String)"pageautogototime", (int)10000);
        if (this.mIsBBSListAutoTest) {
            gotoTime = 1000000;
        }
        long weightIndex = SystemClock.uptimeMillis() % (long)sTotalWeight;
        for (RunnableEx command : sCommands) {
            if (weightIndex < (long)command.selectStartIndex || weightIndex > (long)command.selectEndIndex) continue;
            command.run();
            ++command.runtimes;
            MLog.info((Object)"PathAutoTestController", (String)("" + command.toString() + " run times:" + command.runtimes), (Object[])new Object[0]);
            break;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PathAutoTestController.this.hideDialogAndIme();
                PathAutoTestController.this.gotoPage();
            }
        }, (long)gotoTime);
    }

    private void checkActvity() {
        if (!RuntimeContext.sIsForeground) {
            Intent toIntent = ((IAppService)ServiceManagerProxy.getService(IAppService.class)).getMainIntent(this.mContext);
            toIntent.addFlags(0x4000000);
            toIntent.addFlags(0x20000000);
            this.mContext.startActivity(toIntent);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PathAutoTestController.this.checkActvity();
            }
        }, (long)10000L);
    }

    private void hideDialogAndIme() {
        YYDialog.hideAllDialog();
        ImeUtil.hideIME((Activity)this.getActivity());
        this.mDeviceMgr.hideInputMethod((Activity)this.getActivity());
    }

    private void checkDialogAndIme() {
        this.hideDialogAndIme();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PathAutoTestController.this.checkDialogAndIme();
            }
        }, (long)5000L);
    }

    private ArrayList<RunnableEx> getCommnads() {
        if (sCommands != null) {
            return sCommands;
        }
        sTotalWeight = 0;
        sCommands = new ArrayList();
        if (this.mIsProfileAutoTest) {
            this.fillCommand(this.getProfilePageCommand());
        } else if (this.mIsVoiceAutoTest) {
            this.fillCommand(this.getVoiceListPageCommand());
            this.fillCommand(this.getVideoLiveListPageCommand());
        } else if (this.mIsBBSListAutoTest) {
            this.fillCommand(this.getDiscoverSquarePageCommand());
        } else {
            this.fillCommand(this.getDiscoveryFriendPageCommand());
            this.fillCommand(this.getFriendsPageCommand());
            this.fillCommand(this.getImPageCommand());
            this.fillCommand(this.getImDetailPageCommand());
            this.fillCommand(this.getMatchPageCommand());
            this.fillCommand(this.getPlaywithFriendPageCommand());
            this.fillCommand(this.getProfilePageCommand());
            this.fillCommand(this.getSingleGameCommand());
            this.fillCommand(this.getScreenGameCommand());
            this.fillCommand(this.getSettingsPageCommand());
            this.fillCommand(this.getHomePageCommand());
            this.fillCommand(this.getFeedbackPageCommand());
            this.fillCommand(this.getVoiceListPageCommand());
            this.fillCommand(this.getVideoLiveListPageCommand());
            this.fillCommand(this.getDiscoverSquarePageCommand());
            this.fillCommand(this.getDiscoverFollowPageCommand());
            this.fillCommand(this.getMineCommand());
            this.fillCommand(this.getHomeTodayCommand());
            this.fillCommand(this.getHomeGameCommand());
            this.fillCommand(this.getHomeLiveCommand());
            this.fillCommand(this.getHomePartyCommand());
            this.fillCommand(this.getHomeChatCommand());
            this.fillCommand(this.getHomeCommand());
        }
        ++sTotalWeight;
        return sCommands;
    }

    private void fillCommand(RunnableEx command) {
        int weight = command.getWeight();
        command.selectStartIndex = sTotalWeight == 0 ? 0 : sTotalWeight + 1;
        command.selectEndIndex = sTotalWeight += weight;
        sCommands.add(command);
    }

    private RunnableEx getLoginPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(BaseMsgDef.MSG_BASE_LOGIN_OPEN_WINDOW);
            }
        };
    }

    private RunnableEx getHomePageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(BaseMsgDef.GOTO_HOMEPAGE);
            }

            @Override
            public int getWeight() {
                return 5;
            }
        };
    }

    private RunnableEx getFeedbackPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(MixBaseMsgDef.SHOW_FEEDBACK_WRAP_WINDOW, -1, 7);
            }
        };
    }

    private RunnableEx getProfilePageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                int msg = BaseMsgDef.MSG_OPEN_PROFILE_NEW_WINDOW;
                ProfileReportBean bean = new ProfileReportBean();
                long[] uids = new long[]{101001457L, 101682006L, 900003649L};
                int r = (int)(new Random().nextFloat() * 10.0f);
                bean.setUid(Long.valueOf(uids[r % uids.length]));
                if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product) {
                    PathAutoTestController.this.sendMessage(msg, (int)(SystemClock.uptimeMillis() % 10L), -1, bean);
                } else {
                    PathAutoTestController.this.sendMessage(msg, (int)(SystemClock.uptimeMillis() % 10L), -1, bean);
                }
            }
        };
    }

    private RunnableEx getImPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(ImBaseMsgDef.OPEN_CHAT_SESSION_PAGE);
            }
        };
    }

    private RunnableEx getImDetailPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                int uid = -1;
                uid = EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product ? 101001457 : 101001457;
                Message message = Message.obtain();
                Bundle bundle = new Bundle();
                bundle.putLong("target_uid", (long)uid);
                message.setData(bundle);
                message.what = BaseMsgDef.IM_ROOM_SHOW;
                PathAutoTestController.this.sendMessageSync(message);
            }
        };
    }

    private RunnableEx getPlaywithFriendPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessageSync(ImBaseMsgDef.OPEN_PLAY_WITH_FRIENDS);
            }
        };
    }

    private RunnableEx getDiscoveryFriendPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(MixBaseMsgDef.OPEN_DISCOVER_PEOPLE);
            }
        };
    }

    private RunnableEx getSingleGameCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                GameSelectContext selectContext = new GameSelectContext(GameContextDef.JoinFrom.FROM_DEFAULT);
                selectContext.setGameId("");
                selectContext.setGameSelectMode("default");
                ((IGameCenterService)PathAutoTestController.this.getServiceManager().getService(IGameCenterService.class)).toSelectPage(selectContext, 3);
            }
        };
    }

    private RunnableEx getScreenGameCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                GameSelectContext selectContext = new GameSelectContext(GameContextDef.JoinFrom.FROM_DEFAULT);
                ((IGameCenterService)PathAutoTestController.this.getServiceManager().getService(IGameCenterService.class)).toSelectPage(selectContext, 2);
            }
        };
    }

    private RunnableEx getFriendsPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(ImBaseMsgDef.OPEN_FRIEND_LIST_PAGE);
            }
        };
    }

    private RunnableEx getSettingsPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(BaseMsgDef.SHOW_WINDOW_SETTING);
            }
        };
    }

    private RunnableEx getMatchPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(BaseMsgDef.MSG_GAME_FIRST_PAGE_AUTO_TEST);
            }

            @Override
            public int getWeight() {
                return 1;
            }
        };
    }

    private RunnableEx getVoiceListPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.OPEN_ROOM_LIST);
            }

            @Override
            public int getWeight() {
                return 2;
            }
        };
    }

    private RunnableEx getVideoLiveListPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                PathAutoTestController.this.sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.FOCUS_TAB_BY_TYPE, 5, 0, null);
            }

            @Override
            public int getWeight() {
                return 2;
            }
        };
    }

    private RunnableEx getDiscoverSquarePageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toDiscover(DiscoverPageType.SQUARE, System.currentTimeMillis() % 2L == 0L, -1, "", 0);
            }

            @Override
            public int getWeight() {
                return 2;
            }
        };
    }

    private RunnableEx getDiscoverFollowPageCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toDiscover(DiscoverPageType.FOLLOW, System.currentTimeMillis() % 2L == 0L, -1, "", 0);
            }
        };
    }

    private RunnableEx getMineCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toMine();
            }
        };
    }

    private RunnableEx getHomeTodayCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toPlay(PlayTabType.TODAY, null);
            }

            @Override
            public int getWeight() {
                return 2;
            }
        };
    }

    private RunnableEx getHomeGameCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toPlay(PlayTabType.GAME, null);
            }

            @Override
            public int getWeight() {
                return 2;
            }
        };
    }

    private RunnableEx getHomeLiveCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toPlay(PlayTabType.LIVE, null);
            }

            @Override
            public int getWeight() {
                return 3;
            }
        };
    }

    private RunnableEx getHomePartyCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toPlay(PlayTabType.PARTY, null);
            }

            @Override
            public int getWeight() {
                return 3;
            }
        };
    }

    private RunnableEx getHomeChatCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toChat();
            }

            @Override
            public int getWeight() {
                return 2;
            }
        };
    }

    private RunnableEx getHomeCommand() {
        return new RunnableEx(){

            @Override
            public void realRun() {
                ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toMain();
            }

            @Override
            public int getWeight() {
                return 6;
            }
        };
    }

    private void registerBattery() {
        if (this.mBatteryReceiver == null && this.stopWhenChargeEnd) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
            this.mBatteryReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if (StringUtils.equal((String)action, (String)"android.intent.action.BATTERY_CHANGED")) {
                        int status = intent.getIntExtra("status", 1);
                        MLog.info((Object)"Battery", (String)"status:%d", (Object[])new Object[]{status});
                        if (status == 4) {
                            if (PathAutoTestController.this.batteryChargeStatu == 1) {
                                PathAutoTestController.this.batteryChargeStatu = 0;
                                PathAutoTestController.this.mNeedStop = true;
                                MLog.info((Object)"Battery", (String)"charge end stop autoTouch", (Object[])new Object[]{status});
                            } else {
                                PathAutoTestController.this.batteryChargeStatu = 0;
                            }
                        } else if (status == 2) {
                            PathAutoTestController.this.batteryChargeStatu = 1;
                        }
                    }
                }
            };
            RuntimeContext.sApplicationContext.registerReceiver(this.mBatteryReceiver, intentFilter);
        }
    }

    private abstract class RunnableEx
    implements Runnable {
        public int selectStartIndex = -1;
        public int selectEndIndex = -1;
        public int runtimes = 0;

        private RunnableEx() {
        }

        public int getWeight() {
            return 1;
        }

        @Override
        public void run() {
            boolean isPlaying = ((IGameCenterService)PathAutoTestController.this.getServiceManager().getService(IGameCenterService.class)).isPlaying();
            if (isPlaying) {
                ((IGameCenterService)PathAutoTestController.this.getServiceManager().getService(IGameCenterService.class)).leaveCurrentGame(new ILeaveGameCallback(){

                    public void onGameLeaved(GameInfo gameInfo, GamePlayContext context) {
                        RunnableEx.this.realRun();
                    }
                });
            } else {
                this.realRun();
            }
        }

        public abstract void realRun();
    }
}

