/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.auto;

import com.yy.hiyo.mixmodule.auto.bean.TestConfig;

public abstract class BaseTest<Config extends TestConfig>
implements Runnable {
    protected Config mConfig;

    private BaseTest() {
    }

    public BaseTest(Config mConfig) {
        this.mConfig = mConfig;
    }

    public boolean blockBeforeTest() {
        return false;
    }

    public boolean blockAfterTest() {
        return false;
    }

    public final boolean isValid() {
        return this.mConfig != null;
    }

    private boolean hasNext() {
        if (!this.isValid()) {
            return false;
        }
        int count = ((TestConfig)this.mConfig).testCounts;
        return count > 0 || count == -1;
    }

    private void counts() {
        --((TestConfig)this.mConfig).testCounts;
    }

    public final synchronized boolean tryTest() {
        if (!this.hasNext()) {
            return false;
        }
        if (this.blockBeforeTest()) {
            return false;
        }
        this.counts();
        this.run();
        return !this.blockAfterTest();
    }

    public final synchronized void stopTest() {
        ((TestConfig)this.mConfig).testCounts = 0;
    }

    public Config getConfig() {
        return this.mConfig;
    }
}

