/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker.utils;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import java.net.MalformedURLException;
import java.net.URL;

public class StickerContentValidator {
    private static final String TAG = "StickerContentValidator";
    private static final int STICKER_SIZE_MIN = 3;
    private static final int STICKER_SIZE_MAX = 30;
    private static final int CHAR_COUNT_MAX = 128;
    private static final String PLAY_STORE_DOMAIN = "play.google.com";

    public static boolean checkContentDataValidity(StickerPack stickerPack) {
        if (stickerPack == null) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)stickerPack.androidPlayStoreLink) && !StickerContentValidator.isValidWebsiteUrl(stickerPack.androidPlayStoreLink, PLAY_STORE_DOMAIN)) {
            MLog.info((Object)TAG, (String)"checkContentDataValidity androidPlayStoreLink error: %s", (Object[])new Object[]{stickerPack.androidPlayStoreLink});
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)stickerPack.identifier) || stickerPack.identifier.length() > 128) {
            MLog.info((Object)TAG, (String)"validateStickPack identifier : %s", (Object[])new Object[]{stickerPack.identifier});
            return false;
        }
        if (!StickerContentValidator.checkStringValidity(stickerPack.identifier)) {
            MLog.info((Object)TAG, (String)"validateStickPack checkStringValidity : %s", (Object[])new Object[]{stickerPack.identifier});
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)stickerPack.publisher) || stickerPack.publisher.length() > 128) {
            MLog.info((Object)TAG, (String)"validateStickPack publisher : %s", (Object[])new Object[]{stickerPack.publisher});
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)stickerPack.name) || stickerPack.name.length() > 128) {
            MLog.info((Object)TAG, (String)"validateStickPack name : %s", (Object[])new Object[]{stickerPack.name});
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)stickerPack.trayImageFile)) {
            MLog.info((Object)TAG, (String)"validateStickPack trayImageFile is empty", (Object[])new Object[0]);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)stickerPack.trayImageUrl)) {
            MLog.info((Object)TAG, (String)"validateStickPack trayImageUrl is empty", (Object[])new Object[0]);
            return false;
        }
        if (stickerPack.stickers == null || stickerPack.stickers.size() < 3 || stickerPack.stickers.size() > 30) {
            MLog.info((Object)TAG, (String)"validateStickPack stickers size error", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean isValidWebsiteUrl(String websiteUrl, String domain) {
        try {
            URL url = new URL(websiteUrl);
            if (domain.equals(url.getHost())) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            MLog.error((Object)TAG, (String)"isValidWebsiteUrl MalformedURLException: %s", (Throwable)e, (Object[])new Object[0]);
        }
        return false;
    }

    private static boolean checkStringValidity(@NonNull String string2) {
        String pattern = "[\\w-.,'\\s]+";
        if (!string2.matches(pattern)) {
            MLog.info((Object)TAG, (String)"checkStringValidity do not matches", (Object[])new Object[0]);
            return false;
        }
        if (string2.contains("..")) {
            MLog.info((Object)TAG, (String)"checkStringValidity contains ..", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

