/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.hiyo.mixmodule.base.whatsappsticker.StickerMsgDef;
import com.yy.hiyo.mixmodule.base.whatsappsticker.WhatsAppStickerCode;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.CheckStickerData;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.GetStickerData;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.InstallStickerData;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import com.yy.hiyo.mixmodule.whatsappsticker.AddStickerPackManager;
import com.yy.hiyo.mixmodule.whatsappsticker.Keys;
import com.yy.hiyo.mixmodule.whatsappsticker.StickerRecordPackManager;
import com.yy.hiyo.mixmodule.whatsappsticker.download.IDownLoadListener;
import com.yy.hiyo.mixmodule.whatsappsticker.download.StickerDownloadManager;
import com.yy.hiyo.mixmodule.whatsappsticker.stat.WhatsappStat;
import com.yy.hiyo.mixmodule.whatsappsticker.utils.StickerContentValidator;
import com.yy.hiyo.mixmodule.whatsappsticker.utils.StickerUtils;

public class WhatsAppStickerController
extends DefaultController {
    private static final String TAG = "WhatsAppStickerController";
    private InstallStickerData mInstallStickerData;
    private GetStickerData mGetStickerData;

    public WhatsAppStickerController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == StickerMsgDef.ADD_WHATSAPP_STICKER_HANDLER) {
            if (msg.obj != null && msg.obj instanceof InstallStickerData) {
                InstallStickerData data = (InstallStickerData)msg.obj;
                if (data.mInstallStickerCallback == null) {
                    MLog.error((Object)TAG, (String)"InstallStickerData callback is null!!!!", (Object[])new Object[0]);
                    return;
                }
                if (this.mInstallStickerData != null) {
                    data.mInstallStickerCallback.onInstallResult(4);
                    MLog.info((Object)TAG, (String)"handlerAddSticker error installing sticker", (Object[])new Object[0]);
                    return;
                }
                this.mInstallStickerData = data;
                YYTaskExecutor.execute(() -> this.handlerAddSticker());
                return;
            }
            MLog.error((Object)TAG, (String)"InstallStickerData data is error", (Object[])new Object[0]);
        } else if (msg.what == StickerMsgDef.ADD_WHATSAPP_STICKER_RESULT) {
            WhatsappStat.statWhatsappStickerInstall();
            Bundle bundle = msg.getData();
            int resultCode = bundle.getInt("resultCode");
            MLog.info((Object)TAG, (String)"add Sticker result handleMessage resultCode: %s  ", (Object[])new Object[]{resultCode});
            if (resultCode == -1) {
                YYTaskExecutor.execute(() -> StickerRecordPackManager.getOurInstance().updateStickPackData(result -> {
                    MLog.info((Object)TAG, (String)"handleMessage result updateStickPackData: %s", (Object[])new Object[]{result});
                    int code = result ? 1 : 9;
                    this.handlerAddResult(code);
                }));
            } else if (resultCode == 0) {
                MLog.info((Object)TAG, (String)"handleMessage result is user cancel!!", (Object[])new Object[0]);
                this.handlerAddResult(7);
            } else {
                Intent data = (Intent)bundle.getParcelable("data");
                String validationError = null;
                if (data != null) {
                    validationError = data.getStringExtra("validation_error");
                }
                if (FP.empty(validationError)) {
                    validationError = "unknown error";
                }
                MLog.info((Object)TAG, (String)"handleMessage result failed msg: %s", (Object[])new Object[]{validationError});
                this.handlerAddResult(8);
            }
        } else if (msg.what == StickerMsgDef.CHECK_WHATSAPP_STICKER_INSTALLED) {
            YYTaskExecutor.execute(() -> {
                if (msg.obj instanceof CheckStickerData) {
                    CheckStickerData data = (CheckStickerData)msg.obj;
                    this.handlerCheckStickerState(data);
                }
            });
        } else if (msg.what == StickerMsgDef.GET_STICKER_RES) {
            if (msg.obj instanceof GetStickerData) {
                GetStickerData data = (GetStickerData)msg.obj;
                if (data.mGetResCallback == null) {
                    return;
                }
                this.mGetStickerData = data;
                this.handlerGetStickerRes();
            }
        } else if (msg.what == StickerMsgDef.CANCEL_WHATS_APP_OP) {
            this.mInstallStickerData = null;
            this.mGetStickerData = null;
            MLog.debug((Object)TAG, (String)"cancel whatsApp op", (Object[])new Object[0]);
        }
    }

    private void handlerCheckStickerState(CheckStickerData data) {
        YYTaskExecutor.execute(() -> {
            String whatsappProviderAuthority;
            MLog.info((Object)TAG, (String)"handlerCheckStickerState identifier: %s  callback is null: %s", (Object[])new Object[]{data.identifier, data.mStateCallbak == null});
            if (data.mStateCallbak == null) {
                return;
            }
            if (FP.empty((CharSequence)data.identifier)) {
                YYTaskExecutor.postToMainThread(() -> data.mStateCallbak.checkWhatsAppStickerState(3));
                return;
            }
            if (!this.judgeInstallWhatsApp()) {
                YYTaskExecutor.postToMainThread(() -> {
                    data.mStateCallbak.checkWhatsAppStickerState(2);
                    MLog.info((Object)TAG, (String)"handlerCheckStickerState check not install whatsApp!!", (Object[])new Object[0]);
                });
                return;
            }
            PackageManager packageManager = this.getEnvironment().getContext().getPackageManager();
            ProviderInfo providerInfo = packageManager.resolveContentProvider(whatsappProviderAuthority = Keys.WHATSAPP_PACKAGE_NAME + ".provider.sticker_whitelist_check", 128);
            if (providerInfo == null) {
                YYTaskExecutor.postToMainThread(() -> {
                    data.mStateCallbak.checkWhatsAppStickerState(3);
                    MLog.info((Object)TAG, (String)"handlerCheckStickerState providerInfo == null", (Object[])new Object[0]);
                });
                return;
            }
            Uri queryUri = new Uri.Builder().scheme("content").authority(whatsappProviderAuthority).appendPath("is_whitelisted").appendQueryParameter("authority", "com.yy.hiyo.stickercontentprovider").appendQueryParameter("identifier", data.identifier).build();
            try (Cursor cursor = null;){
                cursor = this.getEnvironment().getContext().getContentResolver().query(queryUri, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    int whiteListResult = cursor.getInt(cursor.getColumnIndexOrThrow("result"));
                    int code = whiteListResult == 1 ? 0 : 1;
                    MLog.info((Object)TAG, (String)"handlerCheckStickerState check result: %s", (Object[])new Object[]{whiteListResult});
                    YYTaskExecutor.postToMainThread(() -> data.mStateCallbak.checkWhatsAppStickerState(code));
                } else {
                    MLog.info((Object)TAG, (String)"handlerCheckStickerState check result cursor is empty!!!", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread(() -> data.mStateCallbak.checkWhatsAppStickerState(3));
                }
            }
        });
    }

    private void handlerGetStickerRes() {
        if (!StickerContentValidator.checkContentDataValidity(this.mGetStickerData.pack)) {
            MLog.info((Object)TAG, (String)"handlerGetStickerRes pack is error", (Object[])new Object[0]);
            this.mGetStickerData.mGetResCallback.onFailed();
            this.mGetStickerData = null;
            return;
        }
        MLog.info((Object)TAG, (String)"handlerGetStickerRes data: %s", (Object[])new Object[]{this.mGetStickerData.pack.identifier});
        StickerDownloadManager.getOurInstance().checkAndDownLoadSticker(this.mGetStickerData.pack, new IDownLoadListener(){

            @Override
            public void completed(StickerPack pack) {
                MLog.info((Object)WhatsAppStickerController.TAG, (String)"handlerGetStickerRes DownLoad completed", (Object[])new Object[0]);
                if (WhatsAppStickerController.this.mGetStickerData != null) {
                    ((WhatsAppStickerController)WhatsAppStickerController.this).mGetStickerData.mGetResCallback.onCompleted(StickerUtils.getImageFileDirPath(pack.identifier));
                }
                WhatsAppStickerController.this.mGetStickerData = null;
            }

            @Override
            public void onFailed(StickerPack pack) {
                MLog.info((Object)WhatsAppStickerController.TAG, (String)"handlerGetStickerRes DownLoad onFailed", (Object[])new Object[0]);
                if (WhatsAppStickerController.this.mGetStickerData != null) {
                    ((WhatsAppStickerController)WhatsAppStickerController.this).mGetStickerData.mGetResCallback.onFailed();
                }
                WhatsAppStickerController.this.mGetStickerData = null;
            }

            @Override
            public void downLoadRatio(int total, int sucNum, int errNum) {
                MLog.info((Object)WhatsAppStickerController.TAG, (String)"handlerGetStickerRes DownLoad total: %s sucNum: %s  errNum: %s", (Object[])new Object[]{total, sucNum, errNum});
            }
        });
    }

    private void handlerAddResult(@WhatsAppStickerCode.InstallStickerResult int code) {
        YYTaskExecutor.postToMainThread(() -> {
            this.notifyInstallResult(code);
            this.notifyContentProviderChangeData(false);
        });
    }

    private synchronized void handlerAddSticker() {
        if (this.mInstallStickerData == null) {
            return;
        }
        if (!this.judgeInstallWhatsApp()) {
            MLog.info((Object)TAG, (String)"handlerAddSticker not install whatsapp", (Object[])new Object[0]);
            this.notifyInstallResult(2);
            return;
        }
        MLog.info((Object)TAG, (String)"handlerAddSticker install data param: %s", (Object[])new Object[]{this.mInstallStickerData.data});
        StickerPack stickerPack = StickerUtils.parseStickerContent(this.mInstallStickerData.data);
        if (!StickerContentValidator.checkContentDataValidity(stickerPack)) {
            MLog.info((Object)TAG, (String)"StickerContentValidator stickerPack is error!!!!!: %s", (Object[])new Object[]{stickerPack});
            this.notifyInstallResult(3);
            return;
        }
        StickerDownloadManager.getOurInstance().checkAndDownLoadSticker(stickerPack, new IDownLoadListener(){

            @Override
            public void completed(StickerPack pack) {
                MLog.info((Object)WhatsAppStickerController.TAG, (String)"handlerAddSticker DownLoad completed\uff0c start import sticker to whatsApp mInstallStickerData == null: %s", (Object[])new Object[]{WhatsAppStickerController.this.mInstallStickerData == null});
                if (WhatsAppStickerController.this.mInstallStickerData == null) {
                    return;
                }
                AddStickerPackManager.getInstance().createFutureStickPackList(pack);
                WhatsAppStickerController.this.notifyContentProviderChangeData(true);
                WhatsAppStickerController.this.launchIntentToAddStickToWhatsApp(pack);
            }

            @Override
            public void onFailed(StickerPack pack) {
                MLog.info((Object)WhatsAppStickerController.TAG, (String)"handlerAddSticker DownLoad onFailed", (Object[])new Object[0]);
                WhatsAppStickerController.this.notifyInstallResult(5);
            }

            @Override
            public void downLoadRatio(int total, int sucNum, int errNum) {
                MLog.info((Object)WhatsAppStickerController.TAG, (String)"handlerAddSticker DownLoad total: %s sucNum: %s  errNum: %s", (Object[])new Object[]{total, sucNum, errNum});
            }
        });
    }

    private void launchIntentToAddStickToWhatsApp(StickerPack stickerPack) {
        Intent intent = this.createIntentToAddStickerPack(stickerPack.identifier, stickerPack.name);
        intent.setPackage(Keys.WHATSAPP_PACKAGE_NAME);
        try {
            this.getActivity().startActivityForResult(intent, 2001);
        }
        catch (ActivityNotFoundException e) {
            MLog.info((Object)TAG, (String)"launchIntentToAddStickToWhatsApp ActivityNotFoundException: %s", (Object[])new Object[]{e});
            this.notifyInstallResult(6);
        }
    }

    private Intent createIntentToAddStickerPack(String identifier, String stickerPackName) {
        Intent intent = new Intent();
        intent.setAction("com.whatsapp.intent.action.ENABLE_STICKER_PACK");
        intent.putExtra("sticker_pack_id", identifier);
        intent.putExtra("sticker_pack_authority", "com.yy.hiyo.stickercontentprovider");
        intent.putExtra("sticker_pack_name", stickerPackName);
        return intent;
    }

    private void notifyContentProviderChangeData(boolean add) {
        String method = add ? "notifyUpdateAddStickPackIng" : "notifyUpdateAddStickPackEnd";
        MLog.info((Object)TAG, (String)"notifyContentProviderChangeData method: %s", (Object[])new Object[]{method});
        String uri = "content://com.yy.hiyo.stickercontentprovider";
        this.mContext.getContentResolver().call(Uri.parse((String)uri), method, "", null);
    }

    private boolean judgeInstallWhatsApp() {
        boolean installed;
        try {
            PackageManager packageManager = this.getEnvironment().getContext().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(Keys.WHATSAPP_PACKAGE_NAME, 0);
            installed = null != packageInfo;
        }
        catch (PackageManager.NameNotFoundException e) {
            installed = false;
        }
        return installed;
    }

    private void notifyInstallResult(int code) {
        if (YYTaskExecutor.isMainThread()) {
            if (this.mInstallStickerData != null && this.mInstallStickerData.mInstallStickerCallback != null) {
                this.mInstallStickerData.mInstallStickerCallback.onInstallResult(code);
            }
            this.mInstallStickerData = null;
        } else {
            YYTaskExecutor.postToMainThread(() -> {
                if (this.mInstallStickerData != null && this.mInstallStickerData.mInstallStickerCallback != null) {
                    this.mInstallStickerData.mInstallStickerCallback.onInstallResult(code);
                }
                this.mInstallStickerData = null;
            });
        }
    }

    private static /* synthetic */ void lambda$null$9(CheckStickerData data) {
        data.mStateCallbak.checkWhatsAppStickerState(3);
    }
}

