/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker;

import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.Sticker;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import com.yy.hiyo.mixmodule.whatsappsticker.AddStickerPackManager;
import com.yy.hiyo.mixmodule.whatsappsticker.IUpdateRecordData;
import com.yy.hiyo.mixmodule.whatsappsticker.utils.StickerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StickerRecordPackManager {
    private static final String TAG = "StickerRecordPackManage";
    private static StickerRecordPackManager ourInstance;
    private List<StickerPack> mLocalStickerPackList;
    private Boolean readSuccess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StickerRecordPackManager getOurInstance() {
        if (ourInstance != null) return ourInstance;
        Class<StickerRecordPackManager> clazz = StickerRecordPackManager.class;
        synchronized (StickerRecordPackManager.class) {
            if (ourInstance != null) return ourInstance;
            ourInstance = new StickerRecordPackManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    private StickerRecordPackManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StickerPack> readContentJsonFile() {
        if (!this.readSuccess.booleanValue()) {
            Boolean bl = this.readSuccess;
            synchronized (bl) {
                if (!this.readSuccess.booleanValue()) {
                    MLog.info((Object)TAG, (String)"need read from file", (Object[])new Object[0]);
                    this.getRecordPackData();
                }
            }
        }
        return this.mLocalStickerPackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRecordPackData() {
        File dataFile = this.getDataFile(false);
        if (!dataFile.exists()) {
            this.readSuccess = true;
            this.mLocalStickerPackList = null;
            MLog.info((Object)TAG, (String)"getRecordPackData dataFile not exist", (Object[])new Object[0]);
            return;
        }
        FileInputStream contentsInputStream = null;
        try {
            int len;
            contentsInputStream = new FileInputStream(dataFile);
            StringBuilder stringBuilder = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((len = ((InputStream)contentsInputStream).read(bytes)) != -1) {
                stringBuilder.append(new String(bytes, 0, len));
            }
            ((InputStream)contentsInputStream).close();
            String content = stringBuilder.toString();
            this.parseRecordData(content);
        }
        catch (IOException e) {
            MLog.info((Object)TAG, (String)"getRecordPackData IO ex: %s", (Object[])new Object[]{e});
        }
        finally {
            if (contentsInputStream != null) {
                try {
                    ((InputStream)contentsInputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void parseRecordData(String content) {
        if (FP.empty((CharSequence)content)) {
            this.readSuccess = true;
            this.mLocalStickerPackList = null;
            MLog.info((Object)TAG, (String)"getRecordPackData dataFile content is empty", (Object[])new Object[0]);
        }
        try {
            ArrayList<StickerPack> stickerPackList = new ArrayList<StickerPack>();
            JSONArray jsonArray = new JSONArray(content);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject pack = jsonArray.getJSONObject(i);
                StickerPack stickerPack = new StickerPack();
                stickerPack.androidPlayStoreLink = pack.optString("android_play_store_link");
                stickerPack.identifier = pack.optString("identifier");
                stickerPack.name = pack.optString("name");
                stickerPack.publisher = pack.optString("publisher");
                stickerPack.trayImageFile = pack.optString("tray_image_file");
                stickerPack.trayImageUrl = pack.optString("tray_image_url");
                stickerPack.publisherEmail = pack.optString("publisher_email");
                stickerPack.publisherWebsite = pack.optString("publisher_website");
                stickerPack.privacyPolicyWebsite = pack.optString("privacy_policy_website");
                stickerPack.licenseAgreementWebsite = pack.optString("license_agreement_website");
                stickerPack.stickers = new ArrayList();
                JSONArray stickers = pack.optJSONArray("stickers");
                if (stickers != null) {
                    for (int j = 0; j < stickers.length(); ++j) {
                        JSONObject json = stickers.getJSONObject(j);
                        Sticker sticker = new Sticker();
                        sticker.imageFile = json.optString("image_file");
                        sticker.downloadUrl = json.optString("download_url");
                        stickerPack.stickers.add(sticker);
                    }
                }
                stickerPackList.add(stickerPack);
            }
            this.mLocalStickerPackList = stickerPackList;
            this.readSuccess = true;
        }
        catch (JSONException e) {
            MLog.info((Object)TAG, (String)"parseRecordData json ex: %s", (Object[])new Object[]{e});
        }
    }

    public void updateStickPackData(IUpdateRecordData updateRecordData) {
        File dataFile = this.getDataFile(true);
        if (!dataFile.exists()) {
            MLog.info((Object)TAG, (String)"updateStickPackData createFile failed", (Object[])new Object[0]);
            updateRecordData.updateLocalData(false);
            return;
        }
        List<StickerPack> mStickPackList = AddStickerPackManager.getInstance().getFutureStickPackList();
        if (mStickPackList == null) {
            MLog.info((Object)TAG, (String)"updateStickPackData mLocalStickPackList is null", (Object[])new Object[0]);
            updateRecordData.updateLocalData(false);
            return;
        }
        boolean result = this.updateToLocalFile(mStickPackList, dataFile);
        if (result) {
            this.mLocalStickerPackList = mStickPackList;
        }
        updateRecordData.updateLocalData(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateToLocalFile(List<StickerPack> stickerPacks, File file) {
        String json = JsonParser.toJson(stickerPacks);
        MLog.info((Object)TAG, (String)"updateToLocalFile json: %s", (Object[])new Object[]{json});
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            byte[] data = json.getBytes();
            ((OutputStream)outputStream).write(data);
            ((OutputStream)outputStream).close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"updateToLocalFile ex: %s", (Object[])new Object[]{e});
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private File getDataFile(boolean create) {
        File dataFile;
        String filePath = StickerUtils.getStickerLocalDataFilePath();
        if (!create) {
            File dataFile2 = new File(filePath);
            return dataFile2;
        }
        String rootPath = StickerUtils.getStickerRootDirPath();
        File rootDir = new File(rootPath);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        if (!(dataFile = new File(filePath)).exists()) {
            try {
                dataFile.createNewFile();
            }
            catch (IOException e) {
                MLog.info((Object)TAG, (String)"getDataFile createNewFile ex: %s", (Object[])new Object[]{e});
            }
        }
        return dataFile;
    }
}

