/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.wake.AppWakeStat;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.Sticker;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import com.yy.hiyo.mixmodule.whatsappsticker.AddStickerPackManager;
import com.yy.hiyo.mixmodule.whatsappsticker.StickerRecordPackManager;
import com.yy.hiyo.mixmodule.whatsappsticker.utils.StickerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StickerContentProvider
extends ContentProvider {
    private static final String TAG = "StickerContentProvider";
    private UriMatcher mMatcher;
    static final String METADATA = "metadata";
    private static final int METADATA_CODE = 1;
    private static final int METADATA_CODE_FOR_SINGLE_PACK = 2;
    static final String STICKERS = "stickers";
    private static final int STICKERS_CODE = 3;
    static final String STICKERS_ASSET = "stickers_asset";
    private static final int STICKERS_ASSET_CODE = 4;
    private static final int STICKER_PACK_TRAY_ICON_CODE = 5;
    private List<StickerPack> stickerPackList;

    public boolean onCreate() {
        StickerContentProvider.infoLog(TAG, "onCreate!!", new Object[0]);
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        StickerContentProvider.infoLog(TAG, "onCreate!!", new Object[0]);
        if (this.mMatcher == null) {
            StickerContentProvider.infoLog(TAG, "query MATCHER is null need init", new Object[0]);
            AppWakeStat.INSTANCE.reportBackground("whatsapp");
            this.setStickerAndMatcher(StickerRecordPackManager.getOurInstance().readContentJsonFile());
        }
        if (FP.empty(this.stickerPackList)) {
            StickerContentProvider.infoLog(TAG, "query stickerPackList is null", new Object[0]);
            return null;
        }
        int code = this.mMatcher.match(uri);
        if (code == 1) {
            return this.getPackForAllStickerPacks(uri);
        }
        if (code == 2) {
            return this.getCursorForSingleStickerPack(uri);
        }
        if (code == 3) {
            return this.getStickersForAStickerPack(uri);
        }
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        if (this.mMatcher == null) {
            StickerContentProvider.infoLog(TAG, "getType MATCHER is null", new Object[0]);
            return null;
        }
        int matchCode = this.mMatcher.match(uri);
        switch (matchCode) {
            case 1: {
                return "vnd.android.cursor.dir/vnd.com.yy.hiyo.stickercontentprovider.metadata";
            }
            case 2: {
                return "vnd.android.cursor.item/vnd.com.yy.hiyo.stickercontentprovider.metadata";
            }
            case 3: {
                return "vnd.android.cursor.dir/vnd.com.yy.hiyo.stickercontentprovider.stickers";
            }
            case 4: {
                return "image/webp";
            }
            case 5: {
                return "image/png";
            }
        }
        return null;
    }

    @Nullable
    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String mode) {
        if (this.mMatcher == null) {
            StickerContentProvider.infoLog(TAG, "openFile MATCHER is null", new Object[0]);
            return null;
        }
        int matchCode = this.mMatcher.match(uri);
        if (matchCode == 4 || matchCode == 5) {
            return this.getImageFile(uri);
        }
        return null;
    }

    @Nullable
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        StickerContentProvider.infoLog(TAG, "call method: %s", method);
        if ("notifyUpdateAddStickPackEnd".equals(method)) {
            this.setStickerAndMatcher(StickerRecordPackManager.getOurInstance().readContentJsonFile());
        } else if ("notifyUpdateAddStickPackIng".equals(method)) {
            this.setStickerAndMatcher(AddStickerPackManager.getInstance().getFutureStickPackList());
        }
        return null;
    }

    private void setStickerAndMatcher(List<StickerPack> stickerPackList) {
        StickerContentProvider.infoLog(TAG, "setStickerAndMatcher stickerPackList size: %s data: %s", FP.size(stickerPackList), stickerPackList);
        this.stickerPackList = stickerPackList;
        String authority = "com.yy.hiyo.stickercontentprovider";
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(authority, METADATA, 1);
        this.mMatcher.addURI(authority, "metadata/*", 2);
        this.mMatcher.addURI(authority, "stickers/*", 3);
        if (FP.empty(stickerPackList)) {
            return;
        }
        for (int i = 0; i < stickerPackList.size(); ++i) {
            StickerPack stickerPack = stickerPackList.get(i);
            if (stickerPack == null) continue;
            this.mMatcher.addURI(authority, "stickers_asset/" + stickerPack.identifier + "/" + stickerPack.trayImageFile, 5);
            if (FP.empty((Collection)stickerPack.stickers)) continue;
            for (int j = 0; j < stickerPack.stickers.size(); ++j) {
                Sticker sticker = (Sticker)stickerPack.stickers.get(j);
                if (sticker == null) continue;
                this.mMatcher.addURI(authority, "stickers_asset/" + stickerPack.identifier + "/" + sticker.imageFile, 4);
            }
        }
    }

    private Cursor getPackForAllStickerPacks(@NonNull Uri uri) {
        return this.getStickerPackInfo(uri, this.stickerPackList);
    }

    @NonNull
    private Cursor getStickerPackInfo(@NonNull Uri uri, @NonNull List<StickerPack> stickerPackList) {
        MatrixCursor cursor = new MatrixCursor(new String[]{"sticker_pack_identifier", "sticker_pack_name", "sticker_pack_publisher", "sticker_pack_icon", "android_play_store_link", "ios_app_download_link", "sticker_pack_publisher_email", "sticker_pack_publisher_website", "sticker_pack_privacy_policy_website", "sticker_pack_license_agreement_website"});
        for (StickerPack stickerPack : stickerPackList) {
            MatrixCursor.RowBuilder builder = cursor.newRow();
            builder.add((Object)stickerPack.identifier);
            builder.add((Object)stickerPack.name);
            builder.add((Object)stickerPack.publisher);
            builder.add((Object)stickerPack.trayImageFile);
            builder.add((Object)stickerPack.androidPlayStoreLink);
            builder.add((Object)"");
            builder.add((Object)stickerPack.publisherEmail);
            builder.add((Object)stickerPack.publisherWebsite);
            builder.add((Object)stickerPack.privacyPolicyWebsite);
            builder.add((Object)stickerPack.licenseAgreementWebsite);
        }
        cursor.setNotificationUri(Objects.requireNonNull(this.getContext()).getContentResolver(), uri);
        return cursor;
    }

    private Cursor getCursorForSingleStickerPack(@NonNull Uri uri) {
        String identifier = uri.getLastPathSegment();
        for (StickerPack stickerPack : this.stickerPackList) {
            if (!identifier.equals(stickerPack.identifier)) continue;
            return this.getStickerPackInfo(uri, Collections.singletonList(stickerPack));
        }
        return this.getStickerPackInfo(uri, new ArrayList<StickerPack>());
    }

    @NonNull
    private Cursor getStickersForAStickerPack(@NonNull Uri uri) {
        String identifier = uri.getLastPathSegment();
        MatrixCursor cursor = new MatrixCursor(new String[]{"sticker_file_name", "sticker_emoji"});
        for (StickerPack stickerPack : this.stickerPackList) {
            if (!identifier.equals(stickerPack.identifier)) continue;
            for (Sticker sticker : stickerPack.stickers) {
                cursor.addRow(new Object[]{sticker.imageFile, ""});
            }
        }
        cursor.setNotificationUri(Objects.requireNonNull(this.getContext()).getContentResolver(), uri);
        return cursor;
    }

    private ParcelFileDescriptor getImageFile(Uri uri) {
        List pathSegments = uri.getPathSegments();
        if (pathSegments.size() != 3) {
            StickerContentProvider.infoLog(TAG, "path segments should be 3, uri is: " + uri, new Object[0]);
            return null;
        }
        String fileName = (String)pathSegments.get(pathSegments.size() - 1);
        String identifier = (String)pathSegments.get(pathSegments.size() - 2);
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            StickerContentProvider.infoLog(TAG, "identifier is empty, uri: " + uri, new Object[0]);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            StickerContentProvider.infoLog(TAG, "file name is empty, uri: " + uri, new Object[0]);
            return null;
        }
        for (StickerPack stickerPack : this.stickerPackList) {
            if (!identifier.equals(stickerPack.identifier)) continue;
            if (fileName.equals(stickerPack.trayImageFile)) {
                return this.fetchFile(identifier, fileName);
            }
            for (Sticker sticker : stickerPack.stickers) {
                if (!fileName.equals(sticker.imageFile)) continue;
                return this.fetchFile(identifier, fileName);
            }
        }
        return null;
    }

    private ParcelFileDescriptor fetchFile(String identifier, String fileName) {
        String imgDirPath = StickerUtils.getImageFileDirPath(identifier);
        File imgDir = new File(imgDirPath);
        if (!imgDir.exists()) {
            return null;
        }
        String imgPath = imgDirPath + File.separator + fileName;
        File imgFile = new File(imgPath);
        if (!imgFile.exists()) {
            return null;
        }
        ParcelFileDescriptor pfd = null;
        try {
            pfd = ParcelFileDescriptor.open((File)imgFile, (int)0x10000000);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return pfd;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        throw new UnsupportedOperationException("Not supported");
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException("Not supported");
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException("Not supported");
    }

    public static void infoLog(Object obj, String format, Object ... args) {
        if (SettingFlags.hasInited()) {
            MLog.info((Object)obj, (String)format, (Object[])args);
        }
    }
}

