/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.whatsappsticker;

import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.Sticker;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import com.yy.hiyo.mixmodule.whatsappsticker.StickerRecordPackManager;
import java.util.ArrayList;
import java.util.List;

public class AddStickerPackManager {
    private static final String TAG = "AddStickerPackManager";
    private List<StickerPack> mFutureStickPackList;

    private AddStickerPackManager() {
    }

    public static AddStickerPackManager getInstance() {
        return Holder.INSTANCE;
    }

    public void createFutureStickPackList(StickerPack stickerPack) {
        ArrayList<StickerPack> futureStickPackLis = new ArrayList<StickerPack>();
        List<StickerPack> mLocalStickPackList = StickerRecordPackManager.getOurInstance().readContentJsonFile();
        if (FP.empty(mLocalStickPackList)) {
            MLog.info((Object)TAG, (String)"createFutureStickPackList add stickPack: %s", (Object[])new Object[]{stickerPack.name});
            futureStickPackLis.add(stickerPack);
        } else {
            futureStickPackLis.addAll(mLocalStickPackList);
            boolean inList = false;
            for (int i = 0; i < futureStickPackLis.size(); ++i) {
                StickerPack pack = (StickerPack)futureStickPackLis.get(i);
                if (pack == null || !stickerPack.identifier.equals(pack.identifier)) continue;
                MLog.info((Object)TAG, (String)"createFutureStickPackList update old stickPack: %s", (Object[])new Object[]{stickerPack.name});
                stickerPack.stickers = this.mergeStickPackList(stickerPack.stickers, pack.stickers);
                futureStickPackLis.set(i, stickerPack);
                inList = true;
                break;
            }
            if (!inList) {
                futureStickPackLis.add(stickerPack);
                MLog.info((Object)TAG, (String)"createFutureStickPackList add stickPack: %s", (Object[])new Object[]{stickerPack.name});
            }
        }
        this.mFutureStickPackList = futureStickPackLis;
    }

    public List<StickerPack> getFutureStickPackList() {
        return this.mFutureStickPackList;
    }

    private List<Sticker> mergeStickPackList(List<Sticker> mAddStickers, List<Sticker> localStickers) {
        if (FP.empty(localStickers)) {
            MLog.info((Object)TAG, (String)"mergeStickPackList localSticker is empty", (Object[])new Object[0]);
            return mAddStickers;
        }
        if (FP.empty(mAddStickers)) {
            MLog.info((Object)TAG, (String)"mergeStickPackList mAddStickers is empty", (Object[])new Object[0]);
            return localStickers;
        }
        ArrayList<Sticker> mNewestStickerList = new ArrayList<Sticker>();
        mNewestStickerList.addAll(localStickers);
        for (int i = 0; i < mAddStickers.size(); ++i) {
            Sticker sticker = mAddStickers.get(i);
            if (sticker == null || FP.empty((CharSequence)sticker.imageFile)) continue;
            boolean inList = false;
            for (int j = 0; j < localStickers.size(); ++j) {
                Sticker local = localStickers.get(j);
                if (local == null || !sticker.imageFile.equals(local.imageFile)) continue;
                inList = true;
                break;
            }
            if (inList) continue;
            mNewestStickerList.add(sticker);
        }
        return mNewestStickerList;
    }

    private static class Holder {
        private static AddStickerPackManager INSTANCE = new AddStickerPackManager();

        private Holder() {
        }
    }
}

