/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.toast;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mixmodule.R;
import java.util.ArrayList;
import java.util.List;

public class GlobalBottomToast {
    private View rootView;
    private TextView toastMsg;
    private final List<ToastMessage> msgList = new ArrayList<ToastMessage>(5);
    private ToastMessage curMsg;
    private Runnable toastTimer = new Runnable(){

        @Override
        public void run() {
            ToastMessage msg = GlobalBottomToast.this.nextToast();
            if (msg == null) {
                GlobalBottomToast.this.curMsg = null;
                GlobalBottomToast.this.hide();
            } else {
                GlobalBottomToast.this.show(msg);
                GlobalBottomToast.this.curMsg = msg;
            }
        }
    };

    public GlobalBottomToast(@NonNull Context context) {
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_bottom_global_toast, null);
        this.toastMsg = (TextView)this.rootView.findViewById(R.id.toast_msg);
    }

    public void setToastMsgSingleLine(boolean isSingleLine) {
        if (this.toastMsg != null) {
            this.toastMsg.setSingleLine(isSingleLine);
        }
    }

    public View getToastView() {
        return this.rootView;
    }

    public void showToast(ToastMessage msg) {
        if (msg == null || TextUtils.isEmpty((CharSequence)msg.msg)) {
            return;
        }
        if (msg.equals((Object)this.curMsg)) {
            this.curMsg = msg;
            YYTaskExecutor.removeTask((Runnable)this.toastTimer);
            YYTaskExecutor.postToMainThread((Runnable)this.toastTimer, (long)msg.duration);
            return;
        }
        int idx = this.msgList.indexOf(msg);
        if (idx >= 0) {
            ToastMessage tm = this.msgList.get(idx);
            tm.duration = tm.duration < msg.duration ? msg.duration : tm.duration;
            msg.duration = tm.duration;
            if (tm.priority >= msg.priority) {
                return;
            }
            this.msgList.remove(tm);
        }
        this.insert(msg);
        if (this.curMsg == null) {
            this.toastTimer.run();
        }
    }

    private void show(@NonNull ToastMessage msg) {
        this.toastMsg.setText(msg.msg);
        if (this.rootView.getVisibility() != 0) {
            this.rootView.setVisibility(0);
        }
        YYTaskExecutor.postToMainThread((Runnable)this.toastTimer, (long)msg.duration);
    }

    @Nullable
    private ToastMessage nextToast() {
        if (this.msgList.isEmpty()) {
            return null;
        }
        return this.msgList.remove(0);
    }

    private void hide() {
        if (this.rootView.getVisibility() == 0) {
            this.rootView.setVisibility(8);
        }
    }

    private void insert(ToastMessage msg) {
        int idx = 0;
        for (ToastMessage tm : this.msgList) {
            if (tm.priority < msg.priority) break;
            ++idx;
        }
        this.msgList.add(idx, msg);
    }
}

