/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.statusbar;

import android.app.Activity;
import android.content.DialogInterface;
import android.os.SystemClock;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.ACWindowManager;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;

public class AppStatusBarManager
extends AbstractController {
    private DefaultWindow.IGlobalWindowMonitor mCallBack;
    private boolean mNeedAdjustWhenWinLayout = false;
    private long mLastLayoutTime = -1L;

    public AppStatusBarManager(Environment baseEnv) {
        super(baseEnv);
        YYDialog.setGlobalDialogCancelListener((DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
            }
        });
        YYDialog.setGlobalDialogDismissListener((DialogInterface.OnDismissListener)new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                AbstractWindow window = AppStatusBarManager.this.getCurrentWindow();
                if (window != null && window.isNeedFullScreen()) {
                    AppStatusBarManager.this.checkStatusBar(window);
                }
            }
        });
        this.mCallBack = new DefaultWindow.IGlobalWindowMonitor(){

            public void onLayout(boolean changed, int left, int top, int right, int bottom) {
                YYTaskExecutor.RunnableEx command = new YYTaskExecutor.RunnableEx(){

                    public void run() {
                        AbstractWindow window = AppStatusBarManager.this.getCurrentWindow();
                        if (window == null) {
                            return;
                        }
                        if (window.isNeedFullScreen() || window.isNeedHideNavigationBar()) {
                            if (!YYDialog.hasDialogShowing()) {
                                AppStatusBarManager.this.checkStatusBar(window);
                                MLog.info((Object)"AppStatusBarManager", (String)"window layout adjust statusbar!", (Object[])new Object[0]);
                            } else {
                                MLog.info((Object)"AppStatusBarManager", (String)"window layout when has dialog showing!", (Object[])new Object[0]);
                            }
                        }
                    }
                };
                if (AppStatusBarManager.this.mNeedAdjustWhenWinLayout) {
                    AppStatusBarManager.this.mNeedAdjustWhenWinLayout = false;
                    AppStatusBarManager.this.mLastLayoutTime = SystemClock.elapsedRealtime();
                    YYTaskExecutor.postToMainThread((Runnable)command, (long)0L);
                    return;
                }
                if (SystemClock.elapsedRealtime() - AppStatusBarManager.this.mLastLayoutTime > 500L) {
                    AppStatusBarManager.this.mLastLayoutTime = SystemClock.elapsedRealtime();
                    command.run();
                    MLog.info((Object)"AppStatusBarManager", (String)"window layout adjust statusbar!", (Object[])new Object[0]);
                }
            }
        };
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mCallBack);
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (!((Boolean)notification.extObj).booleanValue()) {
                this.mNeedAdjustWhenWinLayout = true;
            }
        } else if (notification.id == NotificationDef.N_ORIENTATION_CHANGE) {
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    AbstractWindow window = AppStatusBarManager.this.getCurrentWindow();
                    if (window != null && window.isNeedFullScreen()) {
                        AppStatusBarManager.this.checkStatusBar(window);
                    }
                }
            });
        } else if (notification.id == NotificationDef.N_FOCUS_CHANGE) {
            AbstractWindow window = this.getCurrentWindow();
            if (window == null) {
                return;
            }
            if ((window.isNeedFullScreen() || window.isNeedHideNavigationBar()) && !YYDialog.hasDialogShowing()) {
                this.checkStatusBar(window);
                MLog.info((Object)"AppStatusBarManager", (String)"window n_focus_change adjust statusbar!", (Object[])new Object[0]);
            }
        }
    }

    private void checkStatusBar(AbstractWindow curWindow) {
        ACWindowManager.adjustStatusBar((Activity)this.mEnvironment.getActivity(), (DeviceManager)this.mDeviceMgr, (AbstractWindow)curWindow);
    }
}

