/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.oss.preuploadmanager;

import android.content.Context;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IPreUploadService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.IUploadObjectProgressCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.image.compress.Luban;
import com.yy.base.image.compress.OnCompressListener;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.mixmodule.oss.preuploadmanager.ParcelableUploadManager;
import com.yy.hiyo.mixmodule.oss.preuploadmanager.StashStatus;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PreUploader
implements IPreUploadService {
    private static final String TAG = "PreUploader";
    private ConcurrentHashMap<String, PreUploadCallback> mConcurrentHashMap = new ConcurrentHashMap();
    private ParcelableUploadManager mParcelableUploadManager = new ParcelableUploadManager();

    public void uploadFile(String key2, String uploadFilePath, boolean enableCompressImage) {
        StashStatus stashStatus = this.mParcelableUploadManager.get(key2);
        boolean isNotContainKey = !this.mConcurrentHashMap.containsKey(key2);
        MLog.info((Object)TAG, (String)("isExist Status = " + stashStatus + " isNotContainKey = " + isNotContainKey + " key " + key2), (Object[])new Object[0]);
        if (this.mParcelableUploadManager.get(key2) == null && isNotContainKey) {
            PreUploadCallback preUploadCallback = new PreUploadCallback(this.mConcurrentHashMap, key2, this.mParcelableUploadManager, uploadFilePath, enableCompressImage);
            this.mConcurrentHashMap.put(key2, preUploadCallback);
            boolean enPreUpload = this.enablePreUpload();
            preUploadCallback.mEnablePreUpload = enPreUpload;
            MLog.info((Object)TAG, (String)("start upload key " + key2 + " filepath " + uploadFilePath + " enPreUpload " + enPreUpload), (Object[])new Object[0]);
            if (enPreUpload) {
                this.realUploadFile(key2, uploadFilePath, (IUploadObjectCallBack)preUploadCallback, enableCompressImage);
            }
        }
    }

    public void injectIUploadObjectCallBack(String key2, IUploadObjectCallBack callBack) {
        PreUploadCallback preUploadCallback = this.mConcurrentHashMap.get(key2);
        MLog.info((Object)TAG, (String)("injectIUploadObjectCallBack = " + preUploadCallback + " callBack = " + callBack), (Object[])new Object[0]);
        if (preUploadCallback != null) {
            if (preUploadCallback.mEnablePreUpload) {
                MLog.info((Object)TAG, (String)("inject callback key " + key2 + " enPreUpload true"), (Object[])new Object[0]);
                preUploadCallback.injectCallback(callBack);
            } else {
                MLog.info((Object)TAG, (String)("inject callback key " + key2 + " enPreUpload false"), (Object[])new Object[0]);
                this.mConcurrentHashMap.remove(key2);
                this.realUploadFile(key2, preUploadCallback.mUploadFilePath, callBack, preUploadCallback.mEnableCompressImage);
            }
        } else {
            MLog.info((Object)TAG, (String)("inject callback null key " + key2), (Object[])new Object[0]);
            YYTaskExecutor.execute(() -> this.asyncStashCallback(key2, callBack));
        }
    }

    public void abandonPreUpload(String key2) {
        MLog.info((Object)TAG, (String)("abandonPreUpload key " + key2), (Object[])new Object[0]);
        YYTaskExecutor.execute(() -> {
            StashStatus stashStatus = this.mParcelableUploadManager.remove(key2);
            this.mConcurrentHashMap.remove(key2);
            ((IOOSService)ServiceManagerProxy.getInstance().getService(IOOSService.class)).cancel(key2, stashStatus != null ? stashStatus.mUploadObjectRequest.getUploadFilePath() : "");
        });
    }

    private void realUploadFile(String key2, String uploadFilePath, IUploadObjectCallBack callBack, boolean enableCompressImage) {
        if (enableCompressImage && (ImageUtil.isJpg((String)uploadFilePath) || ImageUtil.isPng((String)uploadFilePath))) {
            this.compress(key2, uploadFilePath, callBack);
        } else {
            ((IOOSService)ServiceManagerProxy.getInstance().getService(IOOSService.class)).uploadFile(key2, uploadFilePath, callBack);
        }
    }

    private void compress(final String key2, final String uploadFilePath, final IUploadObjectCallBack callBack) {
        String temp = this.getTempDir();
        MLog.info((Object)TAG, (String)("pre upload compress target path = " + temp + " key = " + key2), (Object[])new Object[0]);
        Luban.with((Context)RuntimeContext.sApplicationContext).load(uploadFilePath).setTargetDir(temp).setCompressListener(new OnCompressListener(){

            public void onStart() {
            }

            public void onSuccess(File file) {
                ((IOOSService)ServiceManagerProxy.getInstance().getService(IOOSService.class)).uploadFile(key2, file.getAbsolutePath(), callBack);
            }

            public void onError(Throwable e) {
                ((IOOSService)ServiceManagerProxy.getInstance().getService(IOOSService.class)).uploadFile(key2, uploadFilePath, callBack);
            }

            public void onPatchCompressFinish(CopyOnWriteArrayList<BasicMediaInfo> photos) {
            }
        }).launch();
    }

    private String getTempDir() {
        File temp = new File(YYFileUtils.getYYTempDir() + File.separator + AccountUtil.getUid() + File.separator + "image");
        if (!temp.exists()) {
            temp.mkdirs();
        }
        return temp.getAbsolutePath();
    }

    private void asyncStashCallback(String key2, IUploadObjectCallBack callBack) {
        StashStatus stashStatus = this.mParcelableUploadManager.get(key2);
        MLog.info((Object)TAG, (String)("asyncStashCallback key = " + key2 + " " + stashStatus + " callBack = " + callBack), (Object[])new Object[0]);
        if (stashStatus != null && callBack != null) {
            this.mParcelableUploadManager.remove(key2);
            YYTaskExecutor.postToMainThread(() -> {
                if (stashStatus.mStatus == 0) {
                    callBack.onSuccess(stashStatus.mUploadObjectRequest);
                } else if (stashStatus.mStatus == 2) {
                    this.uploadFile(key2, stashStatus.mUploadObjectRequest.getUploadFilePath(), true);
                    this.injectIUploadObjectCallBack(key2, callBack);
                }
            });
        }
    }

    private boolean enablePreUpload() {
        boolean isWifi = NetworkUtils.isWifiActive((Context)RuntimeContext.sApplicationContext);
        MLog.info((Object)TAG, (String)("pre upload ab  isWifi " + isWifi), (Object[])new Object[0]);
        return SettingFlags.getBoolean((String)"key_video_pre_upload", (boolean)true) && isWifi;
    }

    private static class PreUploadCallback
    implements IUploadObjectProgressCallBack {
        private static final String TAG = "PreUpload";
        private static final int SUCCESS = 0;
        private static final int UPLOADING = 1;
        private static final int FAIL = 2;
        private ParcelableUploadManager mParcelableUploadManager;
        private ConcurrentHashMap<String, PreUploadCallback> mConcurrentHashMap;
        private String mKey;
        private int mStatus = 1;
        private UploadObjectRequest mUploadObjectRequest;
        private int mErrorCode;
        private Exception mException;
        private IUploadObjectCallBack mRealUploadCallback;
        private String mUploadFilePath;
        private boolean mEnablePreUpload = true;
        private boolean mEnableCompressImage = false;

        private PreUploadCallback(ConcurrentHashMap<String, PreUploadCallback> concurrentHashMap, String key2, ParcelableUploadManager parcelableUploadManager, String uploadFilePath, boolean enableCompressImage) {
            this.mUploadFilePath = uploadFilePath;
            this.mEnableCompressImage = enableCompressImage;
            this.mConcurrentHashMap = concurrentHashMap;
            this.mParcelableUploadManager = parcelableUploadManager;
            this.mKey = key2;
        }

        void injectCallback(IUploadObjectCallBack realUploadCallback) {
            if (realUploadCallback == null) {
                return;
            }
            this.mRealUploadCallback = realUploadCallback;
            MLog.info((Object)TAG, (String)("status " + this.mStatus), (Object[])new Object[0]);
            if (this.mStatus == 0) {
                this.onSuccess();
            } else if (this.mStatus == 2) {
                this.onFail();
            }
        }

        public void onProgress(UploadObjectRequest request, long numUploaded, long numTotal) {
            if (this.mRealUploadCallback != null && this.mRealUploadCallback instanceof IUploadObjectProgressCallBack) {
                ((IUploadObjectProgressCallBack)this.mRealUploadCallback).onProgress(request, numUploaded, numTotal);
            }
        }

        public void onSuccess(UploadObjectRequest request) {
            YYTaskExecutor.execute(() -> {
                StashStatus stashStatus = new StashStatus();
                stashStatus.mStatus = 0;
                stashStatus.mUploadObjectRequest = request;
                this.mParcelableUploadManager.put(this.mKey, stashStatus);
            }, () -> {
                this.mStatus = 0;
                this.mUploadObjectRequest = request;
                this.onSuccess();
            });
        }

        public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
            YYTaskExecutor.execute(() -> {
                StashStatus stashStatus = new StashStatus();
                stashStatus.mStatus = 2;
                stashStatus.mUploadObjectRequest = request;
                stashStatus.mErrorCode = errorCode;
                stashStatus.mException = exception;
                this.mParcelableUploadManager.put(this.mKey, stashStatus);
            }, () -> {
                this.mStatus = 2;
                this.mUploadObjectRequest = request;
                this.mErrorCode = errorCode;
                this.mException = exception;
                this.onFail();
            });
        }

        private void onSuccess() {
            this.mConcurrentHashMap.remove(this.mKey);
            if (this.mRealUploadCallback != null) {
                this.mRealUploadCallback.onSuccess(this.mUploadObjectRequest);
            }
        }

        private void onFail() {
            this.mConcurrentHashMap.remove(this.mKey);
            if (this.mRealUploadCallback != null) {
                this.mRealUploadCallback.onFailure(this.mUploadObjectRequest, this.mErrorCode, this.mException);
            }
        }
    }
}

