/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.oss.ali;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.mixmodule.oss.OnUpload;
import net.ihago.oss.api.upload.AliTokenInfo;

public class AliUploader {
    private static final String TAG = "AliUploader";
    private static final String HTTPS_PREFIX = "https://";
    private String mFilePath;
    private String mObjectKey;
    private byte[] mUploadData;

    AliUploader() {
        if (RuntimeContext.sIsDebuggable) {
            OSSLog.enableLog();
        } else {
            OSSLog.disableLog();
        }
    }

    public static void upload(OSSClient client, AliTokenInfo aliTokenInfo, String filePath, String objectKey, byte[] uploadData, OnUpload onUpload) {
        new AliUploader().uploadReal(client, aliTokenInfo, filePath, objectKey, uploadData, onUpload);
    }

    private void uploadReal(OSSClient client, final AliTokenInfo aliTokenInfo, String filePath, String objectKey, byte[] uploadData, final OnUpload onUpload) {
        MLog.info((Object)TAG, (String)"get upload token successfully", (Object[])new Object[0]);
        if (onUpload == null) {
            return;
        }
        this.mFilePath = filePath;
        this.mObjectKey = objectKey;
        this.mUploadData = uploadData;
        String bucket = aliTokenInfo.bucket;
        PutObjectRequest putRequest = new PutObjectRequest(bucket, aliTokenInfo.blob_prefix + this.mObjectKey, this.mFilePath);
        putRequest.setUploadData(this.mUploadData);
        putRequest.setProgressCallback((putObjectRequest, sofar, total) -> this.onProgress(onUpload, sofar, total));
        MLog.info((Object)TAG, (String)"start uploading to Aliyun", (Object[])new Object[0]);
        client.asyncPutObject(putRequest, (OSSCompletedCallback)new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

            public void onSuccess(PutObjectRequest putRequest, PutObjectResult result) {
                String url = AliUploader.HTTPS_PREFIX + aliTokenInfo.cdn_access_domain + "/" + aliTokenInfo.blob_prefix + AliUploader.this.mObjectKey;
                MLog.info((Object)AliUploader.TAG, (String)("upload to aliyun successfully url " + url), (Object[])new Object[0]);
                AliUploader.this.onSuccess(onUpload, url);
            }

            public void onFailure(PutObjectRequest putRequest, ClientException e, ServiceException e1) {
                AliUploader.this.onError(onUpload, 2222220, (Exception)(e != null ? e : e1));
                MLog.error((Object)AliUploader.TAG, (Throwable)(e != null ? e : e1));
                MLog.info((Object)AliUploader.TAG, (String)(putRequest == null ? "file path is empty" : putRequest.getUploadFilePath()), (Object[])new Object[0]);
            }
        });
    }

    private void onSuccess(OnUpload onUpload, String url) {
        YYTaskExecutor.postToMainThread(() -> onUpload.onSuccess(url));
    }

    private void onError(OnUpload onUpload, int code, Exception e) {
        YYTaskExecutor.postToMainThread(() -> onUpload.onError(code, e));
    }

    private void onProgress(OnUpload onUpload, long sofar, long total) {
        YYTaskExecutor.postToMainThread(() -> onUpload.onProgress(sofar, total));
    }
}

