/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.oss.ali;

import android.content.Context;
import android.os.SystemClock;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSStsTokenCredentialProvider;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.IUploadObjectProgressCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.mixmodule.PerfManager;
import com.yy.hiyo.mixmodule.oss.OnUpload;
import com.yy.hiyo.mixmodule.oss.STsTokenCallback;
import com.yy.hiyo.mixmodule.oss.Upload;
import com.yy.hiyo.mixmodule.oss.ali.AliSTsToken;
import com.yy.hiyo.mixmodule.oss.ali.AliUploader;
import com.yy.hiyo.mixmodule.oss.ali.Utils;
import com.yy.hiyo.mixmodule.oss.stat.AliOSSStat;
import net.ihago.oss.api.upload.AliTokenInfo;

public class AliUploadService
implements Upload {
    public static final String TAG = "AliUploadService";
    private AliSTsToken mSTsToken = new AliSTsToken();
    private volatile OSSClient mOSSClient;
    private AliTokenInfo mAliTokenInfo;
    private IAB mRetryTest;

    public static AliUploadService getInstance() {
        return SingleHolder.INSTANCE;
    }

    private AliUploadService() {
    }

    @Override
    public void uploadObject(UploadObjectRequest request, final IUploadObjectCallBack callBack) {
        final String uploadFilePath = request.getUploadFilePath();
        this.fetchTokenAndUpload(request, (IUploadObjectCallBack)new IUploadObjectProgressCallBack(){

            public void onProgress(UploadObjectRequest request, long numUploaded, long numTotal) {
                AliUploadService.this.onProgress(callBack, request, numUploaded, numTotal);
            }

            public void onSuccess(UploadObjectRequest request) {
                AliUploadService.this.onSuccess(callBack, request);
                boolean needDelete = true;
                if (callBack != null) {
                    needDelete = callBack.needDeleteUploadFile();
                }
                if (needDelete) {
                    Utils.deleteTmpFile(uploadFilePath);
                }
            }

            public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                AliUploadService.this.onError(callBack, request, errorCode, exception);
            }
        });
    }

    @Override
    public void delete(String key2) {
    }

    private void fetchTokenAndUpload(final UploadObjectRequest request, final IUploadObjectCallBack callBack) {
        this.mSTsToken.send(new STsTokenCallback<AliSTsToken.StsTokenBundle>(){

            @Override
            public void onSuccess(AliSTsToken.StsTokenBundle tokenInfo) {
                AliUploadService.this.aliUploader(request, tokenInfo, callBack);
            }

            @Override
            public void onFail(int code, String errMsg) {
                MLog.error((Object)AliUploadService.TAG, (String)"fetchStsToken error code: %d, errMes: %s", (Object[])new Object[]{code, errMsg});
                if (callBack != null) {
                    callBack.onFailure(request, code, (Exception)new RuntimeException(errMsg));
                }
            }
        });
    }

    private void aliUploader(final UploadObjectRequest request, final AliSTsToken.StsTokenBundle tokenBundle, final IUploadObjectCallBack callBack) {
        if (RuntimeContext.sIsDebuggable && tokenBundle.mainToken != null && tokenBundle.backupToken != null) {
            MLog.debug((Object)TAG, (String)"aliUploader main endpoint: %s, backup endpoint: %s", (Object[])new Object[]{tokenBundle.mainToken.endpoint, tokenBundle.backupToken.endpoint});
        }
        YYTaskExecutor.execute(() -> {
            String filePath = request.getUploadFilePath();
            final String objectKey = request.getObjectKey();
            OSSClient client = this.createOSSClient(tokenBundle.mainToken);
            AliUploader.upload(client, tokenBundle.mainToken, filePath, objectKey, request.getUploadData(), new OnUpload(){

                @Override
                public void onSuccess(String url) {
                    request.mUrl = url;
                    MLog.info((Object)AliUploadService.TAG, (String)"upload success key:%s domain:%s!", (Object[])new Object[]{objectKey, tokenBundle.mainToken.cdn_access_domain});
                    MLog.debug((Object)AliUploadService.TAG, (String)("url = " + url), (Object[])new Object[0]);
                    AliUploadService.this.onSuccess(callBack, request);
                    AliUploadService.this.statSuccess(request, 0);
                }

                @Override
                public void onProgress(long sofar, long total) {
                    AliUploadService.this.onProgress(callBack, request, sofar, total);
                }

                @Override
                public void onError(int code, Exception e) {
                    AliTokenInfo retryToken = AliUploadService.this.getRetryTokenInfo(tokenBundle);
                    if (retryToken != null) {
                        AliUploadService.this.retrySwitchCdn(request, tokenBundle, retryToken, callBack);
                    } else {
                        AliUploadService.this.onError(callBack, request, code, e);
                        AliUploadService.this.statFail(request, 0, code, e);
                    }
                }

                @Override
                public boolean isCancel(String key2) {
                    return false;
                }

                @Override
                public void onCancel() {
                }
            });
        });
    }

    private AliTokenInfo getRetryTokenInfo(AliSTsToken.StsTokenBundle tokenBundle) {
        if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (tokenBundle.backupToken == null || StringUtils.isEmpty((String)tokenBundle.backupToken.endpoint)) {
                MLog.info((Object)TAG, (String)("use main token back token " + tokenBundle.backupToken + " mainToken endpoint " + (tokenBundle.mainToken != null ? tokenBundle.mainToken.endpoint : "")), (Object[])new Object[0]);
                return tokenBundle.mainToken;
            }
            MLog.info((Object)TAG, (String)("use back token endpoint " + (tokenBundle.backupToken != null ? tokenBundle.backupToken.endpoint : "")), (Object[])new Object[0]);
            return tokenBundle.backupToken;
        }
        return null;
    }

    private void retrySwitchCdn(final UploadObjectRequest request, final AliSTsToken.StsTokenBundle tokenBundle, final AliTokenInfo tokenInfo, final IUploadObjectCallBack callBack) {
        MLog.debug((Object)TAG, (String)"retrySwitchCdn endPoint: %s", (Object[])new Object[]{tokenInfo.endpoint});
        YYTaskExecutor.execute(() -> {
            OSSClient client = this.createOSSClient(tokenInfo);
            AliUploader.upload(client, tokenInfo, request.getUploadFilePath(), request.getObjectKey(), request.getUploadData(), new OnUpload(){

                @Override
                public void onSuccess(String url) {
                    request.mUrl = url;
                    MLog.debug((Object)AliUploadService.TAG, (String)"retrySwitchCdn success url: %s", (Object[])new Object[]{url});
                    AliUploadService.this.onSuccess(callBack, request);
                    AliUploadService.this.statSuccess(request, tokenInfo == tokenBundle.backupToken ? 2 : 3);
                }

                @Override
                public void onProgress(long sofar, long total) {
                    AliUploadService.this.onProgress(callBack, request, sofar, total);
                }

                @Override
                public void onError(int code, Exception e) {
                    AliUploadService.this.onError(callBack, request, code, e);
                    AliUploadService.this.statFail(request, tokenInfo == tokenBundle.backupToken ? 2 : 3, code, e);
                }

                @Override
                public boolean isCancel(String key2) {
                    return false;
                }

                @Override
                public void onCancel() {
                }
            });
        });
    }

    private void onSuccess(IUploadObjectCallBack callBack, UploadObjectRequest request) {
        if (callBack != null) {
            callBack.onSuccess(request);
        }
    }

    private void onProgress(IUploadObjectCallBack callBack, UploadObjectRequest request, long sofar, long total) {
        if (callBack instanceof IUploadObjectProgressCallBack) {
            IUploadObjectProgressCallBack callBackProgress = (IUploadObjectProgressCallBack)callBack;
            callBackProgress.onProgress(request, sofar, total);
        }
    }

    private void onError(IUploadObjectCallBack callBack, UploadObjectRequest request, int code, Exception e) {
        if (callBack != null) {
            callBack.onFailure(request, code, e);
        }
    }

    private void statSuccess(UploadObjectRequest request, int retryType) {
        long useTime = SystemClock.uptimeMillis() - request.statStartTime;
        AliOSSStat.statUploadImage(0, "", retryType, request.getUploadFilePath(), useTime, request.mFileSize, request.getObjectKey(), useTime);
        PerfManager.statOOS(true, null, useTime);
    }

    private void statFail(UploadObjectRequest request, int retryType, int errorCode, Exception exception) {
        long useTime = SystemClock.uptimeMillis() - request.statStartTime;
        AliOSSStat.statUploadImage(errorCode, exception != null ? exception.getMessage() : "", retryType, request.getUploadFilePath(), useTime, request.mFileSize, request.getObjectKey(), useTime);
        PerfManager.statOOS(false, exception != null ? exception.toString() : "", useTime);
    }

    private OSSClient createOSSClient(AliTokenInfo sts) {
        if (this.mOSSClient != null && (sts == null || Utils.equal(sts, this.mAliTokenInfo))) {
            return this.mOSSClient;
        }
        String endpoint = sts.endpoint;
        OSSStsTokenCredentialProvider credentialProvider = new OSSStsTokenCredentialProvider(sts.access_key_id, sts.access_key_secret, sts.security_token);
        this.mOSSClient = new OSSClient(RuntimeContext.sApplicationContext, endpoint, (OSSCredentialProvider)credentialProvider);
        this.mAliTokenInfo = sts;
        return this.mOSSClient;
    }

    private static class SingleHolder {
        private static final AliUploadService INSTANCE = new AliUploadService();

        private SingleHolder() {
        }
    }
}

