/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback.widget.ksnack_lib.KSnack;

import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.feedback.widget.ksnack_lib.Animations.Fade;
import com.yy.hiyo.mixmodule.feedback.widget.ksnack_lib.KSnack.KSnackBarEventListener;

public class KSnack {
    public View snackView;
    private LayoutInflater linf;
    private ViewGroup insertPoint;
    private RelativeLayout rlvHost;
    private Button btnAction;
    private TextView txtMessage;
    private KSnackBarEventListener kSnackBarEventListener;
    private Animation inAnim;
    private Animation outAnim;

    public KSnack(Activity activity) {
        this.initializeKSnackBar(activity);
    }

    public KSnack(ViewGroup container2, Context context) {
        this.init(container2, context);
    }

    private void init(ViewGroup container2, Context context) {
        this.linf = (LayoutInflater)context.getApplicationContext().getSystemService("layout_inflater");
        this.snackView = this.linf.inflate(R.layout.layout_snack_normal, null);
        this.snackView.setVisibility(8);
        ViewCompat.setTranslationZ((View)this.snackView, (float)999.0f);
        container2.addView(this.snackView, 0, new ViewGroup.LayoutParams(-1, -2));
        this.rlvHost = (RelativeLayout)this.snackView.findViewById(R.id.normal_snack_bar_rlv);
        this.txtMessage = (TextView)this.snackView.findViewById(R.id.snack_bar_txt_message);
        this.btnAction = (Button)this.snackView.findViewById(R.id.snack_bar_btn_action);
        this.inAnim = Fade.In.getAnimation();
        this.outAnim = Fade.Out.getAnimation();
    }

    private void initializeKSnackBar(Activity activity) {
        this.insertPoint = (ViewGroup)activity.findViewById(0x1020002);
        this.init(this.insertPoint, (Context)activity);
    }

    public View getSnackView() {
        return this.rlvHost;
    }

    public KSnack setMessage(@NonNull String message) {
        if (message == null) {
            message = "n/a";
        }
        this.txtMessage.setText((CharSequence)message);
        return this;
    }

    public KSnack setDuration(@NonNull int millisecond) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                KSnack.this.dismiss();
            }
        }, (long)millisecond);
        return this;
    }

    public KSnack setAction(@NonNull String buttonText, @NonNull View.OnClickListener clickListener) {
        this.btnAction.setVisibility(0);
        this.btnAction.setText((CharSequence)buttonText);
        this.btnAction.setOnClickListener(clickListener);
        return this;
    }

    public KSnack setBackColor(@NonNull @ColorRes int colorInt) {
        Drawable drawable2 = this.rlvHost.getBackground();
        drawable2.setColorFilter(this.rlvHost.getContext().getResources().getColor(colorInt), PorterDuff.Mode.SRC);
        return this;
    }

    public KSnack setBackgrounDrawable(@NonNull @DrawableRes int drawableInt) {
        ViewCompat.setBackground((View)this.rlvHost, (Drawable)ContextCompat.getDrawable((Context)this.rlvHost.getContext(), (int)drawableInt));
        return this;
    }

    public KSnack setTextColor(@NonNull @ColorRes int colorInt) {
        this.txtMessage.setTextColor(this.txtMessage.getContext().getResources().getColor(colorInt));
        return this;
    }

    public KSnack setButtonTextColor(@NonNull @ColorRes int colorInt) {
        this.btnAction.setTextColor(this.btnAction.getContext().getResources().getColor(colorInt));
        return this;
    }

    public KSnack setListener(KSnackBarEventListener listener) {
        this.kSnackBarEventListener = listener;
        return this;
    }

    public KSnack setAnimation(Animation inAnim, Animation outAnim) {
        this.inAnim = inAnim;
        this.outAnim = outAnim;
        return this;
    }

    public void show() {
        this.inAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                KSnack.this.snackView.setVisibility(0);
            }

            public void onAnimationEnd(Animation animation) {
                KSnack.this.snackView.setVisibility(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.snackView.startAnimation(this.inAnim);
        if (this.kSnackBarEventListener != null) {
            this.kSnackBarEventListener.showedSnackBar();
        }
    }

    public void dismiss() {
        this.outAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                KSnack.this.snackView.setVisibility(0);
            }

            public void onAnimationEnd(Animation animation) {
                KSnack.this.snackView.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.snackView.startAnimation(this.outAnim);
        if (this.kSnackBarEventListener != null) {
            this.kSnackBarEventListener.stoppedSnackBar();
        }
    }
}

