/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback.request.uploadUtil;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.google.gson.JsonObject;
import com.yy.appbase.R;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.SimpleNetStringRespCallback;
import com.yy.appbase.unifyconfig.config.BackupHostConfig;
import com.yy.base.env.ConstDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.LogZipCompress;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.BlankUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Callback;
import com.yy.grace.Grace;
import com.yy.grace.Response;
import com.yy.hago.xlog.IFlushCallback;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hiyo.mixmodule.feedback.request.builder.FeedbackUploadFileAli;
import com.yy.hiyo.mixmodule.feedback.request.builder.FeedbackUploadFilePost;
import com.yy.hiyo.mixmodule.feedback.request.builder.IRequestBuilder;
import com.yy.hiyo.mixmodule.feedback.request.builder.IRequestUploadCallback;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.BugJson;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.BugUploadInfo;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.UploadRequestInfo;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.uploadlog.UploadLog;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;

public class FeedbackUploader {
    private static final String TAG = "FeedbackUploader";
    private static volatile FeedbackUploader instance;
    private static final float AVERAGE_LOG_ZIP_COMPRESSION_RATIO = 0.2f;
    private static final String UNCAUGHT_EXCEPTIONS_LOGS = "uncaught_exception.txt";
    private static final String PERF_ACTION_LOGS = "PerfActionLog.txt";
    private volatile Grace mGraceClient;
    private IRequestBuilder mRequestBuilder;
    private final long mTimeout = SettingFlags.getLongValue((String)"key_feedback_timeout", (long)0L);
    private final IAB optAb = NewABDefine.FEEDBACK_LOG_OPT.getTest();
    private int uploadFileSizeMaxLimit = RuntimeContext.sIsDebuggable ? 6 : 3;

    private FeedbackUploader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeedbackUploader getInstance() {
        if (instance != null) return instance;
        Class<FeedbackUploader> clazz = FeedbackUploader.class;
        synchronized (FeedbackUploader.class) {
            if (instance != null) return instance;
            instance = new FeedbackUploader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void reportFeedback(UploadRequestInfo requestInfo, IUploadCallBack callBack) {
        YYTaskExecutor.execute(() -> this.reportFeedbackReal(requestInfo, callBack));
    }

    public int getUploadFileSizeMaxLimit() {
        return this.uploadFileSizeMaxLimit;
    }

    public void setUploadFileSizeMaxLimit(int uploadFileSizeMaxLimit) {
        this.uploadFileSizeMaxLimit = uploadFileSizeMaxLimit;
    }

    private void reportFeedbackReal(final UploadRequestInfo requestInfo, final IUploadCallBack callBack) {
        final UploadLog uploadLog = UploadLog.beginTransaction("feedback3");
        uploadLog.i("begin", String.valueOf(requestInfo), 5);
        this.findUploadLogFile(requestInfo, uploadLog, new IGetUploadLogCallBack(){

            @Override
            public void onSuccess(final File uploadFile) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String postUrl;
                            IRequestBuilder requestBuilder = FeedbackUploader.this.getRequestBuilder(requestInfo);
                            MLog.info((Object)FeedbackUploader.TAG, (String)("requestBuilder type: " + requestBuilder.type()), (Object[])new Object[0]);
                            final long timestamp = System.currentTimeMillis();
                            String postServer = FeedbackUploader.this.getFeedbackUrl();
                            if (SettingFlags.getBoolean((String)"useoldfeedback", (boolean)false)) {
                                postServer = "https://isoda-inforeceiver.duowan.com/userFeedback";
                            }
                            if (StringUtils.isNotEmpty((String)(postUrl = BackupHostConfig.getOurSDKURI((String)"FeedBack")))) {
                                postServer = postUrl;
                            }
                            String finalPostServer = postServer;
                            final String requestBuilderInfo = "requestBuilderInfo: [" + requestBuilder.type() + ']';
                            final String networkName = "networkName: [" + NetworkUtils.getNetworkName((Context)RuntimeContext.sApplicationContext) + "]";
                            uploadLog.i("begin upload", "" + uploadFile + " ## " + requestInfo + " ## " + requestBuilderInfo + " ## " + networkName, 130, uploadFile == null ? 0 : (int)uploadFile.length());
                            requestBuilder.build(finalPostServer, uploadFile, requestInfo, new IRequestUploadCallback(){

                                @Override
                                public void onUpload(int code) {
                                    uploadLog.i("upload file", "" + uploadFile + " ## " + requestInfo + " ## " + requestBuilderInfo + " ## " + networkName, 150, uploadFile == null ? 0 : (int)uploadFile.length(), (int)(System.currentTimeMillis() - timestamp), code);
                                }

                                @Override
                                public void onFinish(int code, @org.jetbrains.annotations.Nullable Throwable e) {
                                    FeedbackUploader.deleteDir(uploadFile);
                                    if (e == null) {
                                        FeedbackUploader.this.reportSuccess(callBack);
                                        uploadLog.i("upload log to platform", "" + uploadFile + " ## " + requestInfo + " ## " + requestBuilderInfo + " ## " + networkName, 170, uploadFile == null ? 0 : (int)uploadFile.length(), (int)(System.currentTimeMillis() - timestamp), -1);
                                    } else {
                                        FeedbackUploader.this.reportFail(callBack, 3, e.toString(), e);
                                        uploadLog.e("upload log to platform", "" + uploadFile + " ## " + requestInfo + " ## " + requestBuilderInfo + " ## " + networkName, e, 160, uploadFile == null ? 0 : (int)uploadFile.length(), (int)(System.currentTimeMillis() - timestamp), -1);
                                    }
                                    FeedbackUploader.this.statMetric(requestInfo, System.currentTimeMillis() - timestamp, code);
                                }
                            });
                            MLog.info((Object)FeedbackUploader.TAG, (String)"collectLogBySize() : Logs packing task finished", (Object[])new Object[0]);
                        }
                        catch (Exception ex) {
                            uploadLog.e("compress file exception", String.valueOf(requestInfo), ex, 140);
                            FeedbackUploader.this.reportFail(callBack, 4, ex.toString(), ex);
                        }
                    }
                });
            }

            @Override
            public void onFail(int errorCode, String des) {
                FeedbackUploader.this.reportFail(callBack, errorCode, des, null);
            }
        });
    }

    private String getFeedbackUrl() {
        return "https://imobfeedback.duowan.com/userFeedbackSec";
    }

    private void filterAndPutLogFile(@NonNull List<File> appLogFiles, @NonNull List<File> srcLogFiles, long startTime, long endTime, float maxSize) {
        Runnable originUploadStrategy = () -> {
            float residualSize = maxSize;
            for (int i = 0; i < appLogFiles.size(); ++i) {
                File f = (File)appLogFiles.get(i);
                if (f == null || !f.isFile()) continue;
                if (this.checkCompressed(f.getName())) {
                    if (!(residualSize - (float)f.length() >= 0.0f)) continue;
                    residualSize -= (float)f.length();
                    srcLogFiles.add(f);
                    continue;
                }
                if (!(residualSize - (float)f.length() * 0.2f >= 0.0f)) break;
                residualSize -= (float)f.length() * 0.2f;
                srcLogFiles.add(f);
            }
        };
        if (startTime <= 0L) {
            originUploadStrategy.run();
            return;
        }
        if (endTime <= startTime) {
            endTime = startTime + 8640000L;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm", Locale.US);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(startTime * 1000L);
        String startTimeLocal = simpleDateFormat.format(calendar.getTime());
        calendar.setTimeInMillis(endTime * 1000L);
        String endTimeLocal = simpleDateFormat.format(calendar.getTime());
        float remainSize = maxSize;
        for (int i = appLogFiles.size() - 1; i >= 0; --i) {
            File f = appLogFiles.get(i);
            if (f == null || TextUtils.isEmpty((CharSequence)f.getName())) continue;
            String fileName = f.getName();
            int fileNameCompareStartIndex = -1;
            int compareStart = 0;
            int compareEnd = 0;
            for (int j = 0; j < fileName.length(); ++j) {
                char cName = fileName.charAt(j);
                if (fileNameCompareStartIndex < 0 && cName >= '0' && cName <= '9') {
                    fileNameCompareStartIndex = j;
                }
                if (fileNameCompareStartIndex < 0) continue;
                int dateIndex = j - fileNameCompareStartIndex;
                if (dateIndex >= startTimeLocal.length()) break;
                char cDateStart = startTimeLocal.charAt(dateIndex);
                char cDateEnd = endTimeLocal.charAt(dateIndex);
                if (cName != cDateStart && compareStart == 0) {
                    compareStart = cName > cDateStart ? 1 : -1;
                }
                if (cName != cDateEnd && compareEnd == 0) {
                    compareEnd = cName > cDateEnd ? 1 : -1;
                }
                if (compareStart != 0 && compareEnd != 0) break;
            }
            if (compareStart < 0 || compareEnd > 0) continue;
            if (this.checkCompressed(fileName)) {
                if (!(remainSize - (float)f.length() >= 0.0f)) continue;
                remainSize -= (float)f.length();
                srcLogFiles.add(f);
                continue;
            }
            if (!(remainSize - (float)f.length() * 0.2f >= 0.0f)) break;
            remainSize -= (float)f.length() * 0.2f;
            srcLogFiles.add(f);
        }
        if (remainSize == maxSize) {
            originUploadStrategy.run();
        }
    }

    private boolean checkOverSize(@NonNull UploadRequestInfo requestInfo, File file) {
        if (requestInfo.mUploadRequestType == 1) {
            return false;
        }
        long maxSize = (long)requestInfo.mUploadSizeMB * 1024L * 1024L;
        long fileLength = file.length();
        if (fileLength > maxSize) {
            MLog.info((Object)TAG, (String)"upload file sizes: %d bigger maxSize: %d", (Object[])new Object[]{fileLength, maxSize});
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Grace getGrace() {
        if (this.mGraceClient == null) {
            FeedbackUploader feedbackUploader = this;
            synchronized (feedbackUploader) {
                if (this.mGraceClient == null) {
                    Grace.Builder builder = GraceWrapper.getGrace().newBuilder();
                    if (NAB.B.equals((Object)this.optAb) || NAB.D.equals((Object)this.optAb)) {
                        builder.disableHttp2(true);
                    } else {
                        builder.disableHttp2(false);
                    }
                    if (this.mTimeout > 1000L) {
                        builder.connectTimeout(this.mTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.mTimeout, TimeUnit.MILLISECONDS).readTimeout(this.mTimeout, TimeUnit.MILLISECONDS);
                    }
                    this.mGraceClient = builder.build();
                }
            }
        }
        return this.mGraceClient;
    }

    private IRequestBuilder getRequestBuilder(@NonNull UploadRequestInfo uploadRequestInfo) {
        switch (uploadRequestInfo.mUploadRequestType) {
            case 1: {
                return new FeedbackUploadFileAli(this.getGrace(), this.mTimeout);
            }
            case 2: {
                return new FeedbackUploadFilePost(this.getGrace(), this.mTimeout);
            }
        }
        if (this.mRequestBuilder != null) {
            return this.mRequestBuilder;
        }
        this.mRequestBuilder = NAB.A.equals((Object)this.optAb) || NAB.B.equals((Object)this.optAb) ? new FeedbackUploadFilePost(this.getGrace(), this.mTimeout) : (NAB.C.equals((Object)this.optAb) || NAB.D.equals((Object)this.optAb) ? new FeedbackUploadFileAli(this.getGrace(), this.mTimeout) : new FeedbackUploadFilePost(this.getGrace(), this.mTimeout));
        return this.mRequestBuilder;
    }

    public void reportBug(UploadRequestInfo requestInfo, IUploadCallBack callBack) {
        YYTaskExecutor.execute(() -> this.reportBugReal(requestInfo, callBack));
    }

    private SimpleNetStringRespCallback getBugJsonPostCallback(final BugUploadInfo bugUploadInfo, final File uploadFile, final IUploadCallBack callBack) {
        return new SimpleNetStringRespCallback("getBugJsonPostCallback"){

            public void onError(Call call, Exception e, int id2) {
                super.onError(call, e, id2);
                MLog.error((Object)FeedbackUploader.TAG, (String)("onError: " + e), (Object[])new Object[0]);
                if (uploadFile != null && uploadFile.exists()) {
                    FeedbackUploader.deleteDir(uploadFile);
                }
                FeedbackUploader.this.reportFail(callBack, 3, e == null ? "" : e.toString(), e);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                super.onResponse(response, res, id2);
                if (uploadFile != null && YYFileUtils.isFileExisted((String)uploadFile.getAbsolutePath())) {
                    Callback<String> httpCallBack = new Callback<String>(){

                        public void onResponse(com.yy.grace.Call<String> call, Response<String> response) {
                            MLog.info((Object)FeedbackUploader.TAG, (String)("onResponse: " + response), (Object[])new Object[0]);
                            FeedbackUploader.deleteDir(uploadFile);
                        }

                        public void onFailure(com.yy.grace.Call<String> call, Throwable throwable) {
                            MLog.error((Object)FeedbackUploader.TAG, (String)("onError: " + throwable), (Object[])new Object[0]);
                            FeedbackUploader.deleteDir(uploadFile);
                        }
                    };
                    BugJson bugJson = new BugJson(bugUploadInfo);
                    String bugKey = ((JsonObject)JsonParser.parseJsonObject((String)((String)res.data), JsonObject.class)).get("key").getAsString();
                    StringBuilder urlBuilder = new StringBuilder("http://project.sysop.duowan.com/rest/api/latest/issue/");
                    if (!urlBuilder.toString().endsWith("/")) {
                        urlBuilder.append("/");
                    }
                    urlBuilder.append(bugKey);
                    urlBuilder.append("/");
                    urlBuilder.append("attachments");
                    String postUrl = urlBuilder.toString();
                    HashMap<String, String> headers = new HashMap<String, String>(2);
                    headers.put("Authorization", bugJson.getAuthString());
                    headers.put("X-Atlassian-Token", "nocheck");
                    HttpUtil.postFile().url(postUrl).header(headers).file(uploadFile, "file").execute((Callback)httpCallBack);
                    if (!TextUtils.isEmpty((CharSequence)bugUploadInfo.mImagePath)) {
                        File image = new File(bugUploadInfo.mImagePath);
                        HttpUtil.postFile().url(postUrl).header(headers).file(image, "file").execute((Callback)httpCallBack);
                    }
                }
                FeedbackUploader.this.reportSuccess(callBack);
            }

            public boolean needToken() {
                return false;
            }
        };
    }

    private void reportBugReal(final UploadRequestInfo requestInfo, final IUploadCallBack callBack) {
        this.findUploadLogFile(requestInfo, null, new IGetUploadLogCallBack(){

            @Override
            public void onSuccess(final File uploadFile) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String mCreateBugUrl = "http://project.sysop.duowan.com/rest/api/2/issue/";
                            String feedbackMsg = null;
                            if (requestInfo.mFeedbackMsg != null) {
                                feedbackMsg = requestInfo.mFeedbackMsg.replace("\n", ";");
                            }
                            BugUploadInfo bugInfo = new BugUploadInfo(feedbackMsg, "", requestInfo.mImagePath);
                            bugInfo.mContactInfo = requestInfo.mContactInfo;
                            BugJson bugJson = new BugJson(bugInfo);
                            String bugJsonString = bugJson.getActualJsonMap();
                            MLog.info((Object)FeedbackUploader.TAG, (String)bugJsonString, (Object[])new Object[0]);
                            MLog.info((Object)FeedbackUploader.TAG, (String)(uploadFile == null ? "" : uploadFile.toString()), (Object[])new Object[0]);
                            MLog.info((Object)FeedbackUploader.TAG, (String)bugJson.getAuthString(), (Object[])new Object[0]);
                            HashMap<String, String> headers = new HashMap<String, String>();
                            headers.put("Authorization", bugJson.getAuthString());
                            headers.put("X-Atlassian-Token", "nocheck");
                            HttpUtil.postJson().url("http://project.sysop.duowan.com/rest/api/2/issue/").json(bugJsonString).header(headers).execute((INetRespCallback)FeedbackUploader.this.getBugJsonPostCallback(bugInfo, uploadFile, callBack));
                            MLog.info((Object)FeedbackUploader.TAG, (String)"collectLogBySize() : Logs packing task finished", (Object[])new Object[0]);
                        }
                        catch (Exception ex) {
                            FeedbackUploader.this.reportFail(callBack, 4, ex.toString(), ex);
                        }
                    }
                });
            }

            @Override
            public void onFail(int errorCode, String des) {
                FeedbackUploader.this.reportFail(callBack, errorCode, des, null);
            }
        });
    }

    private boolean inCompressBlackList() {
        String deviceInfo = Build.BRAND + Build.DEVICE;
        return StringUtils.equalsIgnoreCase((String)deviceInfo, (String)"Xiaomikenzo");
    }

    private String tempDecompressDir() {
        String logDir = YYFileUtils.getYYTempDir();
        return logDir + File.separator + "tempLog" + File.separator;
    }

    private String uncaughtExceptionsLogsPath() {
        return FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath() + File.separator + UNCAUGHT_EXCEPTIONS_LOGS;
    }

    private String getPerfActionLogsPath() {
        return FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath() + File.separator + PERF_ACTION_LOGS;
    }

    private File getUncaughtCrashDumpLogsFileName() {
        File dir = new File(FileStorageUtils.getInstance().getDirAndCreate(false, "crash").getAbsolutePath());
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<File> dumpfiles = new ArrayList<File>();
        for (File f : files) {
            if (!f.getName().endsWith(".dmp")) continue;
            dumpfiles.add(f);
        }
        if (dumpfiles.isEmpty()) {
            return null;
        }
        File latesFile = (File)dumpfiles.get(0);
        for (File file : dumpfiles) {
            if (file.lastModified() <= latesFile.lastModified()) continue;
            latesFile = file;
        }
        return latesFile;
    }

    public boolean checkCompressed(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".7z");
    }

    public long getSDFreeSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSize();
        long freeBlocks = sf.getAvailableBlocks();
        return freeBlocks * blockSize;
    }

    private static boolean deleteDir(File dir) {
        String[] children;
        if (dir == null) {
            return true;
        }
        if (dir.isDirectory() && (children = dir.list()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = FeedbackUploader.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private void statMetric(UploadRequestInfo requestInfo, long useTime, long errorCode) {
        String uri = "feedback/";
        switch (requestInfo.mUploadRequestType) {
            case 1: 
            case 2: {
                uri = uri + "NON";
                break;
            }
            default: {
                uri = NAB.A.equals((Object)this.optAb) ? uri + "A" : (NAB.B.equals((Object)this.optAb) ? uri + "B" : (NAB.C.equals((Object)this.optAb) ? uri + "C" : (NAB.D.equals((Object)this.optAb) ? uri + "D" : uri + "NON")));
            }
        }
        uri = uri + "/" + this.mTimeout;
        HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)useTime, (String)String.valueOf(errorCode));
    }

    private void findUploadLogFile(final UploadRequestInfo requestInfo, final @Nullable UploadLog uploadLog, final IGetUploadLogCallBack callBack) {
        final ArrayList appLogFiles = new ArrayList();
        final ArrayList srcLogFiles = new ArrayList();
        final ArrayList destLogFiles = new ArrayList();
        KLogUtils.flush((IFlushCallback)new IFlushCallback(){

            public void onFlush(boolean finish) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        File[] logList = KLogUtils.getLogFileList();
                        if (logList == null || logList.length == 0) {
                            if (RuntimeContext.sIsDebuggable) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.feedback_app_log_error), (int)0);
                                    }
                                });
                            }
                        } else {
                            for (File file : logList) {
                                if (file == null || !file.isFile()) continue;
                                appLogFiles.add(file);
                            }
                        }
                        try {
                            FeedbackUploader.this.handleUploadFill(appLogFiles, srcLogFiles, destLogFiles, requestInfo, uploadLog);
                            File uploadFile = null;
                            if (destLogFiles.size() > 0) {
                                Pair pack = null;
                                pack = LogZipCompress.getInstance().compressFiles(destLogFiles, Collections.emptyList(), AccountUtil.getUid());
                                if (pack == null || pack.first == null || (Integer)pack.first != 0 || BlankUtil.isBlank((String)((String)pack.second))) {
                                    if (uploadLog != null) {
                                        uploadLog.i("compress error", String.valueOf(requestInfo), 90);
                                    }
                                    throw new UploadLogException(2, "");
                                }
                                uploadFile = new File((String)pack.second);
                            }
                            if (uploadFile != null && uploadFile.exists()) {
                                if (uploadLog != null) {
                                    uploadLog.i("compress file exist", String.valueOf(requestInfo), 100);
                                }
                                if (FeedbackUploader.this.checkOverSize(requestInfo, uploadFile)) {
                                    uploadFile = null;
                                    if (uploadLog != null) {
                                        uploadLog.i("compress file oversize", String.valueOf(requestInfo), 110);
                                    }
                                }
                            } else {
                                if (uploadLog != null) {
                                    uploadLog.i("compress file not exist", String.valueOf(requestInfo), 120);
                                }
                                MLog.info((Object)FeedbackUploader.TAG, (String)"upload file no exits: %s", (Object[])new Object[]{uploadFile == null ? null : uploadFile.getPath()});
                            }
                            FeedbackUploader.this.reportGetUploadSuccess(uploadFile, callBack);
                        }
                        catch (UploadLogException ex) {
                            MLog.error((Object)FeedbackUploader.TAG, (String)"findUploadLogFile fail", (Throwable)ex, (Object[])new Object[0]);
                            FeedbackUploader.this.reportGetUploadFail(callBack, ex.code, ex.desc, ex);
                        }
                        finally {
                            try {
                                File tempFile = new File(FeedbackUploader.this.tempDecompressDir());
                                FeedbackUploader.deleteDir(tempFile);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
            }
        });
    }

    private void handleUploadFill(List<File> appLogFiles, List<File> srcLogFiles, List<File> destLogFiles, UploadRequestInfo requestInfo, @Nullable UploadLog uploadLog) throws UploadLogException {
        File[] fileArray;
        File imageFile;
        if (uploadLog != null) {
            uploadLog.i("begin transaction", String.valueOf(requestInfo), 10);
        }
        if (requestInfo == null || requestInfo.hasReport) {
            if (uploadLog != null) {
                uploadLog.i("has been request", String.valueOf(requestInfo), 20);
            }
            return;
        }
        requestInfo.hasReport = true;
        int maxSize = (int)requestInfo.mUploadSizeMB * 1024 * 1024;
        String tempDir = this.tempDecompressDir();
        if (!BlankUtil.isBlank((String)requestInfo.mImagePath) && (imageFile = new File(requestInfo.mImagePath)).exists()) {
            destLogFiles.add(new File(requestInfo.mImagePath));
        }
        MLog.info((Object)TAG, (String)"collectLogBySize() : collecting UNCAUGHT_EXCEPTIONS log", (Object[])new Object[0]);
        File uncaughtExceptionFile = new File(this.uncaughtExceptionsLogsPath());
        if (uncaughtExceptionFile.exists()) {
            destLogFiles.add(uncaughtExceptionFile);
            MLog.info((Object)TAG, (String)"uncaughtExceptionFile exist:%s", (Object[])new Object[]{uncaughtExceptionFile.getAbsolutePath()});
        } else {
            MLog.info((Object)TAG, (String)"uncaughtExceptionFile not exist:%s", (Object[])new Object[]{uncaughtExceptionFile.getAbsolutePath()});
        }
        File crashDumpFile = this.getUncaughtCrashDumpLogsFileName();
        if (crashDumpFile != null) {
            destLogFiles.add(crashDumpFile);
        }
        if (uploadLog != null) {
            StringBuilder desLogFilesStringBuilder = new StringBuilder();
            for (File file : destLogFiles) {
                desLogFilesStringBuilder.append(file.getName()).append(',');
            }
            uploadLog.i("img and dump", desLogFilesStringBuilder.toString() + " ## " + requestInfo, 30);
        }
        MLog.info((Object)TAG, (String)("collectLogBySize() : collecting normal logs around this time point(" + requestInfo.mUploadStartTime + ")"), (Object[])new Object[0]);
        this.filterAndPutLogFile(appLogFiles, srcLogFiles, requestInfo.mLogStartTime, requestInfo.mLogEndTime, maxSize);
        if (uploadLog != null) {
            StringBuilder srcLogFilesStringBuilder = new StringBuilder();
            for (File file : srcLogFiles) {
                srcLogFilesStringBuilder.append(file.getName()).append(',');
            }
            uploadLog.i("log file", srcLogFilesStringBuilder.toString() + " ## " + requestInfo, 40);
        }
        if (this.getSDFreeSize() <= (long)maxSize) {
            if (uploadLog != null) {
                uploadLog.i("no space", String.valueOf(requestInfo), 50);
            }
            throw new UploadLogException(1, "");
        }
        File temp = new File(tempDir);
        if (temp.exists() && temp.isDirectory()) {
            if (uploadLog != null) {
                uploadLog.i("delete temp file", String.valueOf(requestInfo), 60);
            }
            FeedbackUploader.deleteDir(temp);
        }
        MLog.info((Object)TAG, (String)"collectLogBySize() : Logs packing task started", (Object[])new Object[0]);
        if (uploadLog != null) {
            uploadLog.i("copy and compress start", String.valueOf(requestInfo), 70);
        }
        boolean inBlackList = this.inCompressBlackList();
        if (srcLogFiles.size() > 0) {
            for (File file : srcLogFiles) {
                if (!inBlackList && this.checkCompressed(file.getName())) {
                    try {
                        if (file.length() < 200L) {
                            file.delete();
                            continue;
                        }
                        LogZipCompress.getInstance().decompress(file, tempDir);
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (String)"printStackTrace", (Throwable)e, (Object[])new Object[0]);
                    }
                    continue;
                }
                destLogFiles.add(file);
            }
        }
        if ((fileArray = new File(tempDir).listFiles()) != null) {
            for (File file : fileArray) {
                if (destLogFiles.contains(file)) continue;
                destLogFiles.add(file);
            }
        }
        if (uploadLog != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (File destLogFile2 : destLogFiles) {
                stringBuilder.append(destLogFile2.getName()).append(',');
            }
            uploadLog.i("tobe compress file", stringBuilder.toString(), 80);
        }
    }

    private void reportGetUploadFail(final IGetUploadLogCallBack callBack, final int errorCode, final String desc, Throwable exception) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onFail(errorCode, desc);
                }
            }
        });
    }

    private void reportGetUploadSuccess(final File uploadFile, final IGetUploadLogCallBack callBack) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onSuccess(uploadFile);
                }
            }
        });
    }

    private void reportSuccess(final IUploadCallBack callBack) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.success();
                }
            }
        });
    }

    private void reportFail(final IUploadCallBack callBack, final int errorCode, final String desc, Throwable exception) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onError(errorCode, desc);
                }
            }
        });
    }

    public class UploadLogException
    extends Exception {
        public int code;
        public String desc;

        public UploadLogException(int code, String desc) {
            super("upload log fail, code: " + code + ", desc: " + desc);
            this.code = code;
            this.desc = desc;
        }
    }

    public static interface IGetUploadLogCallBack {
        public void onSuccess(File var1);

        public void onFail(int var1, String var2);
    }

    public static interface IUploadCallBack {
        public void success();

        public void onError(int var1, String var2);
    }
}

