/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYScrollView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.feedback.FeedbackPage;
import com.yy.hiyo.mixmodule.feedback.IFeedbackViewCallBack;

public class FeedbackWindow
extends DefaultWindow {
    private SimpleTitleBar mStbTitleBar;
    private FeedbackPage mPager;
    private IFeedbackViewCallBack mCallBacks;
    private boolean isReportBug;

    public FeedbackWindow(Context context, int mode, IFeedbackViewCallBack callBacks, boolean isReportBug) {
        super(context, (UICallBacks)callBacks, "Feedback");
        this.mCallBacks = callBacks;
        YYFrameLayout container2 = new YYFrameLayout(context);
        this.isReportBug = 3 == mode;
        this.initTitle(context);
        if (3 != mode) {
            mode = mode == 1 ? 2 : 0;
        }
        this.mPager = new FeedbackPage(context, mode, callBacks, isReportBug);
        YYScrollView scrollView = new YYScrollView(context);
        scrollView.addView((View)this.mPager);
        scrollView.setVerticalScrollBarEnabled(false);
        int height = ResourceUtils.getDimen((int)R.dimen.top_header_height);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, height);
        this.mStbTitleBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.topMargin = height;
        scrollView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        container2.addView((View)this.mStbTitleBar);
        container2.addView((View)scrollView);
        container2.setBackgroundColor(ResourceUtils.getColor((int)R.color.bg_img));
        this.getBarLayer().addView((View)container2, -1, -1);
    }

    private void initTitle(Context context) {
        this.mStbTitleBar = new SimpleTitleBar(context, null);
        if (this.isReportBug) {
            this.mStbTitleBar.setLeftTitle("\u63d0bug");
        } else {
            this.mStbTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.feedback_title));
        }
        this.mStbTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                FeedbackWindow.this.mCallBacks.onBackIconClicked();
            }
        });
    }

    public void showPhoto(String iconUrl) {
        this.mPager.showPhoto(iconUrl);
    }

    public void showVideo(String iconUrl, String videoPath) {
        if (this.mPager != null) {
            this.mPager.showVideo(iconUrl, videoPath);
        }
    }

    public void updateCountry(String country) {
        this.mPager.updateCountry(country);
    }

    public void updateFeedbackContent(String feedback) {
        this.mPager.updateFeedbackContent(feedback);
    }

    public void updateSelectType(int feedType, boolean showTip) {
        this.mPager.updateSelectType(feedType, showTip);
    }

    public void showProgress() {
        if (this.mPager != null) {
            this.mPager.showProgress();
        }
    }

    public void hideProgress() {
        if (this.mPager != null) {
            this.mPager.hideProgress();
        }
    }
}

