/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.feedback.FeedBackAdapter;
import com.yy.hiyo.mixmodule.feedback.FeedBackTypeItemInfo;
import com.yy.hiyo.mixmodule.feedback.IFeedbackView;
import com.yy.hiyo.mixmodule.feedback.IFeedbackViewCallBack;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.FeedBackItemClickListener;
import com.yy.hiyo.mixmodule.feedback.widget.ksnack_lib.KSnack.KSnack;
import java.util.ArrayList;
import java.util.List;

public class FeedbackPage
extends YYFrameLayout
implements IFeedbackView {
    private Context mContext;
    private IFeedbackViewCallBack mUICallbacks;
    private RoundImageView mRoundImage;
    private YYTextView mSubmit;
    private YYImageView mDel;
    private YYEditText suggest;
    private YYRelativeLayout mRlRoot;
    private View addContainer;
    private final int spacing = 10;
    private Drawable preDrawable;
    private Drawable norDrawable;
    private YYEditText contactInfo;
    private String mImgPath;
    private int selectIndex = -1;
    private List<YYTextView> items = new ArrayList<YYTextView>();
    private RecyclerView feedbackRecycle;
    private FeedBackAdapter feedBackAdapter;
    private View mRootView;
    private boolean isReportBug;
    private long currentTime = 0L;
    private YYTextView peopleName;
    private YYEditText peopleNameEdit;
    private String mVideoPath;
    private DialogLinkManager mDialogLinkManager;
    private int[] mTypes;
    private final List<FeedBackTypeItemInfo> mData = new ArrayList<FeedBackTypeItemInfo>();
    private static final int[] FEEDBACK_TYPE = new int[]{1, 3, 4, 5, 7};
    private static final int[] DEBUG_TYPE = new int[]{8, 9, 10};
    FeedBackItemClickListener feedBackItemClickListener = new FeedBackItemClickListener(){

        @Override
        public void itemClick(FeedBackTypeItemInfo feedBackTypeItemInfo, int position) {
            FeedbackPage.this.selectType(feedBackTypeItemInfo.getType(), false);
        }
    };

    public FeedbackPage(Context context, int selectItem, IFeedbackViewCallBack controller, boolean isReportBug) {
        super(context);
        this.mContext = context;
        this.mUICallbacks = controller;
        this.mDialogLinkManager = new DialogLinkManager(this.mContext);
        this.isReportBug = isReportBug;
        this.createView();
    }

    private void createView() {
        this.mRootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_feedback_pager, (ViewGroup)this);
        this.initContentViews();
    }

    private void initContentViews() {
        this.mRlRoot = (YYRelativeLayout)this.findViewById(R.id.rl_feedback_root);
        this.mRoundImage = (RoundImageView)this.findViewById(R.id.fk_select_img);
        this.feedbackRecycle = (RecyclerView)this.findViewById(R.id.feedback_list);
        this.feedbackRecycle.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.feedBackAdapter = new FeedBackAdapter();
        this.feedbackRecycle.setAdapter((RecyclerView.Adapter)this.feedBackAdapter);
        this.mTypes = this.isReportBug ? DEBUG_TYPE : FEEDBACK_TYPE;
        int[] nArray = this.mTypes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer type = nArray[i];
            this.mData.add(new FeedBackTypeItemInfo(type, false));
        }
        this.feedBackAdapter.setItemClickListener(this.feedBackItemClickListener);
        this.feedBackAdapter.setData(this.mData);
        this.mDel = (YYImageView)this.findViewById(R.id.image_del);
        this.suggest = (YYEditText)this.findViewById(R.id.fk_suggest_edit);
        this.mSubmit = (YYTextView)this.findViewById(R.id.btn_submit);
        this.addContainer = this.findViewById(R.id.add_pic_container);
        this.contactInfo = (YYEditText)this.findViewById(R.id.fk_contactinfo);
        View people = this.findViewById(R.id.people);
        this.peopleName = (YYTextView)this.findViewById(R.id.people_name);
        this.peopleNameEdit = (YYEditText)this.findViewById(R.id.people_name_edit);
        if (this.isReportBug) {
            people.setVisibility(0);
            this.peopleName.setVisibility(0);
            this.peopleNameEdit.setVisibility(0);
        }
        this.preDrawable = this.getResources().getDrawable(R.drawable.feedback_radio_pre);
        this.preDrawable.setBounds(0, 0, this.preDrawable.getMinimumWidth(), this.preDrawable.getMinimumHeight());
        this.norDrawable = this.getResources().getDrawable(R.drawable.feedback_radio_nor);
        this.norDrawable.setBounds(0, 0, this.norDrawable.getMinimumWidth(), this.norDrawable.getMinimumHeight());
        TextView textView = (TextView)this.findViewById(R.id.feedback_agreement);
        if (textView != null) {
            textView.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_feedback_video_report));
        }
        this.addContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FeedbackPage.this.mUICallbacks.onImgChooseBtnClicked();
            }
        });
        this.suggest.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                FeedbackPage.this.checkBtnStatus();
            }
        });
        this.contactInfo.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                FeedbackPage.this.checkBtnStatus();
            }
        });
        this.mDel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageLoader.loadImage((ImageView)FeedbackPage.this.mRoundImage, null, (int)-1);
                FeedbackPage.this.mDel.setVisibility(4);
                FeedbackPage.this.mRoundImage.setVisibility(4);
                FeedbackPage.this.mImgPath = null;
                FeedbackPage.this.mVideoPath = null;
            }
        });
        this.mSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (System.currentTimeMillis() - FeedbackPage.this.currentTime <= 1000L) {
                    return;
                }
                FeedbackPage.this.currentTime = System.currentTimeMillis();
                if (FeedbackPage.this.isReportBug) {
                    if (FeedbackPage.this.peopleNameEdit.getText() == null || StringUtils.isEmpty((String)FeedbackPage.this.peopleNameEdit.getText().toString())) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u8bf7\u586b\u5199\u62a5\u544a\u4eba\uff0c\u518d\u63d0\u4ea4Bug!", (int)1);
                        return;
                    }
                    FeedbackPage.this.mUICallbacks.onReportBtnClicked(FeedbackPage.this.selectIndex, FeedbackPage.this.mImgPath, FeedbackPage.this.getMsg() + "    " + FeedbackPage.this.peopleNameEdit.getText().toString(), FeedbackPage.this.getContactInfo(), FeedbackPage.this.mVideoPath);
                } else {
                    String contactInfo = FeedbackPage.this.getContactInfo();
                    if (StringUtils.isEmpty((String)contactInfo)) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.feedback_contact_info), (int)1);
                    } else {
                        FeedbackPage.this.mUICallbacks.onReportBtnClicked(FeedbackPage.this.selectIndex, FeedbackPage.this.mImgPath, FeedbackPage.this.getMsg(), contactInfo, FeedbackPage.this.mVideoPath);
                    }
                }
            }
        });
        this.mRlRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImeUtil.hideIME((Context)FeedbackPage.this.mContext, (View)v);
            }
        });
        this.checkBtnStatus();
    }

    private void selectType(int type, boolean showTip) {
        this.selectIndex = type;
        for (FeedBackTypeItemInfo info : this.mData) {
            if (info.getType() == type) {
                info.setState(true);
                continue;
            }
            info.setState(false);
        }
        if (this.mData.size() > 0) {
            this.feedBackAdapter.notifyDataSetChanged();
        }
        if (this.selectIndex == 7 && showTip) {
            this.showRechargeTip();
        }
    }

    private void showRechargeTip() {
        if (SettingFlags.getBoolean((String)"feedback_recharge_tip_show", (boolean)true)) {
            final KSnack kSnack = new KSnack((ViewGroup)this.mRlRoot, this.mContext);
            kSnack.setAction("\u4e0d\u518d\u63d0\u9192", new View.OnClickListener(){

                public void onClick(View v) {
                    kSnack.dismiss();
                    SettingFlags.setBoolean((String)"feedback_recharge_tip_show", (boolean)false);
                }
            }).setMessage(ResourceUtils.getString((int)R.string.desc_recharge_problem_tips)).setTextColor(R.color.white).setBackColor(R.color.black_333333).setButtonTextColor(R.color.colorAccent).setDuration(4000).show();
        }
    }

    private void checkBtnStatus() {
        if (this.suggest != null && this.suggest.getText() != null && !StringUtils.isEmpty((String)this.suggest.getText().toString())) {
            String contactInfo = this.getContactInfo();
            if (StringUtils.isNotEmpty((String)contactInfo)) {
                this.updateSubmitEnable(true);
            } else {
                this.updateSubmitEnable(false);
            }
        } else {
            this.updateSubmitEnable(false);
        }
    }

    private String getMsg() {
        String result = "";
        if (this.selectIndex == 1) {
            result = ResourceUtils.getString((int)R.string.login_problem_report);
        } else if (this.selectIndex == 2) {
            result = ResourceUtils.getString((int)R.string.short_summary_game_related);
        } else if (this.selectIndex == 3) {
            result = ResourceUtils.getString((int)R.string.short_summary_personal_profile);
        } else if (this.selectIndex == 4) {
            result = ResourceUtils.getString((int)R.string.short_summary_chat_box);
        } else if (this.selectIndex == 5) {
            result = ResourceUtils.getString((int)R.string.short_summary_other_problems);
        } else if (this.selectIndex == 6) {
            result = ResourceUtils.getString((int)R.string.appeal_to_report);
        } else if (this.selectIndex == 7) {
            result = ResourceUtils.getString((int)R.string.short_summary_recharge_problem);
        } else if (this.selectIndex == 8) {
            result = "\u4ea7\u54c1\u4f53\u9a8c";
        } else if (this.selectIndex == 9) {
            result = "UI\u89c6\u68c0";
        } else if (this.selectIndex == 10) {
            result = "\u529f\u80fdBUG";
        }
        return this.suggest.getText() != null ? result + "--" + this.suggest.getText().toString() : result + "--";
    }

    private String getContactInfo() {
        String phone = this.contactInfo.getText() != null ? this.contactInfo.getText().toString() : "";
        return FP.empty((CharSequence)phone) ? "" : phone;
    }

    @Override
    public void showPhoto(String iconUrl) {
        if (StringUtils.isNotEmpty((String)iconUrl)) {
            ImageLoader.loadImage((ImageView)this.mRoundImage, (String)iconUrl, (int)-1);
            this.mRoundImage.setVisibility(0);
            this.mDel.setVisibility(0);
        } else {
            ImageLoader.loadImage((ImageView)this.mRoundImage, null, (int)-1);
            this.mRoundImage.setVisibility(4);
            this.mDel.setVisibility(4);
        }
        this.mImgPath = iconUrl;
    }

    @Override
    public void updatePhoneNum(String phoneNum) {
    }

    @Override
    public void updateCountry(String country) {
    }

    public void updateSelectType(int feedType, boolean showTip) {
        this.selectType(feedType, showTip);
    }

    public void updateFeedbackContent(String feedback) {
        if (feedback != null) {
            this.suggest.setText((CharSequence)feedback);
        }
    }

    public void updateSubmitEnable(boolean isEnable) {
        if (isEnable) {
            this.mSubmit.setEnabled(true);
            this.mSubmit.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.btn_presubmit_));
        } else {
            this.mSubmit.setEnabled(false);
            this.mSubmit.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.btn_submit));
        }
    }

    public void showVideo(String iconUrl, String videoPath) {
        if (StringUtils.isNotEmpty((String)iconUrl)) {
            ImageLoader.loadImage((ImageView)this.mRoundImage, (String)iconUrl, (int)-1);
            this.mRoundImage.setVisibility(0);
            this.mDel.setVisibility(0);
        } else {
            ImageLoader.loadImage((ImageView)this.mRoundImage, null, (int)-1);
            this.mRoundImage.setVisibility(4);
            this.mDel.setVisibility(4);
        }
        this.mVideoPath = videoPath;
    }

    public void showProgress() {
        ProgressDialog progressDialog = new ProgressDialog();
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.showDialog((BaseDialog)progressDialog);
        }
    }

    public void hideProgress() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }
}

