/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.feedback;

import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.extensions.BaseExtensionKt;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.FeedbackUploader;
import com.yy.hiyo.mixmodule.feedback.request.uploadUtil.UploadRequestInfo;
import java.text.SimpleDateFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J(\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/yy/hiyo/mixmodule/feedback/BitmapCheckController;", "Lcom/yy/appbase/core/DefaultController;", "environment", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "reportBug", "imgPath", "", "contactInfo", "videoPath", "mixmodule_debug"})
public final class BitmapCheckController
extends DefaultController {
    public void handleMessage(@Nullable Message msg) {
        block0: {
            Integer n;
            super.handleMessage(msg);
            Message message = msg;
            Integer n2 = n = message != null ? Integer.valueOf(message.what) : null;
            int n3 = BaseMsgDef.REPORT_BUG;
            if (n2 == null || n2 != n3) break block0;
            String imgPath = msg.getData().getString("img_path", "");
            int bitmapHeight = msg.getData().getInt("bitmap_height");
            int bitmapWidth = msg.getData().getInt("bitmap_width");
            int viewHeight = msg.getData().getInt("view_height");
            int viewWidth = msg.getData().getInt("view_width");
            String viewPath = msg.getData().getString("view_path", "");
            AbstractWindow abstractWindow = this.getCurrentWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractWindow, (String)"currentWindow");
            String currentWindow = abstractWindow.getName();
            String url = msg.getData().getString("url", "");
            String placeholderIdName = msg.getData().getString("placeholder_id_name", "");
            String reportMsg = "Bitmap Monitor - Bitmap size illegal: Bitmap = " + bitmapWidth + " x " + bitmapHeight + ", " + "View =" + viewWidth + " X " + viewHeight + ", url = " + url + ", placeholder = " + placeholderIdName + ", " + "curWindow = " + currentWindow + ", " + "ViewPath = " + viewPath;
            MLog.error((Object)BaseExtensionKt.getTAG((Object)((Object)this)), (String)reportMsg, (Object[])new Object[0]);
            String string2 = imgPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"imgPath");
            this.reportBug(string2, reportMsg, "liuzheng", "");
        }
    }

    private final void reportBug(String imgPath, String msg, String contactInfo, String videoPath) {
        SimpleDateFormat dateFormat = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
        String time = DateUtils.getTimeFromMillisecond((Long)System.currentTimeMillis(), (SimpleDateFormat)dateFormat);
        FeedbackUploader feedbackUploader = FeedbackUploader.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)feedbackUploader, (String)"FeedbackUploader.getInstance()");
        int uploadFileSize = feedbackUploader.getUploadFileSizeMaxLimit();
        UploadRequestInfo info = new UploadRequestInfo(time, msg, contactInfo, imgPath, 0L, 0L, uploadFileSize, 0, videoPath);
        FeedbackUploader.getInstance().reportBug(info, new FeedbackUploader.IUploadCallBack(){

            public void success() {
                MLog.info((Object)BaseExtensionKt.getTAG((Object)this), (String)"onReportBug success!", (Object[])new Object[0]);
            }

            public void onError(int errorCode, @NotNull String des) {
                Intrinsics.checkParameterIsNotNull((Object)des, (String)"des");
                MLog.info((Object)BaseExtensionKt.getTAG((Object)this), (String)"onReportBug onError!", (Object[])new Object[0]);
            }
        });
    }

    public BitmapCheckController(@NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        super(environment);
    }
}

