/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.ui.viewholder;

import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.discover.OnRecommendItemClickListener;
import com.yy.hiyo.mixmodule.discover.bean.BaseRecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.bean.RecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.BaseDiscoverViewHolder;

public class PeopleViewHolder
extends BaseDiscoverViewHolder {
    public View rootView;
    public FrameLayout headerContainer;
    public RecycleImageView header;
    public TextView nickname;
    public TextView distance;
    public YYTextView tag;
    public BaseRecommendUserInfo info;
    private OnRecommendItemClickListener mItemClickListener;
    private int mScreenWidth = 0;
    private int marginTop = 0;
    private int staggerMargin = 0;

    public PeopleViewHolder(View itemView) {
        super(itemView);
        this.rootView = itemView;
        this.headerContainer = (FrameLayout)itemView.findViewById(R.id.discover_head_ll);
        this.header = (RecycleImageView)itemView.findViewById(R.id.discover_head);
        this.nickname = (TextView)itemView.findViewById(R.id.discover_name);
        this.distance = (TextView)itemView.findViewById(R.id.discover_distance);
        this.tag = (YYTextView)itemView.findViewById(R.id.discover_tag);
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PeopleViewHolder.this.mItemClickListener != null) {
                    PeopleViewHolder.this.mItemClickListener.onItemClick(PeopleViewHolder.this.info);
                }
            }
        });
    }

    @Override
    public void setOnClickListener(OnRecommendItemClickListener listener) {
        super.setOnClickListener(listener);
        this.mItemClickListener = listener;
    }

    public void bindView(BaseRecommendUserInfo data) {
        super.bindView(data);
        this.bindViewHolder((RecommendUserInfo)data);
    }

    public void bindViewHolder(RecommendUserInfo info) {
        this.info = info;
        ImageLoader.loadImage((ImageView)this.header, (String)(info.getHeadPic() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)info.getSex()));
        this.nickname.setText((CharSequence)info.getNickname());
        if (info.getType() == 1) {
            this.tag.setVisibility(0);
            this.tag.setText((CharSequence)ResourceUtils.getString((int)R.string.friend));
            this.tag.setBackgroundResource(R.drawable.tag_facebook);
            this.distance.setVisibility(4);
        } else if (info.getType() == 2) {
            this.distance.setVisibility(0);
            this.distance.setText((CharSequence)this.formalDistance(info.getDistance()));
            this.tag.setVisibility(8);
        } else if (info.getType() == 4) {
            this.tag.setVisibility(8);
            this.distance.setVisibility(4);
        } else {
            this.tag.setVisibility(0);
            this.tag.setBackgroundResource(R.drawable.tag_game_master);
            this.tag.setText((CharSequence)ResourceUtils.getString((int)R.string.game_master));
            this.distance.setVisibility(4);
        }
    }

    private String formalDistance(float distance) {
        if (distance >= 1.0f) {
            return StringUtils.formatWitUSLocal((String)"%.2f km", (Object[])new Object[]{Float.valueOf(distance)});
        }
        if ((double)distance < 0.01) {
            return "<10m";
        }
        return StringUtils.formatWitUSLocal((String)"%d m", (Object[])new Object[]{(int)(distance *= 1000.0f)});
    }
}

