/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yy.base.utils.FP;
import com.yy.hiyo.mixmodule.discover.OnRecommendItemClickListener;
import com.yy.hiyo.mixmodule.discover.bean.BaseRecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.bean.IItemViewHolderFactory;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.BaseDiscoverViewHolder;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.PeopleViewHolderFactory;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class PeopleRecyclerAdapter
extends RecyclerView.Adapter<BaseDiscoverViewHolder> {
    private static String TAG = "PeopleRecyclerAdapter";
    private final List<BaseRecommendUserInfo> mData = new ArrayList<BaseRecommendUserInfo>();
    private OnRecommendItemClickListener mItemClickListener;

    public void setData(List<BaseRecommendUserInfo> data, boolean clear) {
        if (clear) {
            this.mData.clear();
            if (!FP.empty(data)) {
                this.mData.addAll(data);
            }
            this.notifyDataSetChanged();
        } else {
            this.addData(data);
        }
    }

    private void addData(List<BaseRecommendUserInfo> data) {
        if (FP.empty(data)) {
            return;
        }
        int origin = this.mData.size();
        this.mData.addAll(data);
        this.notifyItemRangeInserted(origin, data.size());
    }

    public void onViewAttachedToWindow(@NonNull BaseDiscoverViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        int pos = holder.getLayoutPosition();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams && pos < this.mData.size()) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(this.mData.get(pos).isFullSpan());
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20023805").put("function_id", "recommend_people_show");
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    @NonNull
    public BaseDiscoverViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        IItemViewHolderFactory factory = PeopleViewHolderFactory.getInstance().getViewHolderWithType(viewType);
        int layoutId = factory.getItemLayoutId();
        View rootView2 = LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
        Object holder = factory.createViewHolder(rootView2);
        ((BaseDiscoverViewHolder)((Object)holder)).setOnClickListener(this.mItemClickListener);
        return holder;
    }

    public void onBindViewHolder(@NonNull BaseDiscoverViewHolder holder, int position) {
        holder.bindView(this.getData(position));
    }

    private BaseRecommendUserInfo getData(int pos) {
        return this.mData.get(pos);
    }

    public void setItemClickListener(OnRecommendItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public int getItemCount() {
        if (FP.empty(this.mData)) {
            return 0;
        }
        return this.mData.size();
    }

    public int getItemViewType(int position) {
        return this.mData.get(position).getLayoutType();
    }
}

