/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.ui;

import android.content.Context;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yy.appbase.ui.widget.FingerGuideView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.mixmodule.discover.bean.BaseRecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.bean.RecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.BaseDiscoverViewHolder;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.PeopleViewHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GuideView
extends YYFrameLayout {
    private static final long DELAY = 500L;
    private FingerGuideView mFingerGuideView;
    private RecyclerView.OnChildAttachStateChangeListener mChangeListener;

    public GuideView(Context context) {
        super(context);
    }

    void listenToScrollView(RecyclerView recyclerView, FingerGuideView.FingerGuideCallback callback) {
        this.mFingerGuideView = FingerGuideView.of((Context)this.getContext()).topMargin(-ResolutionUtils.dip2Px((float)8.0f)).callback(callback).build();
        final Runnable mShowGuideTask = () -> {
            if (this.showGuide(recyclerView)) {
                recyclerView.post(() -> recyclerView.removeOnChildAttachStateChangeListener(this.mChangeListener));
            }
        };
        this.mChangeListener = new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(View view) {
                YYTaskExecutor.removeTask((Runnable)mShowGuideTask);
                YYTaskExecutor.postToMainThread((Runnable)mShowGuideTask, (long)500L);
            }

            public void onChildViewDetachedFromWindow(View view) {
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)mShowGuideTask, (long)500L);
        recyclerView.addOnChildAttachStateChangeListener(this.mChangeListener);
    }

    private boolean showGuide(RecyclerView recyclerView) {
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        int from = -1;
        int to = -1;
        if (manager instanceof LinearLayoutManager) {
            from = ((LinearLayoutManager)manager).findFirstCompletelyVisibleItemPosition();
            to = ((LinearLayoutManager)manager).findLastCompletelyVisibleItemPosition();
        } else if (manager instanceof StaggeredGridLayoutManager) {
            int[] first = ((StaggeredGridLayoutManager)manager).findFirstCompletelyVisibleItemPositions(null);
            int[] last = ((StaggeredGridLayoutManager)manager).findLastCompletelyVisibleItemPositions(null);
            from = first[0];
            int[] nArray = last;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer index = nArray[i];
                if (index == null || index < 0) continue;
                to = index;
            }
        }
        if (from >= 0 && to >= from) {
            for (int i = from; i <= to; ++i) {
                RecyclerView.ViewHolder holder = recyclerView.findViewHolderForLayoutPosition(i);
                if (!(holder instanceof BaseDiscoverViewHolder) || !this.isGuideType((BaseDiscoverViewHolder)holder)) continue;
                this.removeView((View)this.mFingerGuideView);
                this.addView((View)this.mFingerGuideView);
                this.mFingerGuideView.startGuide(holder.itemView);
                this.reportShow((BaseRecommendUserInfo)((BaseDiscoverViewHolder)holder).getItemData());
                return true;
            }
        }
        return false;
    }

    private boolean isGuideType(BaseDiscoverViewHolder holder) {
        return holder instanceof PeopleViewHolder;
    }

    private void reportShow(BaseRecommendUserInfo info) {
        long uid = 0L;
        if (info instanceof RecommendUserInfo) {
            uid = ((RecommendUserInfo)info).getUid();
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023805").put("function_id", "guide_show").put("ai_uid", "" + uid));
    }
}

