/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.ui;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import com.yy.appbase.animation.ScaleAnimationAdapter;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.FingerGuideView;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.ui.widget.status.IRequestCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.discover.IDiscoverUiCallback;
import com.yy.hiyo.mixmodule.discover.OnRecommendItemClickListener;
import com.yy.hiyo.mixmodule.discover.StaggeredItemDecoration;
import com.yy.hiyo.mixmodule.discover.bean.BaseRecommendUserInfo;
import com.yy.hiyo.mixmodule.discover.ui.GuideView;
import com.yy.hiyo.mixmodule.discover.ui.PeopleRecyclerAdapter;
import com.yy.hiyo.mixmodule.discover.ui.SelectSexPopupWindow;
import com.yy.hiyo.mixmodule.discover.ui.SexSelectedListener;
import com.yy.hiyo.mixmodule.discover.ui.viewholder.BaseDiscoverViewHolder;
import java.util.List;

public class DiscoverPeopleWindow
extends DefaultWindow {
    private static final String TAG = "DiscoverPeopleWindow";
    private static final long TIMEOUT = 10000L;
    private IDiscoverUiCallback mUiCallback;
    private View mRootView;
    private SimpleTitleBar mTitleBar;
    private RecyclerView mRecyclerView;
    private CommonStatusLayout mStatusLayout;
    private SmartRefreshLayout mSmartRefreshLayout;
    private PeopleRecyclerAdapter mAdapter;
    private ScaleAnimationAdapter mScaleAdapter;
    private SelectSexPopupWindow mSexPopupWindow;
    private int mSex = 2;
    private GuideView mGuideView;
    private boolean isFirst = true;
    private boolean mListDefaultScaleAnimState = true;
    private View.OnClickListener mSexClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            DiscoverPeopleWindow.this.showSexSelectPop();
        }
    };
    private Runnable mLoadingTimeout = new Runnable(){

        @Override
        public void run() {
            if (DiscoverPeopleWindow.this.mStatusLayout != null) {
                DiscoverPeopleWindow.this.mStatusLayout.showError();
            }
        }
    };
    private Runnable mRefreshTimeout = new Runnable(){

        @Override
        public void run() {
            if (DiscoverPeopleWindow.this.mSmartRefreshLayout != null) {
                DiscoverPeopleWindow.this.mSmartRefreshLayout.finishRefresh();
            }
        }
    };

    public DiscoverPeopleWindow(Context context, UICallBacks callBacks, IDiscoverUiCallback callback) {
        super(context, callBacks, "DiscoverPeople");
        this.mUiCallback = callback;
        this.createView(this.getContext(), this.getBaseLayer());
    }

    private void createView(Context context, ViewGroup rootView2) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_discovery, rootView2, true);
        this.mRootView = this.findViewById(R.id.root_view);
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.discover_title_bar);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.discover_recycler_view);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mSmartRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.mStatusLayout.setRequestCallback(new IRequestCallback(){

            public void onRequest(int type) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                } else {
                    DiscoverPeopleWindow.this.showLoading();
                    if (DiscoverPeopleWindow.this.mUiCallback != null) {
                        DiscoverPeopleWindow.this.mUiCallback.requestRecommend();
                    }
                }
            }
        });
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.mStatusLayout.showNetworkError();
        } else {
            this.showLoading();
        }
        this.mSmartRefreshLayout.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                    DiscoverPeopleWindow.this.mSmartRefreshLayout.finishRefresh();
                } else {
                    if (DiscoverPeopleWindow.this.mUiCallback != null) {
                        DiscoverPeopleWindow.this.mUiCallback.onRefresh();
                    }
                    YYTaskExecutor.postToMainThread((Runnable)DiscoverPeopleWindow.this.mRefreshTimeout, (long)5000L);
                }
            }
        });
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.discover_title));
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                DiscoverPeopleWindow.this.mUiCallback.back();
            }
        });
        this.mSex = this.mUiCallback.getCurSex();
        this.mSmartRefreshLayout.setEnableRefresh(true);
        this.mSmartRefreshLayout.setEnableLoadMore(false);
        this.mAdapter = new PeopleRecyclerAdapter();
        int spanCount = 3;
        if (RuntimeContext.sPhoneType == 1) {
            this.mListDefaultScaleAnimState = false;
        }
        this.mScaleAdapter = new ScaleAnimationAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mScaleAdapter.setOffsetY(ResolutionUtils.dip2Px((float)300.0f));
        this.mScaleAdapter.setScaleFrom(0.6f);
        this.mScaleAdapter.setFirstOnly(false);
        this.mScaleAdapter.setStartPosition(-1);
        this.mScaleAdapter.setDuration(400);
        this.mScaleAdapter.setCanAnim(this.mListDefaultScaleAnimState);
        this.mScaleAdapter.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mScaleAdapter);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new StaggeredItemDecoration(this.mAdapter));
        this.selectSex(this.mSex);
        StaggeredGridLayoutManager staggeredGridLayoutManager = new StaggeredGridLayoutManager(spanCount, 1);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)staggeredGridLayoutManager);
        int screenWidth = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext);
        this.mAdapter.setItemClickListener(new OnRecommendItemClickListener(){

            @Override
            public void onItemClick(BaseRecommendUserInfo info) {
                if (DiscoverPeopleWindow.this.mUiCallback != null) {
                    DiscoverPeopleWindow.this.mUiCallback.clickItem(info);
                }
            }

            @Override
            public void onLocationPermission() {
                DiscoverPeopleWindow.this.locationAction();
            }
        });
    }

    private void locationAction() {
        PermissionHelper.requestLocationPermission((Activity)((Activity)this.getContext()), (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                DiscoverPeopleWindow.this.mUiCallback.onRefresh();
            }

            public void onPermissionDenied(@NonNull String[] permission) {
            }
        }, (boolean)true);
    }

    public void onShown() {
        super.onShown();
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            return;
        }
        boolean permission = this.mUiCallback.checkLocationPermission();
        MLog.info((Object)TAG, (String)"hadLocationPermission: %s, isFirst: %s", (Object[])new Object[]{permission, this.isFirst});
        if (this.isFirst) {
            List<BaseRecommendUserInfo> data = this.mUiCallback.getRecommendList();
            if (!FP.empty(data)) {
                if (this.mStatusLayout != null) {
                    this.mStatusLayout.hideAllStatus();
                }
                YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
                this.mAdapter.setData(data, true);
                if (this.mRecyclerView != null) {
                    this.mRecyclerView.scrollToPosition(0);
                }
                this.checkGuide();
            } else {
                this.mUiCallback.requestRecommend();
            }
        }
        this.isFirst = false;
    }

    public void updateRecommendList(List<BaseRecommendUserInfo> list, boolean clear) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            return;
        }
        if (!FP.empty(list)) {
            if (this.mStatusLayout != null) {
                this.mStatusLayout.hideAllStatus();
            }
            if (this.mSmartRefreshLayout != null) {
                this.mSmartRefreshLayout.finishRefresh();
            }
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            YYTaskExecutor.removeTask((Runnable)this.mRefreshTimeout);
        }
        if (this.mAdapter != null) {
            this.mAdapter.setData(list, clear);
            if (clear && this.mRecyclerView != null) {
                this.mRecyclerView.scrollToPosition(0);
            }
            this.checkGuide();
        }
        if (clear && this.mScaleAdapter != null) {
            this.mScaleAdapter.resetLastPosition();
        }
    }

    private void selectSex(int sex) {
        if (this.mTitleBar == null) {
            return;
        }
        if (sex == 1) {
            this.mTitleBar.setRightBtn(R.drawable.sex_man, this.mSexClickListener);
        } else if (sex == 0) {
            this.mTitleBar.setRightBtn(R.drawable.sex_woman, this.mSexClickListener);
        } else {
            this.mTitleBar.setRightBtn(R.drawable.sex_all, this.mSexClickListener);
        }
    }

    private void showSexSelectPop() {
        if (this.mTitleBar == null) {
            return;
        }
        if (this.mSexPopupWindow == null) {
            this.mSexPopupWindow = new SelectSexPopupWindow(this.getContext());
            this.mSexPopupWindow.setSelectedListener(new SexSelectedListener(){

                @Override
                public void onSelected(int select) {
                    if (select == DiscoverPeopleWindow.this.mSex) {
                        return;
                    }
                    DiscoverPeopleWindow.this.mSex = select;
                    if (DiscoverPeopleWindow.this.mUiCallback != null) {
                        DiscoverPeopleWindow.this.mUiCallback.onSelectedSex(select);
                    }
                    DiscoverPeopleWindow.this.selectSex(select);
                    if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                    } else {
                        DiscoverPeopleWindow.this.showLoading();
                    }
                }
            });
        }
        if (!this.mSexPopupWindow.isShowing()) {
            this.mSexPopupWindow.show((View)this.mTitleBar, this.mUiCallback.getCurSex());
        }
    }

    public void showLoading() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showLoading();
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            YYTaskExecutor.postToMainThread((Runnable)this.mLoadingTimeout, (long)10000L);
        }
    }

    private void checkGuide() {
        MLog.info((Object)TAG, (String)"checkGuide mGuideView: %s", (Object[])new Object[]{this.mGuideView});
        if (this.mGuideView == null && this.mUiCallback.needShowGuide()) {
            this.mUiCallback.setAiGuideItemClick(true);
            this.mGuideView = new GuideView(this.getContext());
            this.getBaseLayer().addView((View)this.mGuideView, (ViewGroup.LayoutParams)this.getBaseLayerLP());
            this.mGuideView.listenToScrollView(this.mRecyclerView, new FingerGuideView.FingerGuideCallback(){

                public void onCardClick(View highLightView) {
                    RecyclerView.ViewHolder holder = DiscoverPeopleWindow.this.mRecyclerView.findContainingViewHolder(highLightView);
                    if (holder instanceof BaseDiscoverViewHolder) {
                        ((BaseDiscoverViewHolder)holder).performItemClick();
                    }
                }

                public void onGuideHide() {
                    DiscoverPeopleWindow.this.mUiCallback.setGuideShowed();
                    DiscoverPeopleWindow.this.getBaseLayer().removeView((View)DiscoverPeopleWindow.this.mGuideView);
                    DiscoverPeopleWindow.this.mGuideView = null;
                }
            });
        }
    }

    public void onDetached() {
        super.onDetached();
        this.mUiCallback.setAiGuideItemClick(false);
    }
}

