/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover.bean;

import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.login.base.LoginBaseMsgDef;
import com.yy.hiyo.mixmodule.discover.bean.RecommendUserInfo;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.EFromType;
import ikxd.apigateway.FriendListType;
import ikxd.apigateway.GetDiscoverPeopleReq;
import ikxd.apigateway.GetDiscoverPeopleRes;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.util.ArrayList;
import java.util.List;

public class DiscoverDataModel {
    private static String TAG = "DiscoverDataModel";
    private long mLastSeqId;

    public static DiscoverDataModel getInstance() {
        return Instance.instance;
    }

    public void requestDiscoverPeople(EFromType fromType, boolean permission, int curSex, final ICommonCallback<List<RecommendUserInfo>> iCommonCallback) {
        LocationInfo locationInfo = null;
        if (permission) {
            locationInfo = LocationHelper.getLocationInfo((boolean)true);
        }
        Object sex = MsgDispatcher.getInstance().sendMessageSync(LoginBaseMsgDef.MSG_GET_CUR_ACCOUNT_SEX);
        float latitude = locationInfo == null ? 0.0f : (float)locationInfo.getLatitude();
        float longitude = locationInfo == null ? 0.0f : (float)locationInfo.getLongitude();
        Header header = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        final GetDiscoverPeopleReq req = new GetDiscoverPeopleReq.Builder().latitude(Float.valueOf(latitude)).longitude(Float.valueOf(longitude)).sex(Long.valueOf(curSex)).my_sex(Long.valueOf(sex instanceof Integer ? ((Integer)sex).longValue() : 1L)).from_type(Long.valueOf(fromType.getValue())).limit(Long.valueOf(300L)).build();
        ApiGateway gateway = new ApiGateway.Builder().header(header).uri(Uri.kUriGetDiscoverPeopleReq).get_discover_people_req(req).build();
        this.mLastSeqId = header.seqid;
        MLog.info((Object)TAG, (String)"requestDiscoverPeople seqId: %s, lat: %s, long: %s", (Object[])new Object[]{header.seqid, req.latitude, req.longitude});
        ProtoManager.getInstance().send((AndroidMessage)gateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway apiGateway) {
                if (apiGateway == null) {
                    return;
                }
                Header header = apiGateway.header;
                if (header.seqid != DiscoverDataModel.this.mLastSeqId) {
                    return;
                }
                MLog.info((Object)TAG, (String)"requestDiscoverPeople onResponse seqId: %s, lat: %s, long: %s", (Object[])new Object[]{header.seqid, req.latitude, req.longitude});
                GetDiscoverPeopleRes res = apiGateway.get_discover_people_res;
                List list = res.users;
                DiscoverDataModel.this.convertDiscoverInfo(list, (ICommonCallback<List<RecommendUserInfo>>)iCommonCallback);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    private void convertDiscoverInfo(List<UserInfo> list, ICommonCallback<List<RecommendUserInfo>> iCommonCallback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"convertDiscoverInfo list.size: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (FP.empty(list)) {
            return;
        }
        ArrayList<RecommendUserInfo> mRecommendUsers = new ArrayList<RecommendUserInfo>(FP.size(list));
        for (UserInfo info : list) {
            RecommendUserInfo rui = RecommendUserInfo.newBuilder().headPic(info.avatar).nickname(info.nick).distance(info.dist).uid(info.uid).sex(info.sex.intValue()).type(this.convertType(info.type)).build();
            mRecommendUsers.add(rui);
        }
        if (iCommonCallback != null) {
            iCommonCallback.onSuccess(mRecommendUsers, new Object[0]);
        }
    }

    private int convertType(long type) {
        if (type == (long)FriendListType.EFB.getValue()) {
            return 1;
        }
        if (type == (long)FriendListType.ENearby.getValue()) {
            return 2;
        }
        if (type == (long)FriendListType.ELike.getValue()) {
            return 4;
        }
        return 3;
    }

    public boolean needShowGuide() {
        boolean result = RuntimeContext.isStartAtFirstInstalled() && NAB.A.equals((Object)NewABDefine.DISCOVER_PEOPLE_AI.getTest()) && SettingFlags.getBoolean((String)"is_first_show_discover_people_guide", (boolean)true);
        MLog.info((Object)TAG, (String)"needShowGuide isStartAtFirstInstalled %s, AB: %s, SettingFlagKeys.KEY_DISCOVER_PEOPLE_GUIDE: %s, show: %s", (Object[])new Object[]{RuntimeContext.isStartAtFirstInstalled(), NewABDefine.DISCOVER_PEOPLE_AI.getTest(), SettingFlags.getBoolean((String)"is_first_show_discover_people_guide", (boolean)true), result});
        return result;
    }

    public void setGuideShowed() {
        MLog.info((Object)TAG, (String)"setGuideShowed", (Object[])new Object[0]);
        SettingFlags.setBoolean((String)"is_first_show_discover_people_guide", (boolean)false);
    }

    public static class Instance {
        static DiscoverDataModel instance = new DiscoverDataModel();
    }
}

