/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.discover;

import androidx.annotation.Nullable;
import com.google.gson.reflect.TypeToken;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.mixmodule.discover.IRecommendInfoCacheCallback;
import com.yy.hiyo.mixmodule.discover.bean.RecommendUserInfo;
import com.yy.location.LocationHelper;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StorageRecommendUserInfo {
    private static final String TAG = "StorageRecommend";
    private static final int MAX_STORAGE = 50;
    private static final Object FILE_LOCK = new Object();
    private static final Type JSON_TYPE = new TypeToken<List<RecommendUserInfo>>(){}.getType();

    public static void updateRecommendUserInfo(List<RecommendUserInfo> list) {
        if (list == null) {
            return;
        }
        final ArrayList<RecommendUserInfo> listCopy = new ArrayList<RecommendUserInfo>(list);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = FILE_LOCK;
                synchronized (object) {
                    if (listCopy.size() > 50) {
                        JsonParser.writeJsonFile((String)StorageRecommendUserInfo.getCachePath(), listCopy.subList(0, 50), (Type)JSON_TYPE);
                    } else {
                        JsonParser.writeJsonFile((String)StorageRecommendUserInfo.getCachePath(), (Object)listCopy, (Type)JSON_TYPE);
                    }
                }
            }
        });
    }

    @Nullable
    public static void readCache(final IRecommendInfoCacheCallback callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String path = StorageRecommendUserInfo.getCachePath();
                Object object = FILE_LOCK;
                synchronized (object) {
                    try {
                        if (!FileUtils.isPathExist((String)path)) {
                            MLog.error((Object)StorageRecommendUserInfo.TAG, (String)"readCache path is not exist: %s", (Object[])new Object[]{path});
                            StorageRecommendUserInfo.notifyCallback(callback, null);
                            return;
                        }
                        List list = (List)JsonParser.parseJsonFile((String)path, (Type)JSON_TYPE);
                        StorageRecommendUserInfo.filter(list);
                        if (!MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)StorageRecommendUserInfo.TAG, (String)"list : %s", (Object[])new Object[]{list});
                        }
                        StorageRecommendUserInfo.notifyCallback(callback, list);
                    }
                    catch (Exception e) {
                        MLog.error((Object)StorageRecommendUserInfo.TAG, (String)"read recommend cache is failed.", (Throwable)e, (Object[])new Object[0]);
                        StorageRecommendUserInfo.notifyCallback(callback, null);
                    }
                }
            }
        });
    }

    public static void clear() {
        MLog.info((Object)TAG, (String)"onLoginOut clear discover cache", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = FILE_LOCK;
                synchronized (object) {
                    FileUtils.delete((String)StorageRecommendUserInfo.getCachePath());
                }
            }
        });
    }

    private static void filter(List<RecommendUserInfo> list) {
        if (FP.empty(list)) {
            return;
        }
        boolean location = LocationHelper.checkLocationPermission();
        if (!location) {
            Iterator<RecommendUserInfo> it = list.iterator();
            while (it.hasNext()) {
                RecommendUserInfo info = it.next();
                if (info.getType() != 2) continue;
                it.remove();
            }
        }
    }

    private static void notifyCallback(final IRecommendInfoCacheCallback callback, final List<RecommendUserInfo> list) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onReadCache(list);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onReadCache(list);
                }
            });
        }
    }

    private static String getCachePath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + "recommend_cache.txt";
    }
}

