/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.auto;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.mixmodule.auto.BaseTest;
import com.yy.hiyo.mixmodule.auto.ITester;
import com.yy.hiyo.mixmodule.auto.bean.TestConfig;

public abstract class BaseTestController
extends DefaultWindowController
implements ITester {
    public static final int MSG_SHOW_TOAST = 0;
    public static final int MSG_TEST = 1;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            BaseTest test;
            super.handleMessage(msg);
            if (0 == msg.what) {
                if (msg.obj instanceof String) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)((String)msg.obj), (int)0);
                }
            } else if (1 == msg.what && msg.obj instanceof BaseTest && (test = (BaseTest)msg.obj).tryTest()) {
                BaseTestController.this.startTest(test);
            }
        }
    };

    public BaseTestController(Environment env) {
        super(env);
    }

    protected void toast(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            Message msg = Message.obtain();
            msg.what = 0;
            msg.obj = str;
            this.mHandler.sendMessage(msg);
        }
    }

    public void startTest(BaseTest test) {
        if (test != null && test.isValid()) {
            this.mHandler.removeMessages(1);
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = test;
            this.mHandler.sendMessageDelayed(msg, ((TestConfig)test.mConfig).timeInterval);
        }
    }

    @Override
    public void stop() {
        this.mHandler.removeCallbacksAndMessages(null);
    }
}

