/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.auto;

import android.content.Context;
import android.os.Debug;
import android.os.SystemClock;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.mixmodule.auto.AppTestController;
import com.yy.hiyo.mixmodule.auto.ITester;
import com.yy.hiyo.mixmodule.auto.PathAutoTestController;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

class AppTester {
    public static final String KEY_TEST_ENABLE = "key_test_enable";
    private boolean mEnable = false;
    private Map<Integer, ITester> mTesters = new HashMap<Integer, ITester>();
    private static AppTester mAppTest;
    private TestProxyController mProxyController;
    private Environment mEnv;
    private PathAutoTestController mPathAutoTester;

    private AppTester() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppTester getInstance() {
        if (mAppTest != null) return mAppTest;
        Class<AppTester> clazz = AppTester.class;
        synchronized (AppTester.class) {
            if (mAppTest != null) return mAppTest;
            mAppTest = new AppTester();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mAppTest;
        }
    }

    public void init(Environment env) {
        if (!PathAutoTestController.isSwitchOn()) {
            return;
        }
        this.mEnv = env;
        this.testAppMustEvent();
        this.testLowMemory();
        if (env != null) {
            this.mPathAutoTester = new PathAutoTestController(this.mEnv);
            this.mPathAutoTester.test();
        }
    }

    public void deinit() {
        if (AppTestController.isSwitchOn()) {
            this.mProxyController = null;
            this.stopAll();
            this.mEnv = null;
        }
    }

    public void testLowMemory() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                long time = SystemClock.elapsedRealtime();
                RuntimeContext.sHappenLowMemWarn = true;
                Notification notification1 = Notification.obtain((int)NotificationDef.N_ON_TRIM_MEMORY);
                notification1.extObj = 15;
                Notification notification2 = Notification.obtain((int)NotificationDef.N_ON_LOW_MEMORY);
                if (time % 3L == 0L) {
                    NotificationCenter.getGlobalInstance().notify(notification1);
                    NotificationCenter.getGlobalInstance().notify(notification2);
                } else if (time % 3L == 1L) {
                    ImageLoader.clearMemory();
                    NotificationCenter.getGlobalInstance().notify(notification2);
                } else {
                    ImageLoader.trimMemory((int)15);
                    NotificationCenter.getGlobalInstance().notify(notification1);
                }
                AppTester.this.testLowMemory();
            }
        }, (long)30000L);
    }

    public void testAppMustEvent() {
        if (Debug.isDebuggerConnected() || RuntimeContext.isHagoPartySdk()) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String name;
                if (Debug.isDebuggerConnected()) {
                    return;
                }
                if (AccountUtil.getUid() <= 0L) {
                    AppTester.this.testAppMustEvent();
                    return;
                }
                if (!AppTestController.isSwitchOn()) {
                    return;
                }
                if (AppTester.this.mEnv == null || AppTester.this.mEnv.getWindowManager() == null) {
                    return;
                }
                if (AppTester.this.mEnv == null) {
                    return;
                }
                AbstractWindow window = AppTester.this.mEnv.getWindowManager().getCurrentWindow();
                String string2 = name = window != null ? window.getName() : "";
                if (StringUtils.equal((String)name, (String)"LoginTypeSelect") || StringUtils.equal((String)name, (String)"BasicProfile") || StringUtils.equal((String)name, (String)"PhoneLogin") || StringUtils.equal((String)name, (String)"PrePhoneLogin") || StringUtils.equal((String)name, (String)"Splash") || StringUtils.equal((String)name, (String)"Camera") || StringUtils.equal((String)name, (String)"ChooseInterestLabelWindow")) {
                    AppTester.this.testAppMustEvent();
                    return;
                }
                if (!RuntimeContext.sIsAppStartFinished && SettingFlags.getBoolean((String)"hasstorageper", (boolean)false)) {
                    throw new RuntimeException("\u542f\u52a8\u5b8c\u6210\u6807\u5fd7\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\uff01sIsAppStartFinished=" + RuntimeContext.sIsAppStartFinished + ", KEY_HAS_STORAGE_PERMISSION = " + SettingFlags.getBoolean((String)"hasstorageper", (boolean)false));
                }
            }
        }, (long)35000L);
    }

    private void registerTesters(int testId) {
        if (this.mProxyController == null) {
            return;
        }
        switch (testId) {
            default: 
        }
    }

    public void startTestTask(int testId, Object ... params) {
        this.stopAll();
        this.initEnv();
        this.registerTesters(testId);
        ITester iTester = this.mTesters.get(testId);
        if (iTester != null) {
            iTester.start(params);
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u6ca1\u6709\u6ce8\u518c\u76f8\u5173Tester", (int)0);
        }
    }

    private void initEnv() {
        if (this.mProxyController == null) {
            this.mProxyController = new TestProxyController(this.mEnv);
        }
    }

    public void stopAll() {
        if (this.mTesters == null || this.mTesters.isEmpty()) {
            return;
        }
        for (ITester iTester : this.mTesters.values()) {
            if (iTester == null) continue;
            iTester.stop();
        }
        this.mTesters.clear();
    }

    private void onDestroy() {
        this.mProxyController = null;
    }

    private static class TestProxyController
    extends DefaultWindowController {
        private WeakReference<AppTester> mAppTesterRef;

        TestProxyController(Environment env) {
            super(env);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_APP_DESTROY, (INotify)this);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_APP_RESTART, (INotify)this);
        }

        public void notify(Notification notification) {
            super.notify(notification);
            if (this.mAppTesterRef != null && this.mAppTesterRef.get() != null && notification.id == NotificationDef.N_APP_DESTROY) {
                ((AppTester)this.mAppTesterRef.get()).stopAll();
                ((AppTester)this.mAppTesterRef.get()).onDestroy();
                this.mAppTesterRef.clear();
                this.mAppTesterRef = null;
            }
        }
    }
}

