/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.aboutus;

import android.content.Context;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.mixmodule.R;
import com.yy.hiyo.mixmodule.aboutus.IAboutUsPageView;
import com.yy.hiyo.mixmodule.aboutus.IAboutUsViewCallBack;

public class AboutUsPage
extends YYFrameLayout
implements IAboutUsPageView {
    private Context mContext;
    private IAboutUsViewCallBack mUICallBack;
    private View mRootView;
    private SimpleTitleBar mStbTitleBar;
    private RecycleImageView mAboutLogo;
    private YYTextView mVersionName;
    private YYTextView mVersion;
    private YYTextView mAgreement;

    public AboutUsPage(Context context, IAboutUsViewCallBack callBack) {
        super(context);
        this.mContext = context;
        this.mUICallBack = callBack;
        this.createView();
    }

    private void createView() {
        this.mRootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_about_pager, (ViewGroup)this);
        this.initTitle();
        this.initContentViews();
    }

    private void initTitle() {
        this.mStbTitleBar = (SimpleTitleBar)this.findViewById(R.id.stb_title_bar);
        this.mStbTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.about_us));
        this.mStbTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                if (AboutUsPage.this.mUICallBack != null) {
                    AboutUsPage.this.mUICallBack.onBackClicked();
                }
            }
        });
    }

    private void initContentViews() {
        this.mAboutLogo = (RecycleImageView)this.findViewById(R.id.about_logo);
        this.mAgreement = (YYTextView)this.findViewById(R.id.about_agree);
        this.mVersion = (YYTextView)this.findViewById(R.id.about_version);
        this.mVersionName = (YYTextView)this.findViewById(R.id.about_version_name);
        if (RuntimeContext.sIsDebuggable) {
            this.showBranchDebug();
        }
        this.mAgreement.setMovementMethod(LinkMovementMethod.getInstance());
        ChainSpan chainSpan = ChainSpan.of();
        chainSpan.beginBlock().append((CharSequence)ResourceUtils.getString((int)R.string.short_tips_terms_of_service)).onBlockClick(() -> {
            if (this.mUICallBack != null) {
                this.mUICallBack.onTermsOfServiceClicked();
            }
        }, true, ResourceUtils.getColor((int)R.color.about_color_agreement)).endBlock().space().append((CharSequence)"&").space().beginBlock().append((CharSequence)ResourceUtils.getString((int)R.string.short_tips_privacy_policy)).onBlockClick(() -> {
            if (this.mUICallBack != null) {
                this.mUICallBack.onPrivacyPolicyClicked();
            }
        }, true, ResourceUtils.getColor((int)R.color.about_color_agreement)).endBlock().onFinish(text -> {
            if (this.mAgreement != null) {
                this.mAgreement.setText((CharSequence)text);
            }
        }).build();
        this.setImageLogo(R.drawable.icon_logo_about);
    }

    private void showBranchDebug() {
        TextView view = (TextView)this.findViewById(R.id.branch);
        view.setVisibility(0);
        view.setText((CharSequence)((IAppService)ServiceManagerProxy.getService(IAppService.class)).getBranchName());
    }

    @Override
    public void setImageLogo(int resId) {
        ImageLoader.loadImage((ImageView)this.mAboutLogo, (int)resId);
    }

    @Override
    public void setVersionName(String versionName) {
        this.mVersionName.setText((CharSequence)versionName);
    }

    @Override
    public void setVersion(String version) {
        this.mVersion.setText((CharSequence)version);
    }
}

