/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class PerfManager {
    private static volatile boolean sStatConnecting = false;
    private static volatile String sLastStatConnectUrl = null;

    public static void statWsConnect(final boolean lastConnect, final boolean neverConnect) {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", lastConnect ? "1" : "0");
                statContent.put("ifieldtwo", RuntimeContext.isStartAtFirstInstalled() ? 1 : 0);
                statContent.put("ifieldthree", neverConnect ? 1 : 0);
                statContent.put("ifieldfour", 1);
                statContent.put("perftype", "wsclient");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)10000L);
    }

    public static void statHttpRequest(final String url) {
        if (AccountUtil.getUid() <= 0L || StringUtils.isEmpty((String)url)) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("sfield", url);
                statContent.put("perftype", "httprequest");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)(RuntimeContext.sIsAppStarted ? 0L : 8000L));
    }

    public static void statWsConnect(final boolean success, final String wsUrl, final String errorInfo) {
        if (AccountUtil.getUid() <= 0L || !RuntimeContext.sIsForeground) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (sStatConnecting && (wsUrl == null || StringUtils.equal((String)sLastStatConnectUrl, (String)wsUrl)) || !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    return;
                }
                sStatConnecting = true;
                String registerHostBackUp = UriProvider.getRegisterHostBackUp();
                boolean useRegisterHostBackUp = false;
                if (wsUrl != null && StringUtils.isNotEmpty((String)registerHostBackUp) && wsUrl.contains(registerHostBackUp)) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyWsConnectProxy/" + registerHostBackUp), (long)0L, (String)(success ? "0" : "1"));
                    useRegisterHostBackUp = true;
                } else {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyWsConnect/" + UriProvider.getRegisterHostOrigin()), (long)0L, (String)(success ? "0" : "1"));
                }
                sLastStatConnectUrl = wsUrl;
                if (!success && StringUtils.isNotEmpty((String)errorInfo)) {
                    boolean pingGoogle = NetworkUtils.pingHost((String)"www.google.com");
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", pingGoogle ? "1" : "0");
                    statContent.put("sfield", errorInfo);
                    statContent.put("sfieldtwo", wsUrl);
                    statContent.put("ifieldtwo", useRegisterHostBackUp ? 1 : 0);
                    statContent.put("ifieldfour", 2);
                    statContent.put("perftype", "wsclient");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }
                YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                    public void run() {
                        sStatConnecting = false;
                    }
                }, (long)10000L);
            }
        };
        YYTaskExecutor.execute((Runnable)command);
    }

    public static void statOOS(final boolean success, String errorInfo, final long useTime) {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                HiidoStatis.reportAppMonitorReturnCode((String)"OSS/total", (long)useTime, (String)(success ? "0" : "1"));
            }
        };
        YYTaskExecutor.execute((Runnable)command);
    }
}

