/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PreferenceUtil
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private SharedPreferences.Editor mEditor;
    private SharedPreferences mSharedPreferences;
    private static final String ARRAY_TAG = "WCS-ARRAY-TAG:";
    private final List<PreferencesListener> mPreferencesListeners = new ArrayList<PreferencesListener>();

    public static synchronized PreferenceUtil newInstance(Context context, String name) {
        return new PreferenceUtil(context, name);
    }

    public static synchronized PreferenceUtil newInstance(Context context) {
        return new PreferenceUtil(context, "wcs-default");
    }

    private PreferenceUtil(Context context, String name) {
        this.mSharedPreferences = context.getSharedPreferences(name, 0);
    }

    public void addListener(PreferencesListener listener) {
        if (listener != null) {
            this.mPreferencesListeners.add(listener);
        }
    }

    public void commit() {
        if (this.mEditor != null) {
            this.mEditor.commit();
            this.mEditor = null;
        }
    }

    public void putBoolean(String key, boolean value) {
        if (this.mEditor == null) {
            this.mEditor = this.mSharedPreferences.edit();
        }
        this.mEditor.putBoolean(key, value);
    }

    public void putBooleanAndCommit(String key, boolean value) {
        this.putBoolean(key, value);
        this.mEditor.commit();
        this.mEditor = null;
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.mSharedPreferences.getBoolean(key, defValue);
    }

    public void putInt(String key, int value) {
        if (this.mEditor == null) {
            this.mEditor = this.mSharedPreferences.edit();
        }
        this.mEditor.putInt(key, value);
    }

    public void putIntAndCommit(String key, int value) {
        this.putInt(key, value);
        this.mEditor.commit();
        this.mEditor = null;
    }

    public int getInt(String key, int defValue) {
        return this.mSharedPreferences.getInt(key, defValue);
    }

    public void putLong(String key, long value) {
        if (this.mEditor == null) {
            this.mEditor = this.mSharedPreferences.edit();
        }
        this.mEditor.putLong(key, value);
    }

    public void putLongAndCommit(String key, long value) {
        this.putLong(key, value);
        this.mEditor.commit();
        this.mEditor = null;
    }

    public long getLong(String key, long defValue) {
        return this.mSharedPreferences.getLong(key, defValue);
    }

    public void putString(String key, String value) {
        if (this.mEditor == null) {
            this.mEditor = this.mSharedPreferences.edit();
        }
        this.mEditor.putString(key, value);
    }

    public void putStringAndCommit(String key, String value) {
        this.putString(key, value);
        this.mEditor.commit();
        this.mEditor = null;
    }

    public String getString(String key, String defValue) {
        return this.mSharedPreferences.getString(key, defValue);
    }

    public void putStringArrayAndCommit(String key, String[] strings) {
        String value = ARRAY_TAG + this.convertListToString(strings);
        this.putStringAndCommit(key, value);
    }

    public String[] getStringArray(String key, String[] defValue) {
        String persistentValue = this.getString(key, "");
        if (TextUtils.isEmpty((CharSequence)persistentValue) || !persistentValue.startsWith(ARRAY_TAG) || !persistentValue.contains(",")) {
            return defValue;
        }
        return persistentValue.substring(ARRAY_TAG.length()).split(",");
    }

    public Map<String, ?> getAll() {
        return this.mSharedPreferences.getAll();
    }

    public void remove(String key) {
        if (this.mEditor == null) {
            this.mEditor = this.mSharedPreferences.edit();
        }
        this.mEditor.remove(key);
    }

    public void removeAndCommit(String key) {
        this.remove(key);
        this.mEditor.commit();
        this.mEditor = null;
    }

    public void onSharedPreferenceChanged(SharedPreferences preferences, String key) {
        if (null != this.mPreferencesListeners) {
            for (int i = this.mPreferencesListeners.size() - 1; i >= 0; --i) {
                this.mPreferencesListeners.get(i).afterChanged(preferences, key);
            }
        }
    }

    public void registerChangeListener() {
        this.mSharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void unregisterChangeListener() {
        this.mSharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    private String convertListToString(String[] contexts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < contexts.length; ++i) {
            sb.append(contexts[i]);
            if (i + 1 >= contexts.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static interface PreferencesListener {
        public void afterChanged(SharedPreferences var1, String var2);
    }
}

