/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static File getFile(Context context, Uri uri) {
        uri = FileUtil.fileUri(context, uri);
        try {
            return new File(uri.getPath());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Uri fileUri(Context context, Uri uri) {
        Uri fileUri = uri;
        if (!uri.toString().startsWith("file")) {
            String filePath;
            if (uri != null && "content".equals(uri.getScheme())) {
                Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
                cursor.moveToFirst();
                filePath = cursor.getString(0);
                cursor.close();
            } else {
                filePath = uri.getPath();
            }
            fileUri = Uri.parse((String)("file://" + filePath));
        }
        return fileUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fromFile, String toFile) {
        File file = new File(toFile);
        if (file.exists() && !file.delete()) {
            WCSLogUtil.w("failed to delete " + toFile);
        }
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            is = new FileInputStream(fromFile);
            fos = new FileOutputStream(toFile);
            byte[] b = new byte[1024];
            int count = 0;
            while ((count = ((InputStream)is).read(b)) != -1) {
                fos.write(b, 0, count);
            }
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File copyFromAsset(String asset, Context context, String destinationPath) throws IOException {
        int nread;
        InputStream source = context.getAssets().open(asset);
        File destinationFile = new File(destinationPath, asset);
        destinationFile.getParentFile().mkdirs();
        FileOutputStream destination = new FileOutputStream(destinationFile);
        byte[] buffer = new byte[1024];
        while ((nread = source.read(buffer)) != -1) {
            if (nread == 0) {
                nread = source.read();
                if (nread < 0) break;
                ((OutputStream)destination).write(nread);
                continue;
            }
            ((OutputStream)destination).write(buffer, 0, nread);
        }
        ((OutputStream)destination).close();
        return destinationFile;
    }

    public static String getSdcardPath() {
        String sdcardRootPath = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            sdcardRootPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return sdcardRootPath;
    }
}

