/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.utils;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class EncodeUtils {
    public static byte[] urlsafeEncodeBytes(byte[] src) {
        if (src.length % 3 == 0) {
            return EncodeUtils.encodeBase64Ex(src);
        }
        byte[] b = EncodeUtils.encodeBase64Ex(src);
        if (b.length % 4 == 0) {
            return b;
        }
        int pad = 4 - b.length % 4;
        byte[] b2 = new byte[b.length + pad];
        System.arraycopy(b, 0, b2, 0, b.length);
        b2[b.length] = 61;
        if (pad > 1) {
            b2[b.length + 1] = 61;
        }
        return b2;
    }

    public static byte[] urlsafeBase64Decode(String encoded) {
        byte[] rawbs = encoded.getBytes();
        for (int i = 0; i < rawbs.length; ++i) {
            if (rawbs[i] == 95) {
                rawbs[i] = 47;
                continue;
            }
            if (rawbs[i] != 45) continue;
            rawbs[i] = 43;
        }
        return Base64.decode((byte[])rawbs, (int)2);
    }

    public static String urlsafeDecodeString(String encoded) {
        return new String(EncodeUtils.urlsafeBase64Decode(encoded));
    }

    public static String urlsafeEncodeString(byte[] src) {
        return new String(EncodeUtils.urlsafeEncodeBytes(src));
    }

    public static String urlsafeEncode(String text) {
        try {
            return new String(EncodeUtils.urlsafeEncodeBytes(text.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static byte[] encodeBase64Ex(byte[] src) {
        byte[] b64 = Base64.encode((byte[])src, (int)2);
        for (int i = 0; i < b64.length; ++i) {
            if (b64[i] == 47) {
                b64[i] = 95;
                continue;
            }
            if (b64[i] != 43) continue;
            b64[i] = 45;
        }
        return b64;
    }

    public static String MD5(String str) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        char[] charArray = str.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString().toLowerCase();
    }
}

