/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.network;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.chinanetcenter.wcs.android.Config;
import com.chinanetcenter.wcs.android.LogRecorder;
import com.chinanetcenter.wcs.android.entity.OperationMessage;
import com.chinanetcenter.wcs.android.exception.ClientException;
import com.chinanetcenter.wcs.android.exception.ServiceException;
import com.chinanetcenter.wcs.android.internal.SliceUploadRequest;
import com.chinanetcenter.wcs.android.internal.UploadFileRequest;
import com.chinanetcenter.wcs.android.internal.WcsProgressCallback;
import com.chinanetcenter.wcs.android.internal.WcsRetryHandler;
import com.chinanetcenter.wcs.android.network.ExecutionContext;
import com.chinanetcenter.wcs.android.network.ResponseParser;
import com.chinanetcenter.wcs.android.network.WcsRequest;
import com.chinanetcenter.wcs.android.network.WcsResult;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.json.JSONException;

public class WcsRequestTask<T extends WcsResult>
implements Callable<T> {
    private ResponseParser<T> mResponseParser;
    private WcsRequest mParams;
    private ExecutionContext mExecutionContext;
    private OkHttpClient mOkHttpClient;
    private WcsRetryHandler retryHandler;
    private int currentRetryCount;
    private static HashMap<String, String> sIpList;

    public WcsRequestTask(WcsRequest params, ResponseParser responseParser, ExecutionContext executionContext, int maxRetry) {
        this.mParams = params;
        this.mResponseParser = responseParser;
        this.mExecutionContext = executionContext;
        this.mOkHttpClient = executionContext.getClient();
        this.retryHandler = new WcsRetryHandler(maxRetry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        OperationMessage operationMessage;
        Request request = null;
        Response response = null;
        Exception exception = null;
        Call call = null;
        WcsResult result = null;
        try {
            Object formBuilder;
            if (this.mExecutionContext.getCancellationHandler() != null && this.mExecutionContext.getCancellationHandler().isCancelled()) {
                throw new InterruptedIOException("the task is cancelled");
            }
            Request.Builder requestBuilder = new Request.Builder();
            String url = this.mParams.getUrl();
            WCSLogUtil.i("url: " + this.mParams.getUrl());
            requestBuilder = requestBuilder.url(url);
            for (String key : this.mParams.getHeaders().keySet()) {
                requestBuilder = requestBuilder.addHeader(key, this.mParams.getHeaders().get(key));
            }
            requestBuilder.header("User-Agent", String.format("WCS-Android-SDK-%s-%s-%s(%s)", Config.VERSION, Build.MODEL, Build.VERSION.RELEASE, "https://www.chinanetcenter.com"));
            String contentType = this.mParams.getHeaders().get("Content-Type");
            switch (this.mParams.getMethod()) {
                case PUT: 
                case POST: {
                    if (this.mParams.getUploadData() != null) {
                        requestBuilder = requestBuilder.method(this.mParams.getMethod().toString(), (RequestBody)new ProgressRequestBody(this.mParams.getUploadData(), contentType, this.mExecutionContext.getProgressCallback()));
                        break;
                    }
                    if (this.mParams.getUploadFilePath() != null) {
                        requestBuilder = requestBuilder.method(this.mParams.getMethod().toString(), (RequestBody)new ProgressRequestBody(new File(this.mParams.getUploadFilePath()), contentType, this.mExecutionContext.getProgressCallback()));
                        break;
                    }
                    if (this.mParams.getFile() != null) {
                        formBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                        this.addParams((MultipartBody.Builder)formBuilder, this.mParams.getParameters());
                        MultipartBody body = formBuilder.addFormDataPart("file", this.mParams.getName(), (RequestBody)new ProgressRequestBody(this.mParams.getFile(), contentType, this.mExecutionContext.getProgressCallback())).build();
                        requestBuilder = requestBuilder.post((RequestBody)body);
                        break;
                    }
                    if (this.mParams.getUploadInputStream() != null) {
                        requestBuilder = requestBuilder.method(this.mParams.getMethod().toString(), (RequestBody)new ProgressRequestBody(this.mParams.getUploadInputStream(), this.mParams.getReadStreamLength(), contentType, this.mExecutionContext.getProgressCallback()));
                        break;
                    }
                    requestBuilder = requestBuilder.method(this.mParams.getMethod().toString(), RequestBody.create(null, (byte[])new byte[0]));
                    break;
                }
                case GET: {
                    requestBuilder = requestBuilder.get();
                    break;
                }
                case HEAD: {
                    requestBuilder = requestBuilder.head();
                    break;
                }
                case DELETE: {
                    requestBuilder = requestBuilder.delete();
                    break;
                }
            }
            request = requestBuilder.build();
            call = this.mOkHttpClient.newCall(request);
            if (this.mExecutionContext.getCancellationHandler() != null) {
                this.mExecutionContext.getCancellationHandler().setCall(call);
            }
            response = call.execute();
            result = (WcsResult)this.mResponseParser.parse(response);
            this.dump(url, result);
            if (response.isSuccessful()) {
                if (this.mExecutionContext.getCompletedCallback() != null) {
                    this.mExecutionContext.getCompletedCallback().onSuccess(this.mExecutionContext.getRequest(), result);
                }
                formBuilder = result;
                return (T)formBuilder;
            }
            exception = new ServiceException(response.code(), result.getRequestId(), result.getResponse());
        }
        catch (Exception e) {
            WCSLogUtil.e(e.toString());
            this.dump(e);
            exception = new ClientException(e.getMessage(), e);
        }
        finally {
            if (this.mExecutionContext.getCancellationHandler() != null) {
                this.mExecutionContext.getCancellationHandler().setFinished(true);
            }
            if (response != null) {
                response.close();
            }
        }
        if (call != null && call.isCanceled() || this.mExecutionContext.getCancellationHandler() != null && this.mExecutionContext.getCancellationHandler().isCancelled()) {
            exception = new ClientException("Task is cancelled!", exception.getCause(), true);
        }
        boolean shouldRetry = this.retryHandler.shouldRetry(exception, this.currentRetryCount);
        WCSLogUtil.e("[run] - retry, should retry: " + shouldRetry);
        if (shouldRetry) {
            ++this.currentRetryCount;
            if (this.mExecutionContext.getProgressCallback() != null && this.mExecutionContext.getRequest() instanceof SliceUploadRequest && this.mParams.getReadStreamLength() > 0L) {
                this.mExecutionContext.getProgressCallback().onProgress(this.mExecutionContext.getRequest(), -this.mParams.getReadStreamLength(), 0L);
                WCSLogUtil.e("[run] - retry, progress: " + -this.mParams.getReadStreamLength());
            }
            return (T)this.call();
        }
        if (exception instanceof ServiceException) {
            try {
                operationMessage = OperationMessage.fromJsonString(exception.getMessage(), ((ServiceException)exception).getRequestId());
            }
            catch (JSONException e) {
                Log.e((String)"CNCLog", (String)("json error : " + exception.getMessage()));
                String message = String.format("url : %s,\r\n status : %s,\r\n header : %s\r\n", this.mParams.getUrl(), result.getStatusCode(), result.getHeaders());
                operationMessage = new OperationMessage(0, message);
            }
        } else {
            operationMessage = new OperationMessage(exception);
        }
        if (this.mExecutionContext.getCompletedCallback() != null) {
            this.mExecutionContext.getCompletedCallback().onFailure(this.mExecutionContext.getRequest(), operationMessage);
        }
        throw exception;
    }

    private void dump(Exception e) {
        if (!LogRecorder.getInstance().getLock().booleanValue()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        String responseIdentifier = String.format("*** time : %s,\r\n *** exception : %s\r\n", timestamp, e.getLocalizedMessage());
        LogRecorder.getInstance().dumpLog(responseIdentifier);
    }

    private void dump(String url, WcsResult result) {
        if (!LogRecorder.getInstance().getLock().booleanValue()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        long contentLength = result.getResponse().length();
        String destIp = this.getIpByUrl(url);
        String responseIdentifier = String.format("*** time : %s,\r\n *** destIp : %s,\r\n *** uri : %s,\r\n *** status : %s,\r\n *** length : %s\r\n", timestamp, destIp, url, result.getStatusCode(), contentLength);
        LogRecorder.getInstance().dumpLog(responseIdentifier);
        LogRecorder.getInstance().dumpLog(result.getHeaders() + "\n");
        LogRecorder.getInstance().dumpLog("*** response : " + result.getResponse() + "\n");
    }

    private void addParams(MultipartBody.Builder builder, Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)params.get(key)));
            }
        }
    }

    private String getIpByUrl(String url) {
        if (sIpList == null) {
            sIpList = new HashMap();
        }
        String urlHost = "";
        try {
            URL uploadURL = new URL(url);
            urlHost = uploadURL.getHost();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)urlHost)) {
            return "0.0.0.0";
        }
        String ipString = sIpList.get(urlHost);
        if (!TextUtils.isEmpty((CharSequence)ipString)) {
            return ipString;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(urlHost);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (null == addr) {
            return "0.0.0.0";
        }
        byte[] ipParts = addr.getAddress();
        StringBuffer sb = new StringBuffer();
        for (byte b : ipParts) {
            int i = b & 0xFF;
            sb.append(i + ".");
        }
        String resolvedIpString = sb.toString();
        sIpList.put(urlHost, resolvedIpString);
        return resolvedIpString;
    }

    class ProgressRequestBody
    extends RequestBody {
        private static final int SEGMENT_SIZE = 2048;
        private byte[] data;
        private File file;
        private InputStream inputStream;
        private String contentType;
        private long contentLength;
        private WcsProgressCallback callback;
        private BufferedSink bufferedSink;

        public ProgressRequestBody(File file, String contentType, WcsProgressCallback callback) {
            this.file = file;
            this.contentType = contentType;
            this.callback = callback;
            this.contentLength = file.length();
        }

        public ProgressRequestBody(byte[] data, String contentType, WcsProgressCallback callback) {
            this.data = data;
            this.contentType = contentType;
            this.contentLength = data.length;
            this.callback = callback;
        }

        public ProgressRequestBody(InputStream input, long contentLength, String contentType, WcsProgressCallback callback) {
            this.inputStream = input;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.callback = callback;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            long read;
            Source source = null;
            if (this.file != null) {
                source = Okio.source((File)this.file);
            } else if (this.data != null) {
                source = Okio.source((InputStream)new ByteArrayInputStream(this.data));
            } else if (this.inputStream != null) {
                source = Okio.source((InputStream)this.inputStream);
            }
            int count = 0;
            long number = this.setNormalProgressFrequency(0L);
            for (long total = 0L; total < this.contentLength; total += read) {
                long remain = this.contentLength - total;
                long toRead = Math.min(remain, 2048L);
                read = source.read(sink.buffer(), toRead);
                if (read == -1L) break;
                sink.flush();
                if (this.callback == null || !(WcsRequestTask.this.mExecutionContext.getRequest() instanceof UploadFileRequest) || (long)(++count) != number && remain > 2048L) continue;
                count = 0;
                this.callback.onProgress(WcsRequestTask.this.mExecutionContext.getRequest(), total, this.contentLength);
            }
            WcsRequestTask.this.mParams.setReadStreamLength(this.contentLength);
            if (this.callback != null && WcsRequestTask.this.mExecutionContext.getRequest() instanceof SliceUploadRequest) {
                this.callback.onProgress(WcsRequestTask.this.mExecutionContext.getRequest(), this.contentLength, this.contentLength);
            }
            if (source != null) {
                source.close();
            }
        }

        private long setNormalProgressFrequency(long number) {
            if (this.callback != null && WcsRequestTask.this.mExecutionContext.getRequest() instanceof UploadFileRequest) {
                number = this.contentLength / 2048L;
                number = this.contentLength % 2048L == 0L ? number : (number = number + 1L);
                number = number / 10L > 0L ? number / 10L : 1L;
            }
            return number;
        }
    }
}

