/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.internal;

import android.support.annotation.NonNull;
import com.chinanetcenter.wcs.android.entity.SliceResponse;
import com.chinanetcenter.wcs.android.internal.UploadFileResult;
import com.chinanetcenter.wcs.android.network.ResponseParser;
import com.chinanetcenter.wcs.android.network.WcsResult;
import com.chinanetcenter.wcs.android.utils.WCSLogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseParsers {
    @NonNull
    private static void setWcsResult(Response response, WcsResult result) throws IOException {
        String data;
        result.setStatusCode(response.code());
        Map<String, String> responseHeader = ResponseParsers.parseResponseHeader(response);
        result.setResponseHeader(responseHeader);
        if (!response.isSuccessful()) {
            result.setRequestId(responseHeader.get("X-Reqid"));
        }
        if (response.body() == null) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("code", 500);
                jsonObject.put("message", (Object)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
                data = jsonObject.toString();
            }
            catch (JSONException e) {
                WCSLogUtil.e(e.getMessage());
                data = "Service error";
            }
        } else {
            data = response.body().string();
        }
        result.setResponse(data);
    }

    private static String parseResponse(InputStream in) throws IOException {
        if (in == null) {
            return "";
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int count = -1;
        while ((count = in.read(data, 0, 1024)) != -1) {
            outputStream.write(data, 0, count);
        }
        data = null;
        String jsonStr = new String(outputStream.toByteArray(), "utf-8");
        outputStream.close();
        return jsonStr;
    }

    public static void safeCloseResponse(Response response) {
        try {
            response.body().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map<String, String> parseResponseHeader(Response response) {
        HashMap<String, String> result = new HashMap<String, String>();
        Headers headers = response.headers();
        for (int i = 0; i < headers.size(); ++i) {
            result.put(headers.name(i), headers.value(i));
        }
        return result;
    }

    public static class UploadBlockResponseParser
    implements ResponseParser<SliceResponse> {
        @Override
        public SliceResponse parse(Response response) throws IOException, JSONException {
            SliceResponse result = new SliceResponse();
            ResponseParsers.setWcsResult(response, result);
            if (response.isSuccessful()) {
                SliceResponse.fromJsonString(result, result.getResponse());
            }
            return result;
        }
    }

    public static class UploadResponseParser
    implements ResponseParser<UploadFileResult> {
        @Override
        public UploadFileResult parse(Response response) throws IOException {
            UploadFileResult result = new UploadFileResult();
            ResponseParsers.setWcsResult(response, result);
            return result;
        }
    }

    public static class BaseResponseParser
    implements ResponseParser<WcsResult> {
        @Override
        public WcsResult parse(Response response) throws IOException {
            WcsResult result = new WcsResult();
            ResponseParsers.setWcsResult(response, result);
            return result;
        }
    }
}

