/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android.internal;

import android.content.Context;
import com.chinanetcenter.wcs.android.ClientConfig;
import com.chinanetcenter.wcs.android.entity.SliceResponse;
import com.chinanetcenter.wcs.android.internal.ResponseParsers;
import com.chinanetcenter.wcs.android.internal.SliceUploadRequest;
import com.chinanetcenter.wcs.android.internal.UploadFileRequest;
import com.chinanetcenter.wcs.android.internal.UploadFileResult;
import com.chinanetcenter.wcs.android.internal.WcsCompletedCallback;
import com.chinanetcenter.wcs.android.network.CancellationHandler;
import com.chinanetcenter.wcs.android.network.ExecutionContext;
import com.chinanetcenter.wcs.android.network.WcsAsyncTask;
import com.chinanetcenter.wcs.android.network.WcsRequest;
import com.chinanetcenter.wcs.android.network.WcsRequestTask;
import com.chinanetcenter.wcs.android.network.WcsResult;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class InternalRequest {
    private OkHttpClient innerClient;
    private ExecutorService executorService;
    private Map<Context, List<CancellationHandler>> requestMap;
    private int maxRetryCount;

    public InternalRequest(ClientConfig conf) {
        int maxConcurrentRequest;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(false).cache(null);
        if (conf != null) {
            Dispatcher dispatcher = new Dispatcher();
            maxConcurrentRequest = conf.getMaxConcurrentRequest();
            dispatcher.setMaxRequests(maxConcurrentRequest);
            builder.connectTimeout((long)conf.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).dispatcher(dispatcher);
            this.maxRetryCount = conf.getMaxErrorRetry();
        } else {
            maxConcurrentRequest = 5;
        }
        this.executorService = Executors.newFixedThreadPool(maxConcurrentRequest);
        this.innerClient = builder.build();
        this.requestMap = new WeakHashMap<Context, List<CancellationHandler>>();
    }

    public WcsAsyncTask<UploadFileResult> upload(UploadFileRequest request, WcsCompletedCallback<UploadFileRequest, UploadFileResult> completedCallback, Context context) {
        return this.upload(request, completedCallback, context, null);
    }

    public WcsAsyncTask<UploadFileResult> upload(UploadFileRequest request, WcsCompletedCallback<UploadFileRequest, UploadFileResult> completedCallback, Context context, Object tag) {
        ExecutionContext<UploadFileRequest> executionContext = new ExecutionContext<UploadFileRequest>(this.innerClient, request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        if (request.getProgressCallback() != null) {
            executionContext.setProgressCallback(request.getProgressCallback());
        }
        ResponseParsers.UploadResponseParser parser = new ResponseParsers.UploadResponseParser();
        WcsRequestTask callable = new WcsRequestTask(request, parser, executionContext, this.maxRetryCount);
        return this.sendRequest(executionContext, callable, context, tag);
    }

    private WcsAsyncTask sendRequest(ExecutionContext executionContext, Callable callable, Context context, Object tag) {
        if (context != null) {
            CancellationHandler cancellationHandler = new CancellationHandler();
            cancellationHandler.setTag(tag);
            executionContext.setCancellationHandler(cancellationHandler);
            List<CancellationHandler> requestList = this.requestMap.get(context);
            if (requestList == null) {
                requestList = new CopyOnWriteArrayList<CancellationHandler>();
                this.requestMap.put(context, requestList);
            }
            requestList.add(cancellationHandler);
            for (int i = 0; i < requestList.size(); ++i) {
                if (!requestList.get(i).shouldBeGarbageCollected()) continue;
                requestList.remove(i);
            }
        }
        return WcsAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public void cancelRequests(Context context) {
        List<CancellationHandler> requestList = this.requestMap.get(context);
        if (requestList != null) {
            for (CancellationHandler cancellationHandler : requestList) {
                cancellationHandler.cancel();
            }
            this.requestMap.remove(context);
        }
        System.gc();
    }

    public void cancelRequests(Context context, Object tag) {
        List<CancellationHandler> requestList = this.requestMap.get(context);
        if (requestList != null) {
            CopyOnWriteArrayList<CancellationHandler> cancelledHandler = new CopyOnWriteArrayList<CancellationHandler>();
            for (CancellationHandler cancellationHandler : requestList) {
                boolean shouldCancel;
                boolean bl = shouldCancel = tag == null;
                if (!shouldCancel) {
                    shouldCancel = tag.equals(cancellationHandler.getTag());
                }
                if (!shouldCancel) continue;
                cancellationHandler.cancel();
                cancelledHandler.add(cancellationHandler);
            }
            requestList.removeAll(cancelledHandler);
            if (requestList.size() == 0) {
                this.requestMap.remove(context);
            }
            System.gc();
        }
    }

    public WcsAsyncTask<SliceResponse> uploadBlock(Object tag, SliceUploadRequest request, WcsCompletedCallback<WcsRequest, SliceResponse> completedCallback, Context context) {
        ExecutionContext<SliceUploadRequest> executionContext = new ExecutionContext<SliceUploadRequest>(this.innerClient, request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.UploadBlockResponseParser parser = new ResponseParsers.UploadBlockResponseParser();
        WcsRequestTask callable = new WcsRequestTask(request, parser, executionContext, this.maxRetryCount);
        return this.sendRequest(executionContext, callable, context, tag);
    }

    public WcsAsyncTask<WcsResult> mergeBlock(Object tag, WcsRequest request, WcsCompletedCallback<WcsRequest, WcsResult> completedCallback, Context context) {
        ExecutionContext<WcsRequest> executionContext = new ExecutionContext<WcsRequest>(this.innerClient, request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.BaseResponseParser parser = new ResponseParsers.BaseResponseParser();
        WcsRequestTask callable = new WcsRequestTask(request, parser, executionContext, this.maxRetryCount);
        return this.sendRequest(executionContext, callable, context, tag);
    }
}

