/*
 * Decompiled with CFR 0.152.
 */
package com.chinanetcenter.wcs.android;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class LogRecorder {
    private static final String FILE_NAME = "wcs-dump.log";
    private String mFilePathString = "";
    private volatile Boolean mLock = false;

    private LogRecorder() {
    }

    public static LogRecorder getInstance() {
        return SingletonHolder.sInstance;
    }

    public void setup(Context context) {
        this.mFilePathString = context.getFilesDir() + File.separator + FILE_NAME;
    }

    public void enableLog() {
        this.mLock = true;
    }

    public void disableLog() {
        this.mLock = false;
    }

    public Boolean getLock() {
        return this.mLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpLog(String str) {
        Boolean bl = this.mLock;
        synchronized (bl) {
            if (!this.mLock.booleanValue()) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mFilePathString)) {
                File logFile = new File(this.mFilePathString);
                if (!logFile.exists()) {
                    try {
                        logFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    BufferedWriter buf = new BufferedWriter(new FileWriter(logFile, true));
                    buf.append(str);
                    buf.newLine();
                    buf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Log.e((String)"CNCLog", (String)"Log recorder hava not setted up.");
            }
        }
    }

    private static class SingletonHolder {
        private static LogRecorder sInstance = new LogRecorder();

        private SingletonHolder() {
        }
    }
}

