/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.mixmodule.shortcut;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.core.content.pm.ShortcutInfoCompat;
import androidx.core.content.pm.ShortcutManagerCompat;
import androidx.core.graphics.drawable.IconCompat;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.hiyo.mixmodule.shortcut.ShortcutReceiver;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;

public class a
extends AbstractController {
    public a(Environment environment) {
        super(environment);
    }

    public Object handleMessageSync(Message message) {
        Object object;
        if (message == null) {
            return null;
        }
        if (message.what == BaseMsgDef.MSG_SEND_SHORTCUT_TO_DESKTOP) {
            Bundle bundle = message.getData();
            if (bundle != null) {
                Object object2;
                Bitmap bitmap = null;
                int n2 = bundle.getInt("iconRes", -1);
                if (n2 > 0 && (object2 = ResourceUtils.getDrawable((int)n2)) instanceof BitmapDrawable) {
                    bitmap = ((BitmapDrawable)object2).getBitmap();
                }
                object2 = bundle.getString("url");
                String string2 = bundle.getString("title");
                String string3 = bundle.getString("shortcut_id");
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = string2;
                }
                if (bitmap == null) {
                    bitmap = (Bitmap)bundle.getParcelable("iconBmp");
                }
                if (StringUtils.isNotEmpty((String)string2) && StringUtils.isNotEmpty((String)object2)) {
                    return this.a(string2, (String)object2, bitmap, string3);
                }
            }
            return false;
        }
        if (message.what == BaseMsgDef.MSG_REMOVE_SHORTCUT_FROM_DESKTOP) {
            Bundle bundle = message.getData();
            if (bundle != null) {
                String string4 = bundle.getString("url");
                String string5 = bundle.getString("title");
                if (StringUtils.isNotEmpty((String)string5) && StringUtils.isNotEmpty((String)string4)) {
                    return this.a(string5, string4);
                }
            }
        } else if (message.what == BaseMsgDef.MSG_CHECK_SHORTCUT_EXIST && (object = message.obj) instanceof String) {
            if (this.mContext == null) {
                return false;
            }
            return a.a(this.mContext, (String)object);
        }
        return super.handleMessageSync(message);
    }

    public static boolean a(Context context, String string2, Intent intent, Bitmap bitmap, String string3) {
        try {
            if (ShortcutManagerCompat.isRequestPinShortcutSupported((Context)context)) {
                intent.setAction("android.intent.action.VIEW");
                intent.putExtra("duplicate", false);
                ShortcutInfoCompat shortcutInfoCompat = new ShortcutInfoCompat.Builder(context, string3).setIcon(IconCompat.createWithBitmap((Bitmap)bitmap)).setShortLabel((CharSequence)string2).setIntent(intent).build();
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(context, ShortcutReceiver.class), (int)0x8000000);
                ShortcutManagerCompat.requestPinShortcut((Context)context, (ShortcutInfoCompat)shortcutInfoCompat, (IntentSender)pendingIntent.getIntentSender());
                return true;
            }
        }
        catch (Exception exception) {
            MLog.error((Object)"Shortcut", (Throwable)exception);
        }
        return false;
    }

    private static Intent a(Context context, String string2, String string3) {
        Intent intent = ((IAppService)ServiceManagerProxy.getService(IAppService.class)).getHagoSchemeIntent(context, string3);
        intent.setAction("shortcut_action");
        intent.putExtra("shortcut_title", string2);
        intent.putExtra("shortcut_url", URLEncoder.encode(string3));
        intent.putExtra("android.intent.extra.shortcut.INTENT", string2);
        return intent;
    }

    private boolean a(String string2, String string3, Bitmap bitmap, String string4) {
        if (this.mContext == null) {
            return false;
        }
        if (a.a(this.mContext, string4)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"Shortcut", (String)"sendShortcutToDesktop shortcut had exit, id: %s", (Object[])new Object[]{string4});
            }
            return true;
        }
        return a.a(this.mContext, string2, a.a(this.mContext, string2, string3), bitmap, string4);
    }

    private boolean a(String string2, String string3) {
        if (this.mContext == null) {
            return false;
        }
        Intent intent = new Intent("com.android.launcher.action.UNINSTALL_SHORTCUT");
        intent.putExtra("android.intent.extra.shortcut.NAME", string2);
        Intent intent2 = a.a(this.mContext, string2, string3);
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent2);
        try {
            this.mContext.sendBroadcast(intent);
            return true;
        }
        catch (Exception exception) {
            MLog.error((Object)"Shortcut", (Throwable)exception);
            return false;
        }
    }

    public static boolean a(Context context, String string2) {
        if (Build.VERSION.SDK_INT >= 25) {
            List list;
            ShortcutManager shortcutManager = (ShortcutManager)context.getSystemService(ShortcutManager.class);
            if (shortcutManager != null && !FP.empty((Collection)(list = shortcutManager.getPinnedShortcuts()))) {
                for (ShortcutInfo shortcutInfo : list) {
                    if (!StringUtils.equal((String)shortcutInfo.getId(), (String)string2)) continue;
                    return true;
                }
            }
        } else {
            return a.b(context, string2);
        }
        return false;
    }

    public static boolean b(Context context, String string2) {
        boolean bl = false;
        if (null == context || TextUtils.isEmpty((CharSequence)string2)) {
            return bl;
        }
        String string3 = "";
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = a.c(context);
        }
        ContentResolver contentResolver = context.getContentResolver();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                Uri uri = Uri.parse((String)string3);
                Cursor cursor = contentResolver.query(uri, new String[]{"title", "iconResource"}, "title=?", new String[]{string2}, null);
                if (cursor != null && cursor.getCount() > 0) {
                    bl = true;
                } else {
                    ShortcutManager shortcutManager = null;
                    if (Build.VERSION.SDK_INT >= 25) {
                        shortcutManager = (ShortcutManager)context.getSystemService(ShortcutManager.class);
                        List list = shortcutManager.getPinnedShortcuts();
                    }
                }
                if (null != cursor && !cursor.isClosed()) {
                    cursor.close();
                }
            }
            catch (Exception exception) {
                MLog.error((Object)"Shortcut", (String)"isShortCutExist", (Throwable)exception, (Object[])new Object[0]);
            }
        }
        return bl;
    }

    public static String a(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            return "";
        }
        if (resolveInfo.activityInfo.packageName.equals("android")) {
            return "";
        }
        return resolveInfo.activityInfo.packageName;
    }

    public static String b(Context context) {
        return a.c(context, "com.android.launcher.permission.READ_SETTINGS");
    }

    public static String c(Context context, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        try {
            List list = context.getPackageManager().getInstalledPackages(8);
            if (list == null) {
                return "";
            }
            for (PackageInfo packageInfo : list) {
                ProviderInfo[] providerInfoArray = packageInfo.providers;
                if (providerInfoArray == null) continue;
                for (ProviderInfo providerInfo : providerInfoArray) {
                    if (!string2.equals(providerInfo.readPermission) && !string2.equals(providerInfo.writePermission) || TextUtils.isEmpty((CharSequence)providerInfo.authority) || !providerInfo.authority.contains(".launcher.settings")) continue;
                    return providerInfo.authority;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public static String c(Context context) {
        String string2 = a.b(context);
        if (string2 == null || string2.trim().equals("")) {
            String string3 = a.a(context);
            string3 = string3 + ".permission.READ_SETTINGS";
            string2 = a.c(context, string3);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            int n2 = Build.VERSION.SDK_INT;
            string2 = n2 < 8 ? "com.android.launcher.settings" : (n2 < 19 ? "com.android.launcher2.settings" : "com.android.launcher3.settings");
        }
        string2 = "content://" + string2 + "/favorites?notify=true";
        return string2;
    }
}

