/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.plugins.micup.common.ChannelMicUpMsgDef;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultUiCallback;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultWindow;
import com.yy.hiyo.game.service.IGameAudioService;
import org.jetbrains.annotations.NotNull;

public class MicUpResultWindowController
extends DefaultWindowController
implements MicUpResultUiCallback {
    private MicUpResultWindow mMicUpResultWindow;
    private OnResultListener mResultListener;

    public MicUpResultWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ChannelMicUpMsgDef.MSG_SHOW_RESULT_PAGE) {
            this.openMicUpResultWindow(msg);
        } else if (msg.what == ChannelMicUpMsgDef.MSG_HIDE_RESULT_PAGE) {
            this.closeWindowByMsg(msg);
        } else {
            FeatureLog.e((String)"FTMicUpResult", (String)"cannot handle this message.", (Object[])new Object[0]);
        }
    }

    private boolean checkShowResultArg(@NotNull Message msg) {
        Bundle bundle = msg.getData();
        return bundle.containsKey("room_id") && bundle.containsKey("term") && bundle.containsKey("is_audience");
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        this.playAudio("micUpResultShow");
    }

    protected boolean onWindowBackKeyEvent() {
        this.closeMicUpResultWindow(false);
        return true;
    }

    private void openMicUpResultWindow(Message msg) {
        if (this.checkShowResultArg(msg)) {
            if (this.mMicUpResultWindow != null) {
                this.closeMicUpResultWindowReal(true);
            }
            Bundle data = msg.getData();
            boolean isAudience = data.getBoolean("is_audience");
            String roomId = data.getString("room_id");
            int term = data.getInt("term");
            int roleType = data.getInt("role_type", 9);
            if (msg.obj instanceof OnResultListener) {
                this.mResultListener = (OnResultListener)msg.obj;
            }
            this.mMicUpResultWindow = new MicUpResultWindow((Context)this.mContext, this, "MicUpResultWindow", isAudience);
            this.mMicUpResultWindow.initData(roomId, term, roleType);
            this.mMicUpResultWindow.initShareHelper(this.getServiceManager(), this.mDialogLinkManager);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mMicUpResultWindow, true);
        } else {
            FeatureLog.e((String)"FTMicUpResult", (String)"show result page but parameter incomplete", (Object[])new Object[0]);
        }
    }

    private void closeWindowByMsg(Message msg) {
        String roomId;
        if (msg == null) {
            return;
        }
        Bundle data = msg.getData();
        boolean withAnim = data == null ? true : data.getBoolean("with_anim", true);
        String string2 = roomId = data == null ? null : data.getString("room_id", null);
        if (FP.empty((CharSequence)roomId)) {
            this.closeMicUpResultWindowReal(withAnim);
        } else if (this.mMicUpResultWindow != null && FP.eq((Object)roomId, (Object)this.mMicUpResultWindow.getRoomId())) {
            this.closeMicUpResultWindowReal(withAnim);
        }
    }

    @Override
    public void closeMicUpResultWindow(boolean autoReady) {
        this.closeMicUpResultWindowReal(true);
        if (this.mResultListener != null) {
            this.mResultListener.onCloseWindow(autoReady);
        }
        this.mResultListener = null;
    }

    private void closeMicUpResultWindowReal(boolean withAnim) {
        if (this.mMicUpResultWindow != null) {
            this.mWindowMgr.popWindow(withAnim, (AbstractWindow)this.mMicUpResultWindow);
            this.mMicUpResultWindow = null;
        }
    }

    private void playAudio(String key) {
        ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play(key);
    }

    public static interface OnResultListener {
        public void onCloseWindow(boolean var1);
    }
}

