/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.channel.plugins.micup.result.BaseMicUpResultPage;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultAdapter;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultItemView;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MicUpResultAudiencePage
extends BaseMicUpResultPage
implements View.OnClickListener {
    private RecycleImageView mCloseView;
    private MicUpResultItemView mFirstItemView;
    private MicUpResultItemView mSecondItemView;
    private MicUpResultItemView mThirdItemView;
    private RecyclerView mRankList;
    private YYLinearLayout mShareContainer;
    private MicUpResultAdapter mMicUpResultAdapter;

    public MicUpResultAudiencePage(Context context, boolean isCloseInBottom) {
        super(context);
        this.createView(context, isCloseInBottom);
        this.initAdapter();
    }

    private void createView(Context context, boolean isCloseInBottom) {
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_mic_up_audience_page_channel, (ViewGroup)this);
        this.mCloseView = isCloseInBottom ? (RecycleImageView)rootView.findViewById(R.id.iv_bottom_close) : (RecycleImageView)rootView.findViewById(R.id.iv_top_close);
        this.mCloseView.setVisibility(0);
        this.mCloseView.setOnClickListener((View.OnClickListener)this);
        this.mFirstItemView = (MicUpResultItemView)rootView.findViewById(R.id.item_first);
        this.mSecondItemView = (MicUpResultItemView)rootView.findViewById(R.id.item_second);
        this.mThirdItemView = (MicUpResultItemView)rootView.findViewById(R.id.item_third);
        this.mThirdItemView.hideDividerLine();
        this.mRankList = (RecyclerView)rootView.findViewById(R.id.rank_list);
        this.mShareContainer = (YYLinearLayout)rootView.findViewById(R.id.ll_share_container);
    }

    private void initAdapter() {
        this.mMicUpResultAdapter = new MicUpResultAdapter();
        this.mRankList.setAdapter((RecyclerView.Adapter)this.mMicUpResultAdapter);
    }

    @Override
    public void renderHeader(@NonNull List<ResultInfo> resultInfoList) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpResult", (String)"audience page renderHeader: %s", (Object[])new Object[]{resultInfoList});
        }
        if (FP.empty(resultInfoList)) {
            return;
        }
        int size = resultInfoList.size();
        for (int index = 0; index < size; ++index) {
            ResultInfo resultInfo;
            if (index == 0) {
                resultInfo = resultInfoList.get(0);
                if (resultInfo == null) continue;
                this.mFirstItemView.renderItem(resultInfo);
                continue;
            }
            if (index == 1) {
                resultInfo = resultInfoList.get(1);
                if (resultInfo == null) continue;
                this.mSecondItemView.renderItem(resultInfo);
                continue;
            }
            if (index == 2) {
                resultInfo = resultInfoList.get(2);
                if (resultInfo == null) continue;
                this.mThirdItemView.renderItem(resultInfo);
                continue;
            }
            if (!FeatureLog.isLogLevelBlowInfo()) continue;
            FeatureLog.i((String)"FTMicUpResult", (String)"renderHeader error index: %d", (Object[])new Object[]{index});
        }
    }

    @Override
    public void renderRankList(List<ResultInfo> resultInfoList) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpResult", (String)"audience renderRankList: %s", (Object[])new Object[]{resultInfoList});
        }
        if (FP.empty(resultInfoList)) {
            if (this.mRankList != null) {
                this.mRankList.setVisibility(8);
            }
            return;
        }
        this.mMicUpResultAdapter.setData(resultInfoList);
    }

    @Override
    public void renderShareChannelList(List<BaseShareChannel> shareChannelList) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpResult", (String)"audience renderShareChannelList: %s", (Object[])new Object[]{shareChannelList});
        }
        if (FP.empty(shareChannelList)) {
            return;
        }
        for (BaseShareChannel shareChannel : shareChannelList) {
            int marginValue;
            if (shareChannel == null) continue;
            RecycleImageView imageView = new RecycleImageView(this.getContext());
            int idResId = 0;
            int iconResId = 0;
            switch (shareChannel.getId()) {
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp;
                    break;
                }
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
                case 0: {
                    idResId = R.id.share_others;
                    iconResId = R.drawable.profile_share_others_nor;
                    break;
                }
            }
            imageView.setId(idResId);
            imageView.setImageResource(iconResId);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)40.0f), ResolutionUtils.dip2Px((float)40.0f));
            params.leftMargin = marginValue = ResolutionUtils.dip2Px((float)10.0f);
            params.rightMargin = marginValue;
            params.gravity = 17;
            this.mShareContainer.addView((View)imageView, (ViewGroup.LayoutParams)params);
            imageView.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View view) {
        if (view == null) {
            return;
        }
        int viewId = view.getId();
        if (viewId == R.id.iv_bottom_close || viewId == R.id.iv_top_close) {
            if (this.mViewCallback != null) {
                this.mViewCallback.onCloseClick();
            }
        } else {
            this.share(ShareChannelIdDef.getChannelIdByViewId((int)viewId));
        }
    }

    private void share(int channelId) {
        if (channelId == -1) {
            return;
        }
        if (this.mViewCallback != null) {
            this.mViewCallback.onShareChannelClick(channelId);
        }
    }
}

