/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.hiyo.channel.plugins.micup.DR;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.panel.countdown.ICountDownCallback;
import com.yy.hiyo.channel.plugins.micup.panel.widget.MicUpCircleProgressBar;
import com.yy.hiyo.dyres.api.DyResLoader;

public class MicUpPanelCircleView
extends YYFrameLayout {
    private SVGAImageView mSVGAImageView;
    private RecycleImageView mBgView;
    private MicUpCircleProgressBar mProgressBarView;
    private AnimatorSet scaleAnimatorSet = new AnimatorSet();

    public MicUpPanelCircleView(Context context) {
        this(context, null);
    }

    public MicUpPanelCircleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MicUpPanelCircleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_mic_up_panel_circle_channel, (ViewGroup)this);
        this.mSVGAImageView = (SVGAImageView)this.findViewById(R.id.view_svga);
        this.mBgView = (RecycleImageView)this.findViewById(R.id.iv_bg);
        this.mProgressBarView = (MicUpCircleProgressBar)this.findViewById(R.id.iv_progress);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_X, (float[])new float[]{1.0f, 0.8f});
        scaleX.setRepeatMode(1);
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this), (Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.8f});
        scaleY.setRepeatMode(1);
        this.scaleAnimatorSet.playTogether(new Animator[]{scaleX, scaleY});
        this.scaleAnimatorSet.setDuration(200L);
        this.scaleAnimatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                MicUpPanelCircleView.this.setScaleX(1.0f);
                MicUpPanelCircleView.this.setScaleY(1.0f);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        Object tag = this.getTag();
        if (tag instanceof Integer && (Integer)tag == 1) {
            if (!this.scaleAnimatorSet.isRunning() && event.getAction() == 0) {
                this.scaleAnimatorSet.cancel();
                this.scaleAnimatorSet.start();
            }
        } else {
            this.scaleAnimatorSet.cancel();
        }
        return super.onTouchEvent(event);
    }

    @UiThread
    public void updateBackground(@DrawableRes int drawableResId) {
        this.mBgView.setBackgroundResource(drawableResId);
    }

    @UiThread
    public void setProgressVisibility(boolean show) {
        if (this.mProgressBarView != null) {
            if (show) {
                this.mProgressBarView.setVisibility(0);
            } else {
                this.mProgressBarView.setVisibility(8);
            }
        }
    }

    @UiThread
    public void updateProgress(int current, int total) {
        this.mProgressBarView.updateProgress(current, total);
    }

    @UiThread
    public int getProgress() {
        if (this.mProgressBarView != null) {
            return this.mProgressBarView.getProgress();
        }
        return -1;
    }

    @UiThread
    public void playSvga(final @NonNull ICountDownCallback callback) {
        if (this.mSVGAImageView != null) {
            this.mSVGAImageView.setCallback(new SVGACallback(){

                public void onPause() {
                }

                public void onFinished() {
                    if (callback != null) {
                        callback.finish();
                    }
                }

                public void onRepeat() {
                }

                public void onStep(int i, double v) {
                }
            });
            if (this.mSVGAImageView != null) {
                DyResLoader.INSTANCE.loadSvga(this.mSVGAImageView, DR.mic_up_btn_count_down, true);
            }
        }
    }
}

