/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.impl;

import android.content.Context;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.fileStorage.FileStorageRegistry;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.channel.plugins.micup.bean.AudioInfo;
import com.yy.hiyo.channel.plugins.micup.bean.MicupDataContext;
import com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.micup.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SongStatus;
import com.yy.hiyo.channel.plugins.micup.interfaces.IAudioManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataChangeNotify;
import com.yy.hiyo.channel.plugins.micup.interfaces.IPlaySongCallback;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.bean.event.VoiceCallBack;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IVoiceService;
import downloader.DownloadClient;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AudioManager
implements IAudioManager {
    private static final String TAG = "FTMicUpAudioManager";
    public static final int SELF_SAMPLE_RATE = 8000;
    public static final int SELF_RECORD_CHANNEL = 1;
    private Context context;
    private MicupDataContext dataContext;
    private VoiceCallBack voiceCallback = new VoiceCallBack(){

        public void onAudioCapturePcmData(byte[] data, int dataSize, int sampleRate, int channel) {
            AudioManager.this.onAudioCapturePcmData(data, dataSize, sampleRate, channel);
        }
    };
    private long lastpcmLog = 0L;
    private long pcmLogCounts = 0L;
    private AudioHelper audioDownloader;
    private CachePlaySongTask currentPendingPlaySongTask;
    private SongInfo currentRecordingSong;
    private ICommonCallback<SongStatus> songDownloadCallback = new ICommonCallback<SongStatus>(){

        public void onSuccess(SongStatus songStatus, Object ... ext) {
            String cachePath;
            songStatus.downloadState = 2;
            songStatus.localPath = cachePath = (String)ext[0];
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)AudioManager.TAG, (String)"downloadSong complete, url:%s, toFilePath:%s", (Object[])new Object[]{songStatus.song.audioUrl, cachePath});
            }
            if (AudioManager.this.currentPendingPlaySongTask != null && ((CachePlaySongTask)((AudioManager)AudioManager.this).currentPendingPlaySongTask).songInfo.songId.equals(songStatus.song.songId)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)AudioManager.TAG, (String)"cache song downloaded ,start play:%s", (Object[])new Object[]{AudioManager.this.currentPendingPlaySongTask.songInfo});
                }
                AudioManager.this.playSong(AudioManager.this.currentPendingPlaySongTask.songInfo, AudioManager.this.currentPendingPlaySongTask.callback);
            } else {
                MLog.error((Object)AudioManager.TAG, (String)"cache song play miss!!!, cur:%s, downloaded:%s", (Object[])new Object[]{AudioManager.this.currentPendingPlaySongTask != null ? ((CachePlaySongTask)((AudioManager)AudioManager.this).currentPendingPlaySongTask).songInfo.songId : "", songStatus.song.songId});
            }
        }

        public void onFail(int errCode, String msg, Object ... ext) {
            SongStatus songStatus = null;
            if (ext != null && ext.length >= 1) {
                songStatus = (SongStatus)ext[0];
                songStatus.downloadState = 3;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)AudioManager.TAG, (String)"downloadSong error, url:%s, errorType:%d, errorInfo:%s", (Object[])new Object[]{songStatus != null ? songStatus.song.audioUrl : "", errCode, msg});
            }
        }
    };
    private IMicupDataChangeNotify dataChangeNotify = new IMicupDataChangeNotify(){

        @Override
        public void onNextRoundNotify(int round) {
        }

        @Override
        public void onUserGetTheChanceNotify(long uid, int round, String avatar, String nick) {
        }

        @Override
        public void onSongIdentifyResultNotify(RoundInfo roundInfo) {
        }

        @Override
        public void onUpdateRoundInfoNotify(List<PlayerInfo> playerInfos, int errorCode, String errMsg) {
        }
    };

    public AudioManager(MicupDataContext dataContext) {
        this.dataContext = dataContext;
        dataContext.getVoiceRoom().getMediaService().registerOnSpeakListener(this.voiceCallback);
    }

    @Override
    public void onCreate(IMvpContext context) {
        this.context = context.getContext();
        if (this.audioDownloader == null) {
            this.audioDownloader = new AudioHelper();
            AudioHelper.initPath(this.getContext());
            this.updateSongList(this.getDataContext().getSongInfoList());
        }
    }

    private MicupDataContext getDataContext() {
        return this.dataContext;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void onDestroy(int reasonCode) {
        if (reasonCode == 1) {
            return;
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableCapturePcmDataCallBack(false, 8000, 1);
        this.currentPendingPlaySongTask = null;
        this.currentRecordingSong = null;
        this.getDataContext().getPreSongStatus().clear();
        this.getDataContext().getSelfAudioInfo().clear();
        this.audioDownloader.destroy();
        this.getDataContext().getVoiceRoom().getMediaService().unregisterOnSpeakListener(this.voiceCallback);
    }

    @Override
    public IMicupDataChangeNotify getNotify() {
        return this.dataChangeNotify;
    }

    @Override
    public void updateSongList(List<SongInfo> songs) {
        if (songs == null || songs.isEmpty()) {
            MLog.error((Object)TAG, (String)"input song list empty!!!", (Object[])new Object[0]);
            return;
        }
        ArrayList<SongInfo> songInfos = new ArrayList<SongInfo>(songs);
        for (SongInfo song : songInfos) {
            SongStatus songStatus = this.getDataContext().getPreSongStatus().get(song.songId);
            if (songStatus == null) {
                songStatus = new SongStatus(song);
                this.getDataContext().getPreSongStatus().put(song.songId, songStatus);
            }
            if (songStatus.downloadState == 2 || this.audioDownloader == null) continue;
            songStatus.downloadState = 1;
            this.audioDownloader.downloadSong(songStatus, (ICommonCallback<SongStatus>)this.songDownloadCallback);
        }
    }

    @Override
    public void playSong(final SongInfo songInfo, final IPlaySongCallback callback) {
        this.currentPendingPlaySongTask = null;
        if (songInfo == null || StringUtils.isEmpty((String)songInfo.audioUrl)) {
            MLog.error((Object)TAG, (String)"play song error,song:%s", (Object[])new Object[]{songInfo});
            return;
        }
        SongStatus songStatus = this.getDataContext().getPreSongStatus().get(songInfo.songId);
        if (songStatus == null) {
            MLog.error((Object)TAG, (String)"play song err, song not in the list", (Object[])new Object[0]);
            return;
        }
        if (songStatus.downloadState == 2) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"start play song:%s", (Object[])new Object[]{songInfo});
            }
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).startAudioMixing(songStatus.localPath, null, new IVoiceService.OnAudioPlayCallback(){

                public void onAudioFilePlayEnd() {
                    if (callback != null) {
                        callback.onSongPlayEnd(songInfo);
                    }
                }

                public void onAudioFilePlayFail(int errorCode) {
                    if (callback != null) {
                        callback.onSongPlayError(songInfo);
                    }
                    if (RuntimeContext.sIsDebuggable) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ToastUtils.showToast((Context)AudioManager.this.getContext(), (String)StringUtils.formatWitUSLocal((String)"\u8fd9\u9996\u6b4c\u7531\u4e8e\u683c\u5f0f\u95ee\u9898\u64ad\u4e0d\u51fa\u6765\uff01\uff01\uff01(%s)", (Object[])new Object[]{songInfo.musicName}), (int)0);
                            }
                        });
                    }
                }

                public void onAudioFilePlaySuccess() {
                    if (callback != null) {
                        callback.onSongPlayStart(songInfo);
                    }
                }
            }, false);
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cache play song:%s", (Object[])new Object[]{songInfo});
            }
            this.currentPendingPlaySongTask = new CachePlaySongTask(songInfo, callback);
            if (callback != null) {
                callback.onSongPreparing(songInfo);
            }
        }
    }

    @Override
    public void stopPlaySong(SongInfo songInfo) {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).stopAudioMixing();
    }

    @Override
    public void startSelfSinging(SongInfo songInfo) {
        if (songInfo == null) {
            MLog.error((Object)TAG, (String)"startSelfSinging input null song info error!!!", (Object[])new Object[0]);
            return;
        }
        if (this.currentRecordingSong != null) {
            MLog.error((Object)TAG, (String)"startSelfSinging should stop the previous record!!!previous song is %s", (Object[])new Object[]{this.currentRecordingSong});
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startSelfSinging song:%s", (Object[])new Object[]{songInfo});
        }
        this.currentRecordingSong = songInfo;
        this.getDataContext().getSelfAudioInfo().put(songInfo.songId, new AudioInfo(songInfo));
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableCapturePcmDataCallBack(true, 8000, 1);
    }

    @Override
    public void stopSelfSinging(final SongInfo songInfo) {
        if (songInfo == null) {
            MLog.error((Object)TAG, (String)"stopSelfSinging input null song info error!!!", (Object[])new Object[0]);
            return;
        }
        if (this.currentRecordingSong == null) {
            MLog.error((Object)TAG, (String)"stopSelfSinging can not invoke before startSelfSinging!!!", (Object[])new Object[0]);
            return;
        }
        if (!this.currentRecordingSong.songId.equals(songInfo.songId)) {
            MLog.error((Object)TAG, (String)"stopSelfSinging with different song, cur:%s, wanted stop:%s", (Object[])new Object[]{this.currentRecordingSong, songInfo});
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopSelfSinging song:%s", (Object[])new Object[]{songInfo});
        }
        this.currentRecordingSong = null;
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enableCapturePcmDataCallBack(false, 8000, 1);
        final AudioInfo audioInfo = this.getDataContext().getSelfAudioInfo().get(songInfo.songId);
        if (audioInfo == null) {
            MLog.error((Object)TAG, (String)"stopSelfSinging no save in cache!!!", (Object[])new Object[0]);
            return;
        }
        if (audioInfo.cachePcmAudio != null && audioInfo.cachePcmAudio.length > 0) {
            byte[] pcm2Acc = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).transformPcm2Acc(audioInfo.cachePcmAudio, 8000, 1);
            if (pcm2Acc != null) {
                audioInfo.cacheAccAudio = pcm2Acc;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"stopSelfSinging pcmSize:%d, transform acc data size:%d", (Object[])new Object[]{audioInfo.cachePcmAudio.length, audioInfo.cacheAccAudio != null ? audioInfo.cacheAccAudio.length : 0});
            }
            if (audioInfo.cacheAccAudio != null && audioInfo.cacheAccAudio.length > 0 && RuntimeContext.sIsDebuggable) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String localPath = AudioHelper.getSelfAacAudioFileDirPath(songInfo);
                        String pcmPath = AudioHelper.getSelfPcmAudioFileDirPath(songInfo);
                        File file = new File(AudioHelper.selfAudioFileDirPath);
                        if (!file.exists()) {
                            YYFileUtils.makeDirs((String)AudioHelper.selfAudioFileDirPath);
                        }
                        YYFileUtils.writeBytes((File)new File(localPath), (byte[])audioInfo.cacheAccAudio, (int)0, (int)audioInfo.cacheAccAudio.length);
                        YYFileUtils.writeBytes((File)new File(pcmPath), (byte[])audioInfo.cachePcmAudio, (int)0, (int)audioInfo.cachePcmAudio.length);
                        audioInfo.localPath = localPath;
                    }
                });
            }
        }
    }

    private void onAudioCapturePcmData(byte[] data, int dataSize, int sampleRate, int channel) {
        if (this.currentRecordingSong != null) {
            AudioInfo audioInfo = this.getDataContext().getSelfAudioInfo().get(this.currentRecordingSong.songId);
            if (audioInfo != null) {
                audioInfo.appendPcmData(data);
            }
            if (RuntimeContext.sIsDebuggable) {
                ++this.pcmLogCounts;
                if (System.currentTimeMillis() - this.lastpcmLog >= 1000L) {
                    this.lastpcmLog = System.currentTimeMillis();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"onAudioCapturePcmData data size:%d, sample:%d, channel:%d, logsum:%d, info:%s", (Object[])new Object[]{data != null ? data.length : 0, sampleRate, channel, this.pcmLogCounts, audioInfo});
                    }
                }
            }
        }
    }

    @Override
    public AudioInfo getSelfAudioInfo(SongInfo songInfo) {
        if (songInfo == null) {
            return null;
        }
        AudioInfo audioInfo = this.getDataContext().getSelfAudioInfo().get(songInfo.songId);
        return audioInfo == null ? new AudioInfo(songInfo) : audioInfo;
    }

    private static class CachePlaySongTask {
        private SongInfo songInfo;
        private IPlaySongCallback callback;

        public CachePlaySongTask(SongInfo songInfo, IPlaySongCallback callback) {
            this.songInfo = songInfo;
            this.callback = callback;
        }
    }

    private static class AudioHelper {
        private static String allAudioDirPath;
        private static String songFileDirPath;
        private static String selfAudioFileDirPath;

        private AudioHelper() {
        }

        private static void initPath(Context context) {
            allAudioDirPath = context.getFilesDir().getAbsolutePath() + File.separator + "micUp" + File.separator;
            songFileDirPath = allAudioDirPath + "preSong" + File.separator;
            selfAudioFileDirPath = allAudioDirPath + "selfAudio" + File.separator;
        }

        private static String getSongCacheFilePath(SongInfo songInfo) {
            String filePath = songFileDirPath + AudioHelper.getSongCacheFileName(songInfo);
            FileStorageRegistry.INSTANCE.extendLife(filePath);
            return filePath;
        }

        private static String getSongCacheFileName(SongInfo songInfo) {
            String temp;
            int index;
            String audio = songInfo.audioUrl;
            String lastStr = ".aac";
            if (StringUtils.isNotEmpty((String)audio) && (index = audio.lastIndexOf(".")) > 0 && StringUtils.isNotEmpty((String)(temp = audio.substring(index)))) {
                lastStr = temp;
            }
            return songInfo.musicName + "_" + songInfo.songId + lastStr;
        }

        private static String getSelfAacAudioFileDirPath(SongInfo songInfo) {
            return selfAudioFileDirPath + songInfo.musicName + "_" + songInfo.songId + ".aac";
        }

        private static String getSelfPcmAudioFileDirPath(SongInfo songInfo) {
            return selfAudioFileDirPath + songInfo.musicName + "_" + songInfo.songId + ".pcm";
        }

        private void downloadSong(final SongStatus songStatus, final ICommonCallback<SongStatus> callback) {
            final String songCachePath = AudioHelper.getSongCacheFilePath(songStatus.song);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)AudioManager.TAG, (String)"song downloading,song:%s", (Object[])new Object[]{songStatus.song});
            }
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (new File(songCachePath).exists()) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)AudioManager.TAG, (String)"song is in cache,song:%s, path:%s", (Object[])new Object[]{songStatus, songCachePath});
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess((Object)songStatus, new Object[]{songCachePath});
                            }
                        });
                        return;
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (songStatus.song == null || StringUtils.isEmpty((String)songStatus.song.audioUrl)) {
                                MLog.error((Object)AudioManager.TAG, (String)"song url null!!!", (Object[])new Object[0]);
                                callback.onFail(-1, "song url null!!!", new Object[]{songStatus});
                                return;
                            }
                            Downloader.Builder builder = new Downloader.Builder(songStatus.song.audioUrl, songFileDirPath, AudioHelper.getSongCacheFileName(songStatus.song));
                            builder.setSupportContinueTransfer(true);
                            builder.setTaskGroup(DownloadBussinessGroup.MICUP_FILE);
                            builder.setTaskMaxConcurrency(String.valueOf(DownloadBussinessGroup.getMaxConcurrencyByGroup((int)DownloadBussinessGroup.MICUP_FILE)));
                            builder.setCallBack(new IDownloadCallback(){

                                public void onComplete(Downloader downloader) {
                                    callback.onSuccess((Object)songStatus, new Object[]{songCachePath});
                                }

                                public void onError(Downloader downloader, int errorType, String errorInfo) {
                                    callback.onFail(errorType, errorInfo, new Object[]{songStatus});
                                }

                                public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                                    if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)AudioManager.TAG, (String)"gameDownloadFile, onProgressChange: totalSize:%d, curSize:%s", (Object[])new Object[]{totalSize, curSize});
                                    }
                                }

                                public void onStart(Downloader downloader) {
                                }
                            });
                            builder.build().start();
                        }
                    });
                }
            });
        }

        public void destroy() {
            DownloadClient.instance().removeAllByGroup(DownloadBussinessGroup.MICUP_FILE);
        }
    }
}

