/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.url;

import android.content.Context;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.unifyconfig.config.BackupHostConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UriHandler {
    private static String theOldHostSuffix = ".net";

    public static void init() {
        if (StringUtils.equal((String)theOldHostSuffix, (String)".net")) {
            theOldHostSuffix = ".ihago" + theOldHostSuffix;
        }
        URLUtils.setUrlHandler((URLUtils.IUrlHandler)new URLUtils.IUrlHandler(){

            public boolean isOurHost(String host) {
                return UriHandler.isOurHostInner(host);
            }

            public boolean isOurHostByUrl(String url) {
                return UriHandler.isOurHostByUrlInner(url);
            }

            public String replaceHttpByConfig(String url) {
                if (StringUtils.isEmpty((String)url)) {
                    return url;
                }
                String host = UriHandler.getHost(url);
                return UriHandler.replaceHttpByConfigInner(url, host);
            }

            public String replaceHttpByConfig(String url, String hostOfUrl) {
                return UriHandler.replaceHttpByConfigInner(url, hostOfUrl);
            }

            public String replaceUrl(String url) {
                return UriHandler.replaceUrlInner(url);
            }

            public String replaceUrl(String url, String hostOfUrl) {
                if (SystemUtils.isShowEnvSetting()) {
                    String yyHost = ".yy";
                    if (SystemUtils.isShowEnvSetting()) {
                        yyHost = yyHost + ".com";
                    }
                    if (url.contains(yyHost) || hostOfUrl.contains(yyHost)) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("\u5305\u542byy\u57df\u540d" + hostOfUrl), (int)1);
                        MLog.error((Object)"\u53bbYY\u5316", (String)"replaceUrl url: %s, hostUrl: %s", (Object[])new Object[]{url, hostOfUrl});
                    }
                }
                return UriHandler.replaceUrlInner(url, hostOfUrl);
            }

            public String replaceHost(String host) {
                return UriHandler.replaceHostInner(host);
            }

            public String replaceHostSuffix(String hostSuffix) {
                String replaceSuffix = BackupHostConfig.getFuzzyBackupHostSuffix((String)hostSuffix);
                return StringUtils.isEmpty((String)replaceSuffix) ? hostSuffix : replaceSuffix;
            }

            public List<String> getOurFirstHostSuffixList() {
                ArrayList<String> firstHostSuffixList = new ArrayList<String>(5);
                firstHostSuffixList.add(".ihago.net");
                firstHostSuffixList.add(theOldHostSuffix);
                firstHostSuffixList.add(".kaixindou.net");
                firstHostSuffixList.add(".ihago.net");
                firstHostSuffixList.add(".olaparty.com");
                firstHostSuffixList.add(".moschat.com");
                firstHostSuffixList.add(".ihago.net");
                firstHostSuffixList.add(".vparty.net");
                List list = BackupHostConfig.getOurFirstHostSuffixList();
                if (list != null && list.size() > 0) {
                    for (String item : list) {
                        if (item == null || firstHostSuffixList.contains(item)) continue;
                        firstHostSuffixList.add(item);
                    }
                }
                return firstHostSuffixList;
            }
        });
    }

    private static boolean isOurHostInner(String host) {
        if (StringUtils.isEmpty((String)host)) {
            return false;
        }
        if (host.endsWith(theOldHostSuffix) || host.endsWith(".moschat.com") || host.endsWith(".ihago.net") || host.endsWith(DebugTestUriProvider.TEST_HAGO_CN) || host.endsWith(".kaixindou.net") || host.endsWith(".kaixindou.fun") || host.endsWith(".iyoco.net") || host.endsWith(".vparty.net") || host.endsWith(".olaparty.com") || host.endsWith(".ihago.net") || host.endsWith("isoda-inforeceiver.duowan.com")) {
            return true;
        }
        List list = BackupHostConfig.getOurFirstHostSuffixList();
        if (list != null && list.size() > 0) {
            for (String item : list) {
                if (!host.endsWith(item) || !StringUtils.isNotEmpty((String)item)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOurHostByUrlInner(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        return UriHandler.isOurHostInner(UriHandler.getHost(url));
    }

    private static String getHost(String url) {
        URL uri = null;
        try {
            uri = new URL(url);
            return uri.getHost();
        }
        catch (Throwable e) {
            return "";
        }
    }

    private static String replaceUrlInner(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        String host = UriHandler.getHost(url);
        return UriHandler.replaceUrlInner(url, host);
    }

    private static String replaceUrlInner(String url, String hostOfUrl) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        String host = hostOfUrl;
        String replaceHost = BackupHostConfig.getExactBackupHost((String)host);
        if (StringUtils.isEmpty((String)replaceHost)) {
            String replaceUrl = BackupHostConfig.getFuzzyBackupUrl((String)url, (String)host);
            if (StringUtils.equal((String)replaceUrl, (String)url) && host.endsWith(theOldHostSuffix)) {
                return url.replaceFirst(theOldHostSuffix, ".ihago.net");
            }
            return replaceUrl;
        }
        url = url.replaceFirst(host, replaceHost);
        return url;
    }

    private static String replaceHostInner(String host) {
        if (StringUtils.isEmpty((String)host)) {
            return host;
        }
        String replaceHost = BackupHostConfig.getExactBackupHost((String)host);
        if (StringUtils.isEmpty((String)replaceHost)) {
            replaceHost = BackupHostConfig.getFuzzyBackupHost((String)host);
        }
        if (StringUtils.isNotEmpty((String)replaceHost)) {
            return replaceHost;
        }
        if (host.endsWith(theOldHostSuffix)) {
            return host.replaceFirst(theOldHostSuffix, ".ihago.net");
        }
        return host;
    }

    private static boolean isOssImageProcessHostInner(String url) {
        if ((url.startsWith("http://o-") || url.startsWith("https://o-")) && url.contains(".ihago.net")) {
            return true;
        }
        if ((url.startsWith("http://o-") || url.startsWith("https://o-")) && url.contains(theOldHostSuffix)) {
            return true;
        }
        if ((url.startsWith("http://o-") || url.startsWith("https://o-")) && url.contains(".moschat.com")) {
            return true;
        }
        if ((url.startsWith("http://o-") || url.startsWith("https://o-")) && url.contains(".ihago.net")) {
            return true;
        }
        if ((url.startsWith("http://o-") || url.startsWith("https://o-")) && url.contains(".vparty.net")) {
            return true;
        }
        List list = BackupHostConfig.getOurCdnFirstHostSuffixList();
        if (list != null && list.size() > 0) {
            for (String item : list) {
                if (!StringUtils.isNotEmpty((String)item) || !url.contains(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getImageBackupUrl(String url) {
        if (!RuntimeContext.sIsMainProcess) {
            return null;
        }
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        String supportUrl = "http://o-sg.";
        String replaceUrl = null;
        if (url.startsWith(supportUrl)) {
            replaceUrl = "http://o-ws-bts-ali-sg.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        supportUrl = "https://o-sg.";
        if (!RuntimeContext.sIsDebuggable && url.startsWith(supportUrl)) {
            replaceUrl = "https://o-ws-bts-ali-sg.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        supportUrl = "http://o-id.";
        if (url.startsWith(supportUrl)) {
            replaceUrl = "http://o-ws-bts-ali-id.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        supportUrl = "https://o-id.";
        if (!RuntimeContext.sIsDebuggable && url.startsWith(supportUrl)) {
            replaceUrl = "https://o-ws-bts-ali-id.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        if (RuntimeContext.sIsDebuggable) {
            return null;
        }
        supportUrl = "http://o-ws-bts-ali-sg.";
        if (url.startsWith(supportUrl)) {
            replaceUrl = "http://o-sg.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        supportUrl = "https://o-ws-bts-ali-sg.";
        if (!RuntimeContext.sIsDebuggable && url.startsWith(supportUrl)) {
            replaceUrl = "https://o-sg.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        supportUrl = "http://o-ws-bts-ali-id.";
        if (url.startsWith(supportUrl)) {
            replaceUrl = "http://o-id.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        supportUrl = "https://o-ws-bts-ali-id.";
        if (!RuntimeContext.sIsDebuggable && url.startsWith(supportUrl)) {
            replaceUrl = "https://o-id.";
            return url.replaceFirst(supportUrl, replaceUrl);
        }
        return url;
    }

    private static String replaceHttpByConfigInner(String url, String hostOfUrl) {
        if (BackupHostConfig.sReplaceAllHttpToHttps) {
            return URLUtils.replaceHttpToHttps((String)url);
        }
        if (BackupHostConfig.sReplaceOurUrlHttpToHttps && UriHandler.isOurHostInner(hostOfUrl)) {
            return URLUtils.replaceHttpToHttps((String)url);
        }
        return BackupHostConfig.replaceUrlHttpToHttps((String)url, (String)hostOfUrl);
    }
}

