/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.restart;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Process;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProcessPhoenix
extends Service {
    private static final String KEY_RESTART_INTENTS = "phoenix_restart_intents";

    static void triggerRebirth(Context context) {
        ProcessPhoenix.triggerRebirth(context, ProcessPhoenix.getRestartIntent(context));
    }

    static void triggerRebirth(Context context, Intent ... nextIntents) {
        Intent intent = new Intent(context, ProcessPhoenix.class);
        intent.addFlags(0x10000000);
        intent.putParcelableArrayListExtra(KEY_RESTART_INTENTS, new ArrayList<Intent>(Arrays.asList(nextIntents)));
        context.startService(intent);
        if (context instanceof Activity) {
            ((Activity)context).finish();
        }
        Runtime.getRuntime().exit(0);
    }

    private static Intent getRestartIntent(Context context) {
        String packageName = context.getPackageName();
        Intent defaultIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (defaultIntent != null) {
            defaultIntent.addFlags(0x10008000);
            return defaultIntent;
        }
        throw new IllegalStateException("Unable to determine default activity for " + packageName + ". Does an activity specify the DEFAULT category in its intent filter?");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        ArrayList intents = intent.getParcelableArrayListExtra(KEY_RESTART_INTENTS);
        this.startActivities(intents.toArray(new Intent[intents.size()]));
        this.stopSelf();
        Runtime.getRuntime().exit(0);
        return super.onStartCommand(intent, flags, startId);
    }

    static boolean isPhoenixProcess(Context context) {
        int currentPid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = manager.getRunningAppProcesses();
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.pid != currentPid || !processInfo.processName.endsWith(":phoenix")) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }
}

