/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class InterceptBackJsEvent
implements JsEvent {
    private static final String TAG = "InterceptBackJsEvent";
    private IWebBusinessHandler mWebHandler;
    private WebBusinessHandlerCallback mHandlerCallback = new WebBusinessHandlerCallback(){

        public void onWebViewDestroy() {
            InterceptBackJsEvent.this.mWebHandler = null;
        }

        public void onInterceptBack(int type2) {
            if (InterceptBackJsEvent.this.mWebHandler != null) {
                int backType = type2;
                if (type2 == 1) {
                    backType = 1;
                } else if (type2 == 2) {
                    backType = 2;
                }
                BaseJsParam param = BaseJsParam.builder().put("type", (Object)backType).build();
                InterceptBackJsEvent.this.mWebHandler.loadNotifyJs(JsEventDefine.NOTIFY.onInterceptBack.notifyName(), param.toJson());
            }
        }
    };

    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.interceptBack;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        this.mWebHandler = webHandler;
        this.mWebHandler.addWebViewListener(this.mHandlerCallback);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                InterceptBackJsEvent.this.interceptBack(webHandler, param, callback);
            }
        });
    }

    private void interceptBack(@NonNull IWebBusinessHandler webHandler, @NonNull String paramJson, @Nullable IJsEventCallback callback) {
        block2: {
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
                boolean intercept = jo.optBoolean("intercept", false);
                int inter = intercept ? 3 : 0;
                webHandler.interceptBack(inter);
            }
            catch (JSONException e) {
                if (callback == null) break block2;
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback.callJs((IJsParam)err);
            }
        }
    }
}

