/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameResultShareService;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.IShareResultCallback;
import com.yy.socialplatformbase.callback.IShareCallBack;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import org.jetbrains.annotations.NotNull;

class ShareJsEvent
implements JsEvent,
INotify {
    private static final String TAG = "ShareJsEvent";
    private final JsEventControllerCallback mControllerCallback;
    private IWebBusinessHandler mWebHandler;
    private IJsEventCallback mEventCallback;
    private boolean mIsSingleGameSharing;
    private ShareParam mShareParam;
    private WebBusinessHandlerCallback mHandlerCallback = new WebBusinessHandlerCallback(){

        public void onWebViewDestroy() {
            super.onWebViewDestroy();
            if (ShareJsEvent.this.mWebHandler != null) {
                ShareJsEvent.this.mWebHandler.addWebViewListener(null);
            }
            ShareJsEvent.this.mWebHandler = null;
            ShareJsEvent.this.mEventCallback = null;
            ShareJsEvent.this.mIsSingleGameSharing = false;
            ShareJsEvent.this.mShareParam = null;
        }
    };

    ShareJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.share;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        this.mEventCallback = callback;
        this.mWebHandler = webHandler;
        this.mWebHandler.addWebViewListener(this.mHandlerCallback);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ShareJsEvent.this.shareAsync(param, callback);
            }
        });
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && ((Boolean)notification.extObj).booleanValue()) {
            this.shareCallback(1, "");
        }
    }

    private void shareAsync(@NonNull String paramJson, @Nullable IJsEventCallback callback) {
        ShareParam param = null;
        try {
            param = (ShareParam)JsonParser.parseJsonObject((String)paramJson, ShareParam.class);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"shareAsync Exception=%s", (Object[])new Object[]{e});
            return;
        }
        this.mShareParam = param;
        if (param != null) {
            if ("nativeShareSingleGame".equals(param.oldMethod)) {
                this.nativeShareSingleGame(paramJson);
            } else if ("activityShare".equals(param.oldMethod)) {
                final ShareParam finalParam = param;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShareJsEvent.this.mIsSingleGameSharing = true;
                        ((IIntlShareService)ShareJsEvent.this.mControllerCallback.getService().getService(IIntlShareService.class)).webShare(finalParam.shareType, finalParam.title, finalParam.content, finalParam.image, finalParam.webUrl);
                    }
                });
            } else {
                String imagePath;
                if ((TextUtils.isEmpty((CharSequence)param.imagePath) || param.imagePath.startsWith("http")) && !TextUtils.isEmpty((CharSequence)param.imageBase64) && !TextUtils.isEmpty((CharSequence)(imagePath = BitmapUtils.base64ToFile((String)param.imageBase64, (String)"webShareImage")))) {
                    param.imagePath = imagePath;
                }
                final ShareParam finalParam1 = param;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShareJsEvent.this.mIsSingleGameSharing = true;
                        ShareData.Builder shareDataBuilder = ShareData.builder();
                        shareDataBuilder.type(finalParam1.type);
                        shareDataBuilder.to(finalParam1.to);
                        shareDataBuilder.text(finalParam1.content);
                        shareDataBuilder.gotoUrl(finalParam1.webUrl);
                        shareDataBuilder.title(finalParam1.title);
                        shareDataBuilder.imgPath(TextUtils.isEmpty((CharSequence)finalParam1.imagePath) ? finalParam1.image : finalParam1.imagePath);
                        shareDataBuilder.systemShare(finalParam1.isSystemShare);
                        ((IIntlShareService)ShareJsEvent.this.mControllerCallback.getService().getService(IIntlShareService.class)).commonWebShare(finalParam1.shareType, shareDataBuilder.build(), new IShareResultCallback(){

                            public void onResult(int code, @NotNull String msg) {
                                ShareJsEvent.this.shareCallback(code, msg);
                            }
                        });
                    }
                });
            }
        } else if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
            callback.callJs((IJsParam)err);
        }
    }

    private void shareCallback(int shareCode, String shareMsg) {
        if (!this.mIsSingleGameSharing) {
            return;
        }
        this.mIsSingleGameSharing = false;
        if (this.mEventCallback != null) {
            BaseJsParam.DataBuilder builder = BaseJsParam.builder();
            builder.put("shareCode", (Object)shareCode).put("shareMsg", (Object)shareMsg);
            if (this.mShareParam != null) {
                builder.put("activityId", (Object)this.mShareParam.activityId);
                builder.put("shareType", (Object)this.mShareParam.shareType);
            }
            this.mEventCallback.callJs((IJsParam)builder.build());
        } else if (shareCode == 1 && this.mWebHandler != null) {
            this.mWebHandler.loadPureJs("callWebviewMethod('onShareSuccess')");
            this.mWebHandler.loadNotifyJs(JsEventDefine.NOTIFY.onActivityShareSuccess.notifyName(), "");
        }
    }

    private void nativeShareSingleGame(String paramJson) {
        SingleGameShareParam param = (SingleGameShareParam)JsonParser.parseJsonObject((String)paramJson, SingleGameShareParam.class);
        int platformId = 2;
        switch (param.shareType) {
            case 1: {
                platformId = 2;
                break;
            }
            case 2: {
                platformId = 3;
                break;
            }
            case 3: {
                platformId = 5;
                break;
            }
            case 4: {
                platformId = 1;
                break;
            }
        }
        GameInfo gameInfo = ((IGameInfoService)this.mControllerCallback.getService().getService(IGameInfoService.class)).getGameInfoByGid(param.gameId);
        if (gameInfo != null && !this.mIsSingleGameSharing) {
            this.mIsSingleGameSharing = true;
            ((IGameResultShareService)this.mControllerCallback.getService().getService(IGameResultShareService.class)).share(platformId, gameInfo.getGid(), gameInfo.getGname(), gameInfo.getSingleGameShareBgUrl(), param.score, false, true, new IShareCallBack(){

                public void onShareSuccess(ShareData data) {
                    ShareJsEvent.this.shareCallback(1, "");
                }

                public void onShareCanceled(ShareData data) {
                    ShareJsEvent.this.shareCallback(2, "");
                }

                public void onShareError(ShareData data, Exception e) {
                    ShareJsEvent.this.shareCallback(0, "");
                }
            }, false);
        }
    }

    static class SingleGameShareParam {
        @SerializedName(value="shareType")
        int shareType;
        @SerializedName(value="gameId")
        String gameId;
        @SerializedName(value="score")
        int score;
        @SerializedName(value="bestScore")
        int bestScore;

        SingleGameShareParam() {
        }
    }

    static class ShareParam {
        @SerializedName(value="oldMethod")
        String oldMethod;
        @SerializedName(value="activityId")
        String activityId = "";
        @SerializedName(value="shareType")
        int shareType;
        @SerializedName(value="type")
        int type;
        @SerializedName(value="to")
        int to;
        @SerializedName(value="title")
        String title = "";
        @SerializedName(value="image")
        String image = "";
        @SerializedName(value="imageBase64")
        String imageBase64 = "";
        @SerializedName(value="audioPath")
        String audioPath = "";
        @SerializedName(value="webUrl")
        String webUrl = "";
        @SerializedName(value="content")
        String content = "";
        @SerializedName(value="isSystemShare")
        boolean isSystemShare = false;
        @SerializedName(value="imagePath")
        String imagePath = "";

        ShareParam() {
        }
    }
}

